//$Id: text.cc,v 1.3 2001/11/06 12:54:55 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "text.h"

using namespace Guikachu::GUI;
using std::string;

TextArea::TextArea (Property<string> &text_):
    text (text_),
    update_block (false)
{
    using SigC::slot;
    
    set_word_wrap (true);
    set_editable (true);
    
    changed.connect (slot (this, &TextArea::changed_cb));
    
    text.changed.connect (slot (this, &TextArea::update));
    update ();
}

void TextArea::changed_cb ()
{
    if (update_block)
        return;

    int saved_pos = get_position ();

    gchar *text_chars = gtk_editable_get_chars (
	GTK_EDITABLE (gtkobj ()), 0, get_length ());
    text = text_chars;
    g_free (text_chars);
    
    gtk_editable_set_position (GTK_EDITABLE (gtkobj ()), saved_pos);
}

void TextArea::update ()
{
    update_block = true;

    if (get_length ())
	delete_text (0, get_length ());
    insert (text);

    update_block = false;
}
