#include "Environment.h"
#include "ProcessRunner.h"

#include <stdio.h>
#include <iostream>

#define DEBUG(args...) fprintf(stderr, ##args)
//#define DEBUG(args...) do {} while(0)

using namespace std;

class ProcessPrinter : public ProcessListener
{
public:
	virtual void handleTermination(const std::string& tag, int status) throw ()
	{
		cout << tag << ": terminated with status " << status << endl;
	}
};


int main(int argc, char* argv[])
{
	try {
		wibble::exception::InstallUnexpected installUnexpected;

		Environment::get().debug(true);

		{
			fprintf(stderr, "\t\tInitializing process runner...\n");
			ProcessRunner pr;
			fprintf(stderr, "\t\tInitialized process runner...\n");
		}

		fprintf(stderr, "\t\tReinitializing process runner...\n");
		ProcessPrinter pp;
		ProcessRunner pr;

		fprintf(stderr, "\t\tAdding processes...\n");
		pr.addProcess("test1", "sleep 1", &pp);
		pr.addProcess("test2", "sleep 2", &pp);
		pr.addProcess("test2a", "sleep 2", &pp);
		pr.addProcess("test0", "true", &pp);
		pr.addProcess("test3", "false", &pp);
		pr.addProcess("test2b", "sleep 2", &pp);
		pr.addProcess("test1a", "sleep 1", &pp);

		fprintf(stderr, "\t\tSleeping...\n");
		sleep(2);
		fprintf(stderr, "\t\tShutting down...\n");
		pr.shutdown();

		fprintf(stderr, "\t\tDone.\n");
	}
	catch (std::exception& e)
	{
		error("%s", e.what());
		return 1;
	}
	return 0;
}
