#ifndef NETWATCHER_H
#define NETWATCHER_H

/*
 * Thread to capture packets from a network
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <wibble/exception.h>
#include <wibble/sys/netbuffer.h>
#include "nettypes.h"
#include <string>

namespace wibble {
namespace exception {

class Pcap : public Generic
{
protected:
	std::string _pcap_errmsg;

public:
	Pcap(const std::string& pcap_errmsg, const std::string& context) throw ()
		: Generic(context), _pcap_errmsg(pcap_errmsg) {}
	Pcap(const std::string& context) throw ()
		: Generic(context), _pcap_errmsg() {}
	~Pcap() throw () {}

	virtual const char* type() const throw () { return "pcap"; }

	virtual std::string desc() const throw ()
	{
		if (_pcap_errmsg.size())
			return _pcap_errmsg;
		else
			return "Unknown pcap error";
	}
};

}
}

class PacketListener
{
public:
	virtual ~PacketListener() {}
	virtual void handleARP(const wibble::sys::NetBuffer& pkt) throw () {}
	virtual void handleDHCP(const wibble::sys::NetBuffer& pkt) throw () {}
	virtual void handleICMP(const wibble::sys::NetBuffer& pkt) throw () {}
	virtual void handleEthernet(const wibble::sys::NetBuffer& pkt) throw () {}
};

/*
 * Injects ethernet packets to a given interface.
 *
 * Every method is thread-safe
 */
class NetWatcherImpl;

class NetWatcher
{
protected:
	NetWatcherImpl* impl;
	
public:
	NetWatcher(const std::string& iface) throw (wibble::exception::System, wibble::exception::Pcap);
	NetWatcher(const NetWatcher& f) throw ();
	~NetWatcher() throw (wibble::exception::System);
	NetWatcher& operator=(const NetWatcher& f) throw (wibble::exception::System);

	struct ether_addr* getMACAddress() throw (wibble::exception::Pcap);

	void addARPListener(PacketListener* pl) throw ();
	void addDHCPListener(PacketListener* pl) throw ();
	void addICMPListener(PacketListener* pl) throw ();
	void addEthernetListener(PacketListener* pl) throw ();

	void shutdown() throw ();
};

// vim:set ts=4 sw=4:
#endif
