/* Implementation of the Wheel mouse feature - connects
 * directly to a GtkAdjustment */

#include <stdlib.h>
#include <gtk/gtk.h>

typedef struct 
{
	GtkAdjustment *a;
	gfloat factor;
} wheel_cb_info;


static void wheel_callback (GtkWidget *w,
			    GdkEventButton *event,
			    gpointer data)
{
	wheel_cb_info *i;
	
	i=(wheel_cb_info*)data;
	if (event->button==4)
	  {
		  if (i->a->value-i->a->step_increment*i->factor>=i->a->lower)
		      gtk_adjustment_set_value(i->a,i->a->value-i->factor*i->a->step_increment);
		  else 
		      gtk_adjustment_set_value(i->a,i->a->lower);
	  }
	;
	if (event->button==5)
	  {
		  if (i->a->value+i->a->step_increment*i->factor<i->a->upper)
		      gtk_adjustment_set_value(i->a,i->a->value+i->factor*i->a->step_increment);
	  }
	;
}
;


void wheel_connect(GtkWidget *w,GtkAdjustment *a,gfloat factor) // catch any wheel events and update GtkAdjustment appropriately
{
	wheel_cb_info *inf;
	
	inf=(wheel_cb_info*)malloc(sizeof(wheel_cb_info));
	inf->a=a;
	inf->factor=factor;
	
	gtk_signal_connect(GTK_OBJECT(w),"button_press_event",
			   GTK_SIGNAL_FUNC(wheel_callback),inf);
}
;

