/* Track handling functions used by Track editor and writing services */

#include <stdlib.h>
#include <stdio.h>

#include "int.h"

#include "main.h"
#include "preferences.h"
#include "tracks.h"

/* uncomment for debugging */
// #define DEBUG
//
/* a current list of tracktype definitions - they arent complete,but
 * these are the most important ones */
char *tracks_tracktypedefinitions[]=
{
   "data","audio",NULL
};
/* the corresponding sector sizes */
int   tracks_tracktypesectorsizes[]=
{
   2048,CDDASECTORSIZE
};

int tracks_tracktypeid(char *tt)
{
   int i;
   int id=0;

   for(i=0;tracks_tracktypedefinitions[i]!=NULL;i++)
     if (!strcmp(tracks_tracktypedefinitions[i],tt))
       id=i;

#ifdef DEBUG
   printf ("tracks_tracktypeid: id for %s is %i\n",tt,id);
#endif

   /* return corresponding track id or zero (datatrack) as a
    * default,if not found */
   return id;
};

tracks_trackinfo *tracks_create(char *name,

				const char *title,
				const char *performer,

				tracks_tracktype type,
				tracks_precache precacherequired,
				int  (*openpipe)(void*),
				void (*closepipe)(void*),
				int  (*tracksize)(void*),
				int  (*dataavail)(void*),
				int  (*valid)(void*),
				void (*destroy)(void*),
				void *data)
{
   tracks_trackinfo *ti;

   ti=(tracks_trackinfo*)malloc(sizeof(tracks_trackinfo));
   
   strcpy(ti->name,name);  
   
   if (!title)
     title="";
   if (!performer)
     performer="";
   
   strcpy(ti->title,title);
   strcpy(ti->performer,performer);
   
   ti->data=data;
   ti->tracktype=(char*)malloc(strlen(type)+1);
   strcpy(ti->tracktype,type);
   ti->precacherequired=precacherequired;
	/* initialize user count with one here */
   ti->users=1;
	/* no updatehandlers installed yet */
   ti->updatehandlers=NULL;

   ti->openpipe=openpipe;
   ti->closepipe=closepipe;
   ti->tracksize=tracksize;
   ti->dataavail=dataavail;
   ti->valid=valid;
   ti->destroy=destroy;

   return ti;
}
;

int tracks_openpipe(tracks_trackinfo*ti)
{
#ifdef DEBUG
   printf ("track.c: calling openpipe() for track %s\n",
	   ti->name);
#endif
   return ti->openpipe(ti);
}
;

void tracks_closepipe(tracks_trackinfo*ti)
{
   ti->closepipe(ti);
}
;

int tracks_tracksize(tracks_trackinfo*ti)
{
   return ti->tracksize(ti);
}
;

/* return size of the audiotrack containing the specified track on the cd to be written */
int tracks_audiotracksize(tracks_trackinfo*ti)
{
   return ((ti->tracksize(ti)/tracks_sectorsize(ti->tracktype))*CDDASECTORSIZE);
}
;

int tracks_dataavail(tracks_trackinfo*ti)
{
   return ti->dataavail(ti);
}
;

int tracks_valid(tracks_trackinfo*ti)
{
   return ti->valid(ti);
}
;

void tracks_claim(tracks_trackinfo*ti)
{
   ti->users++;
#ifdef DEBUG
   printf ("claimed track %s (new users count:%i) \n",ti->name,ti->users);
#endif
};

void tracks_unclaim(tracks_trackinfo*ti)
{
#ifdef DEBUG
   printf ("unclaiming track %s (users before unclaim():%i) \n",ti->name,ti->users);
#endif
   if (!--ti->users)
     {
#ifdef DEBUG
	printf("Track has no more users. destroyed.\n");
#endif
	ti->destroy(ti);
	free(ti->tracktype);
	free(ti);
     }
   ;
}
;

int tracks_users(tracks_trackinfo*ti)
{
   return ti->users;
}
;

