/* The Type of Track representing a raw cd track coming directly from cdrom */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "int.h"

#include "main.h"
#include "tracks.h"
#include "datatrack.h"
#include "cddrives.h"
#include "cdromlow.h"
#include "varman.h"
#include "preferences.h"
#include "dialog.h"

#define datatrack_getprecachingflag \
      (!strcmp(varman_getvar(global_defs,"datatrack_precache"),"true")) \
        *atadd

int datatrack_openpipe(void*trackinfo)
{
   datatrack_info *i;

   i=(datatrack_info*)((tracks_trackinfo*)trackinfo)->data;

   if (i->filedes==-1)
     {
	/* we can only read the first datatrack of a CD right now */
	if (i->tracknum==1)
	  {
	     i->filedes=open(i->device,O_RDONLY);
	     if (i->filedes==-1)
	       perror ("error opening data track");
	     else
	       cddrives_updatedisable();
	  };
     }
   ;
   return i->filedes;
}
;

void datatrack_closepipe(void*trackinfo)
{
   datatrack_info *i;

   i=(datatrack_info*)((tracks_trackinfo*)trackinfo)->data;
   if (i->filedes!=-1)
     {
	close(i->filedes);
	i->filedes=-1;
	cddrives_updateenable();
     }
   ;

}
;

int datatrack_tracksize(void*trackinfo)
{
   datatrack_info *i;

   i=(datatrack_info*)((tracks_trackinfo*)trackinfo)->data;

   return i->tracksize;
}
;

int datatrack_dataavail(void*trackinfo)
{
   datatrack_info *i;

   i=(datatrack_info*)((tracks_trackinfo*)trackinfo)->data;

   return (i->filedes!=-1);
}
;

/* FIXME: add function tracks_invalidate() to tracks.h to regulate
 * the availability of the tracks located on a cdrom */
int  datatrack_valid(void*trackinfo)
{
   datatrack_info *i;
   tracks_trackinfo *info=(tracks_trackinfo*)trackinfo;

   i=(datatrack_info*)((tracks_trackinfo*)trackinfo)->data;
   /* only the first datatrack on a CD can be used */
   if (i->tracknum!=1)
     {
	const char *string=_("%s:\nOnly the first data track of a CD can be used as a\ndata source right now.");
	char *buffer=(char*)malloc(strlen(string)+strlen(info->name)+1);
	sprintf(buffer,string,info->name);
	dialog_error(buffer);
	free(buffer);
     };
   return (i->tracknum==1);
}
;

void datatrack_destroy(void*trackinfo)
{
   datatrack_info *i;

   i=(datatrack_info*)((tracks_trackinfo*)trackinfo)->data;

   if (datatrack_dataavail(trackinfo))
     close (i->filedes);
   free(i);
}
;

void datatrack_pc_policy_changed(VARMAN_VAR_ENTRY *var,gpointer data)
{
   ((tracks_trackinfo*)data)->precacherequired=datatrack_getprecachingflag;
};

tracks_trackinfo *datatrack_create(char *device,int tracknum)
{
   tracks_trackinfo *dt;
   datatrack_info *info;
   char description[256];
   int tochandle=cdromlow_gettochandle(device);

   info=(datatrack_info*)malloc(sizeof(datatrack_info));
   strcpy(info->device,device);
   info->filedes=-1;
   info->tracknum=tracknum;
   if (tochandle)
     info->tracksize=cdromlow_datatracksize(tochandle,tracknum);
   else
     info->tracksize=0;

   if (tochandle)
     sprintf(description,_("Datatrack #%2i of CD %#x"),
	     tracknum,cdromlow_cddbnumber(tochandle));
   else
     sprintf(description,_("Datatrack #%02i of disc in drive %s"),
	     tracknum,device);
   dt=tracks_create(description,
		    NULL,
		    NULL,
		    "data",datatrack_getprecachingflag,
		    datatrack_openpipe,
		    datatrack_closepipe,
		    datatrack_tracksize,
		    datatrack_dataavail,
		    datatrack_valid,
		    datatrack_destroy,
		    info);

   varman_install_handler(global_defs,"datatrack_precache",
			  datatrack_pc_policy_changed,
			  dt);

   if (tochandle)
     cdromlow_closetochandle(tochandle);
   return dt;
}
;

