/* The Type of Track representing an audiotrack located on a cdrom */

#ifndef AUDIOTRACK_H
#define AUDIOTRACK_H

#include "tracks.h"
#include "cddb.h"

typedef struct 
{
	/* FIXME: do not refer to cds using the device they reside in but
	 * rather the unique cd identifier */
	char device[63];
	int  tracknum;
	int  tracksize; /* read in on audiotrack_create,as the tracksize normally doesnt change */
	int  cdda2wavpipe;
	int  cdda2wavpid;
	int  cdda2wavstatus;
        int  cddbrequestid;
} audiotrack_info;
	
tracks_trackinfo *audiotrack_create(char *device,
				    int tracknum,
				    // title and performer,
				    // if already known (CD-Text)
				    // NULL otherwise
				    const char *title,
				    const char *performer,
				    cddb_essentials *es);
void audiotrack_init();

#endif // AUDIOTRACK_H
