/* 
 * Copyright (c) Tony Bybell 1999.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 */

#ifndef GTKWAVE_STRACE_H
#define GTKWAVE_STRACE_H

#include <gtk/gtk.h>
#include <string.h>
#include "debug.h"
#include "analyzer.h"
#include "currenttime.h"
#include "bsearch.h"

enum strace_directions
{ STRACE_BACKWARD, STRACE_FORWARD };
         
struct strace_back
{
struct strace *parent;
int which;
};

struct strace
{
struct strace *next;   
char *string;           /* unmalloc this when all's done! */
Trptr trace;
char value;
char search_result;

union
	{
        hptr    h;             /* what makes up this trace */
        vptr    v;
      	} his;

struct strace_back *back[9];    /* dealloc these too! */   
};


struct timechain
{
struct timechain *next;
TimeType t;
};


extern struct strace *straces;
extern TimeType *timearray;
extern int timearray_size;

void strace_error(void);
void strace_search(int direction);
void strace_maketimetrace(int mode); /* 1=create, zero=delete */

#endif

