/*  GTKtalog.
 *  Copyright (C) 2000  Yves Mettier
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


%{
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include "config_common.h"
#include "interface.h"
#include "addisk.h"
#include "io.h"
#include "setup.h"
#if (defined(OS_LINUX) || defined(__APPLE__) || defined(OS_FREEBSD) || defined(OS_NETBSD) || defined(OS_OPENBSD))
#if defined(HAVE_GETFSENT)
#include <fstab.h>
#endif
#endif
GList *local_config;

%}

%union {
	gint		val;
	gint		toolbarstyle;
        gint            sizeformat;
	gint		vfslast_column;
	char		*string;
	gboolean        gbool;  
	GString		*gstring;
	GArray		*garray;
	GList		*glist;
	KEY_VALUE	*kv;
}

/* not used yet
%type <glist>		INTEGERS
*/
%type <glist>		STRINGS
%type <gstring>		GSTRING
%type <kv>		one_line
%type <glist>		lines
%type <glist>		config_file

%type <kv>		line_ADDEXTICON
%token 			ADDEXTICON

%type <kv>		line_ADDMIMEICON
%token 			ADDMIMEICON

%type <kv>		line_DEFAULTDIRICON
%token 			DEFAULTDIRICON

%type <kv>		line_DEFAULTDISKICON
%token 			DEFAULTDISKICON

%type <kv>		line_DEFAULTFILEICON
%token 			DEFAULTFILEICON

%type <kv>		line_DEFAULTUNREADABLEICON
%token 			DEFAULTUNREADABLEICON

%type <kv>		line_DEFAULTVFSICON
%token 			DEFAULTVFSICON

%type <kv>		line_DEFAULTOPENEDDIRICON
%token 			DEFAULTOPENEDDIRICON

%type <kv>		line_DEFAULTOPENEDDISKICON
%token 			DEFAULTOPENEDDISKICON

%type <kv>		line_DEFAULTOPENEDVFSICON
%token 			DEFAULTOPENEDVFSICON

%type <kv>		line_MOUNTPROGRAM
%token 			MOUNTPROGRAM

%type <kv>		line_UMOUNTPROGRAM
%token 			UMOUNTPROGRAM

%type <kv>		line_EJECTPROGRAM
%token 			EJECTPROGRAM

%type <kv>		line_MOUNTPOINT
%token 			MOUNTPOINT

%type <kv>		line_USESUDO
%token 			USESUDO

%type <kv>		line_USEAUTOMOUNT
%token 			USEAUTOMOUNT

%type <kv>		line_MOUNTRETRY
%token 			MOUNTRETRY

%type <kv>		line_EXTENSION
%token 			EXTENSION

%type <kv>		line_OPTIONDUS
%token 			OPTIONDUS

%type <kv>		line_OPTIONWARNMOUNT
%token 			OPTIONWARNMOUNT

%type <kv>		line_OPTIONEJECT
%token 			OPTIONEJECT

%type <kv>		line_READCDNAME
%token 			READCDNAME

%type <kv>		line_VALIDATECDNAME
%token 			VALIDATECDNAME

%type <kv>		line_COMPRESSIONLEVEL
%token 			COMPRESSIONLEVEL

%type <kv>		line_TESTVFS
%token 			TESTVFS

%type <kv>		line_VFSEXTENSION
%token 			VFSEXTENSION

%type <kv>		line_MIMEEXTENSION
%token 			MIMEEXTENSION

%type <kv>		line_MIMEVFSEXTENSION
%token 			MIMEVFSEXTENSION

%type <kv>		line_READINFORMATION
%token 			READINFORMATION

%type <kv>		line_DEFAULTMIMEEXTENSION
%token 			DEFAULTMIMEEXTENSION

%type <kv>		line_SCANMIMETYPES
%token 			SCANMIMETYPES

%type <kv>		line_ADDMIMETOSKIP
%token 			ADDMIMETOSKIP

%type <kv>		line_USEDEFAULTMIMEPLUGIN
%token 			USEDEFAULTMIMEPLUGIN

%type <kv>		line_DBCLICKFORINFO
%token 			DBCLICKFORINFO

%type <kv>		line_DISPLAYDIRSIZE
%token 			DISPLAYDIRSIZE

%type <kv>		line_DATEFORMAT
%token 			DATEFORMAT

%type <kv>		line_SIZEFORMAT
%token 			SIZEFORMAT

%type <kv>		line_RECENTFILE
%token 			RECENTFILE

%type <kv>		line_RECENTFILESMAX
%token 			RECENTFILESMAX

%type <kv>		line_PREVIOUSSEARCHMODE
%token 			PREVIOUSSEARCHMODE

%type <kv>		line_SAVEONLYUSEDCATEGORIES
%token 			SAVEONLYUSEDCATEGORIES

%type <kv>		line_MAINWINDOWPOSITION
%token 			MAINWINDOWPOSITION

%type <kv>		line_TREEWINDOWSIZE
%token 			TREEWINDOWSIZE

%type <kv>		line_FILETOLOAD
%token 			FILETOLOAD

%type <kv>		line_LOADFILEATBOOT
%token 			LOADFILEATBOOT

%type <kv>		line_AUTOSAVE
%token 			AUTOSAVE

%type <kv>		line_KEEPBACKUPFILE
%token 			KEEPBACKUPFILE

%type <kv>		line_MINUTESBEFOREAUTOSAVE
%token 			MINUTESBEFOREAUTOSAVE

%type <kv>		line_TOOLBARSTYLE
%token 			TOOLBARSTYLE

%type <kv>		line_NEWSEARCHTYPE
%token 			NEWSEARCHTYPE

%type <kv>		line_WORKINGPATH
%token 			WORKINGPATH

%type <kv>		line_STRICTALPHABETICSORT
%token 			STRICTALPHABETICSORT

%type <kv>		line_DISPLAYSPLASH
%token 			DISPLAYSPLASH

%token <string>		STRING
%token <string>		QSTRING
%token <gbool>	        GBOOLEAN
%token <gint>		STRINGLOCALE
%token <gint>		STRINGISO8601
%token <toolbarstyle>	TOOLBAR_STYLE_INT
%token <sizeformat>	SIZE_FORMAT_INT
%token <vfslast_column>	VFS_LAST_COLUMN_INT

/* not used yet
%token <string>	EMAIL
%token 			TO
*/
%token <val>	INTEGER
%token 			EOL

%%
config_file: 	lines	{ local_config = $1; }
		;

lines:		one_line lines		{{
						if($1) {
							$$ = g_list_prepend($2, $1);
						} else {
							$$ = $2;
						}
					}}
		| one_line		{{ 
						if($1) {
							$$ = g_list_append(NULL, $1);
						} else {
							$$ = NULL;
						}
					}}
		;

one_line:	line_ADDEXTICON EOL					{ $$ = $1; }
		| line_ADDMIMEICON EOL					{ $$ = $1; }
		| line_DEFAULTFILEICON EOL				{ $$ = $1; }
		| line_DEFAULTDIRICON EOL				{ $$ = $1; }
		| line_DEFAULTDISKICON EOL				{ $$ = $1; }
		| line_DEFAULTUNREADABLEICON EOL			{ $$ = $1; }
		| line_DEFAULTVFSICON EOL				{ $$ = $1; }
		| line_DEFAULTOPENEDDIRICON EOL				{ $$ = $1; }
		| line_DEFAULTOPENEDDISKICON EOL			{ $$ = $1; }
		| line_DEFAULTOPENEDVFSICON EOL				{ $$ = $1; }
		| line_MOUNTPROGRAM EOL					{ $$ = $1; }
		| line_UMOUNTPROGRAM EOL				{ $$ = $1; }
		| line_USESUDO EOL					{ $$ = $1; }
		| line_USEAUTOMOUNT EOL					{ $$ = $1; }
		| line_MOUNTRETRY EOL					{ $$ = $1; }
		| line_EJECTPROGRAM EOL					{ $$ = $1; }
		| line_MOUNTPOINT EOL					{ $$ = $1; }
		| line_OPTIONEJECT EOL					{ $$ = $1; }
		| line_READCDNAME EOL					{ $$ = $1; }
		| line_VALIDATECDNAME EOL				{ $$ = $1; }
		| line_OPTIONWARNMOUNT EOL				{ $$ = $1; }
		| line_OPTIONDUS EOL					{ $$ = $1; }
		| line_COMPRESSIONLEVEL EOL				{ $$ = $1; }
		| line_TESTVFS EOL					{ $$ = $1; }
		| line_EXTENSION EOL					{ $$ = $1; }
		| line_VFSEXTENSION EOL					{ $$ = $1; }
		| line_MIMEEXTENSION EOL				{ $$ = $1; }
		| line_MIMEVFSEXTENSION EOL				{ $$ = $1; }
		| line_DEFAULTMIMEEXTENSION EOL				{ $$ = $1; }
		| line_SCANMIMETYPES EOL				{ $$ = $1; }
		| line_ADDMIMETOSKIP EOL				{ $$ = $1; }
		| line_USEDEFAULTMIMEPLUGIN EOL				{ $$ = $1; }
		| line_READINFORMATION EOL				{ $$ = $1; }
		| line_DBCLICKFORINFO EOL				{ $$ = $1; }
		| line_DISPLAYDIRSIZE EOL				{ $$ = $1; }
		| line_DATEFORMAT EOL					{ $$ = $1; }
                | line_SIZEFORMAT EOL                                   { $$ = $1; }
		| line_RECENTFILE EOL					{ $$ = $1; }
		| line_RECENTFILESMAX EOL				{ $$ = $1; }
		| line_PREVIOUSSEARCHMODE EOL				{ $$ = $1; }
		| line_SAVEONLYUSEDCATEGORIES EOL			{ $$ = $1; }
		| line_MAINWINDOWPOSITION EOL				{ $$ = $1; }
		| line_TREEWINDOWSIZE EOL				{ $$ = $1; }
		| line_FILETOLOAD EOL					{ $$ = $1; }
		| line_LOADFILEATBOOT EOL				{ $$ = $1; }
		| line_AUTOSAVE EOL					{ $$ = $1; }
		| line_STRICTALPHABETICSORT EOL				{ $$ = $1; }
		| line_KEEPBACKUPFILE EOL				{ $$ = $1; }
		| line_MINUTESBEFOREAUTOSAVE EOL			{ $$ = $1; }
		| line_TOOLBARSTYLE EOL					{ $$ = $1; }
		| line_NEWSEARCHTYPE EOL				{ $$ = $1; }
		| line_WORKINGPATH EOL					{ $$ = $1; }
		| line_DISPLAYSPLASH EOL				{ $$ = $1; }
		| EOL							{ $$ = NULL;}
		;

line_EXTENSION:	EXTENSION GSTRING GSTRING GSTRING GSTRING GSTRING INTEGER
		{{
			KEY_VALUE *r, *r2;
			MIME_EXTENSIONS *m;
			GString *extension;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("Mime_Extension");
			r2 = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->value = r2;
			extension = g_string_new($2->str);
			extension = g_string_prepend(extension,"a.");
			r2->key = g_string_new(gnome_mime_type_or_default(extension->str,NULL));
			g_string_free(extension, TRUE);
			m = (MIME_EXTENSIONS*)g_malloc(sizeof(MIME_EXTENSIONS));
			r2->value = m;
			if(r2->key)
				m->mime = r2->key;
			else
				m->mime = NULL;
			m->prog = $3;
			m->arg = $4;
			g_string_free($5, TRUE);
			g_string_free($6, TRUE);
			if(test_plugin_existence(m->prog) == FALSE)
				m->state = FALSE;
			else
				m->state = $7;
			$$ = r;
		}}
		;

line_MIMEEXTENSION:	MIMEEXTENSION GSTRING GSTRING GSTRING INTEGER
		{{
			KEY_VALUE *r, *r2;
			MIME_EXTENSIONS *m;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("Mime_Extension");
			r2 = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->value = r2;
			r2->key = $2;
			m = (MIME_EXTENSIONS*)g_malloc(sizeof(MIME_EXTENSIONS));
			r2->value = m;
			m->mime = $2;
			m->prog = $3;
			m->arg = $4;
			if(test_plugin_existence(m->prog) == FALSE)
				m->state = FALSE;
			else
				m->state = $5;
			$$ = r;
		}}
		;

line_DEFAULTMIMEEXTENSION:	DEFAULTMIMEEXTENSION GSTRING GSTRING
		{{
			KEY_VALUE *r;
			MIME_EXTENSIONS *m;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("Default_Mime_Extension");
			m = (MIME_EXTENSIONS*)g_malloc(sizeof(MIME_EXTENSIONS));
			r->value = m;
			m->mime = NULL;
			m->prog = $2;
			m->arg = $3;
			if(test_plugin_existence(m->prog) == FALSE)
				m->state = FALSE;
			else
				m->state = TRUE;
			$$ = r;
		}}
		;

line_VFSEXTENSION:	VFSEXTENSION GSTRING GSTRING GSTRING GSTRING INTEGER GSTRING INTEGER INTEGER INTEGER
		{{
			KEY_VALUE *r, *r2;
			MIME_VFS_EXTENSIONS *me;
			GString *extension;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("VfsExtension");
			r2 = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->value = r2;
			extension = g_string_new($2->str);
			extension = g_string_prepend(extension,"a.");
			r2->key = g_string_new(gnome_mime_type_or_default(extension->str,NULL));
			g_string_free(extension, TRUE);
			me = (MIME_VFS_EXTENSIONS*)g_malloc(sizeof(MIME_VFS_EXTENSIONS));
			r2->value = me;
			if(r2->key)
				me->mime = r2->key;
			else
				me->mime = NULL;
			me->prog = $3;
			me->args = $4;
			me->separator = $5;
			me->date = $6;
			me->date_format = $7;
			me->size = $8;
			me->name = $9;
			if(test_plugin_existence(me->prog) == FALSE)
				me->state = FALSE;
			else
				me->state = $10;
			me->last_column = VFS_LAST_COLUMN_NOTHING;
			$$ = r;
		}}
		|	VFSEXTENSION GSTRING GSTRING GSTRING GSTRING INTEGER GSTRING INTEGER INTEGER INTEGER VFS_LAST_COLUMN_INT
		{{
			KEY_VALUE *r, *r2;
			MIME_VFS_EXTENSIONS *me;
			GString *extension;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("VfsExtension");
			r2 = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->value = r2;
			extension = g_string_new($2->str);
			extension = g_string_prepend(extension,"a.");
			r2->key = g_string_new(gnome_mime_type_or_default(extension->str,NULL));
			g_string_free(extension, TRUE);
			me = (MIME_VFS_EXTENSIONS*)g_malloc(sizeof(MIME_VFS_EXTENSIONS));
			r2->value = me;
			if(r2->key)
				me->mime = r2->key;
			else
				me->mime = NULL;
			me->prog = $3;
			me->args = $4;
			me->separator = $5;
			me->date = $6;
			me->date_format = $7;
			me->size = $8;
			me->name = $9;
			if(test_plugin_existence(me->prog) == FALSE)
				me->state = FALSE;
			else
				me->state = $10;
			me->last_column = $11;
			$$ = r;
		}}
		;

line_MIMEVFSEXTENSION:	MIMEVFSEXTENSION GSTRING GSTRING GSTRING GSTRING INTEGER GSTRING INTEGER INTEGER INTEGER
		{{
			KEY_VALUE *r, *r2;
			MIME_VFS_EXTENSIONS *ve;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("VfsExtension");
			r2 = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->value = r2;
			r2->key = $2;
			ve = (MIME_VFS_EXTENSIONS*)g_malloc(sizeof(MIME_VFS_EXTENSIONS));
			r2->value = ve;
			ve->mime = $2;
			ve->prog = $3;
			ve->args = $4;
			ve->separator = $5;
			ve->date = $6;
			ve->date_format = $7;
			ve->size = $8;
			ve->name = $9;
			if(test_plugin_existence(ve->prog) == FALSE)
				ve->state = FALSE;
			else
				ve->state = $10;
			ve->last_column = VFS_LAST_COLUMN_NOTHING;
			$$ = r;
		}}
		|	MIMEVFSEXTENSION GSTRING GSTRING GSTRING GSTRING INTEGER GSTRING INTEGER INTEGER INTEGER VFS_LAST_COLUMN_INT
		{{
			KEY_VALUE *r, *r2;
			MIME_VFS_EXTENSIONS *ve;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("VfsExtension");
			r2 = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->value = r2;
			r2->key = $2;
			ve = (MIME_VFS_EXTENSIONS*)g_malloc(sizeof(MIME_VFS_EXTENSIONS));
			r2->value = ve;
			ve->mime = $2;
			ve->prog = $3;
			ve->args = $4;
			ve->separator = $5;
			ve->date = $6;
			ve->date_format = $7;
			ve->size = $8;
			ve->name = $9;
			if(test_plugin_existence(ve->prog) == FALSE)
				ve->state = FALSE;
			else
				ve->state = $10;
			ve->last_column = $11;
			$$ = r;
		}}
		;

line_MOUNTPROGRAM:	MOUNTPROGRAM GSTRING
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("MountProgram");
			r->value = $2;
			$$ = r;
		}}
		;

line_UMOUNTPROGRAM:	UMOUNTPROGRAM GSTRING
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("UmountProgram");
			r->value = $2;
			$$ = r;
		}}
		;

line_EJECTPROGRAM:	EJECTPROGRAM GSTRING
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("EjectProgram");
			r->value = $2;
			$$ = r;
		}}
		;

line_MOUNTPOINT:	MOUNTPOINT GSTRING
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("MountPoint");
			r->value = $2;
			$$ = r;
		}}
		;
line_USESUDO:	USESUDO GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("UseSudo");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;
line_USEAUTOMOUNT:	USEAUTOMOUNT GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("UseAutomount");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;
line_MOUNTRETRY:	MOUNTRETRY INTEGER
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("MountRetry");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_OPTIONDUS:	        OPTIONDUS GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("OptionDus");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;
line_OPTIONWARNMOUNT:	OPTIONWARNMOUNT GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("OptionWarnMount");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;
line_OPTIONEJECT:	OPTIONEJECT GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("OptionEject");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_READCDNAME:	READCDNAME GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("ReadCDName");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_VALIDATECDNAME:	VALIDATECDNAME GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("ValidateCDName");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_COMPRESSIONLEVEL:	COMPRESSIONLEVEL INTEGER
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("CompressionLevel");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_TESTVFS:	TESTVFS INTEGER
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("TestVFS");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_READINFORMATION:	READINFORMATION GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("ReadInformation");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_USEDEFAULTMIMEPLUGIN:	USEDEFAULTMIMEPLUGIN GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("UseDefaultMimePlugin");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_DBCLICKFORINFO:	DBCLICKFORINFO GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("DbClickForInfo");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;



line_DISPLAYDIRSIZE:	DISPLAYDIRSIZE GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("DisplayDirSize");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;



/* line_ADDEXTICON returns a KEY_VALUE containing a GString("AddExtIcon") and a glist with n elements.
 * The first element is the icon path, and the second element is the extension
 */
line_ADDEXTICON:	ADDEXTICON STRINGS
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("AddExtIcon");
			r->value = $2;
			$$ = r;
		}}
		;

line_ADDMIMEICON:	ADDMIMEICON STRINGS
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("AddMimeIcon");
			r->value = $2;
			$$ = r;
		}}
		;

line_DEFAULTFILEICON:	DEFAULTFILEICON GSTRING
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("DefaultFileIcon");
			r->value = $2;
			$$ = r;
		}}
		;

line_DEFAULTDIRICON:	DEFAULTDIRICON GSTRING
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("DefaultDirIcon");
			r->value = $2;
			$$ = r;
		}}
		;

line_DEFAULTDISKICON:	DEFAULTDISKICON GSTRING
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("DefaultDiskIcon");
			r->value = $2;
			$$ = r;
		}}
		;

line_DEFAULTUNREADABLEICON:	DEFAULTUNREADABLEICON GSTRING
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("DefaultUnreadableIcon");
			r->value = $2;
			$$ = r;
		}}
		;

line_DEFAULTVFSICON:	DEFAULTVFSICON GSTRING
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("DefaultVfsIcon");
			r->value = $2;
			$$ = r;
		}}
		;

line_DEFAULTOPENEDDIRICON:	DEFAULTOPENEDDIRICON GSTRING
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("DefaultOpenedDirIcon");
			r->value = $2;
			$$ = r;
		}}
		;

line_DEFAULTOPENEDDISKICON:	DEFAULTOPENEDDISKICON GSTRING
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("DefaultOpenedDiskIcon");
			r->value = $2;
			$$ = r;
		}}
		;

line_DEFAULTOPENEDVFSICON:	DEFAULTOPENEDVFSICON GSTRING
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("DefaultOpenedVfsIcon");
			r->value = $2;
			$$ = r;
		}}
		;

line_DATEFORMAT:	DATEFORMAT GSTRING
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("DateFormat");
			r->value = $2;
			$$ = r;
		}}
		| DATEFORMAT STRINGLOCALE
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("DateFormatLocale");
			r->value = NULL;
			$$ = r;
		}}
		| DATEFORMAT STRINGISO8601
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("DateFormatISO8601");
			r->value = NULL;
			$$ = r;
		}}
		;

line_SIZEFORMAT:	SIZEFORMAT SIZE_FORMAT_INT
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("SizeFormat");			
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_RECENTFILE:	RECENTFILE GSTRING
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("RecentFile");
			r->value = $2;
			$$ = r;
		}}
		;

line_RECENTFILESMAX:	RECENTFILESMAX INTEGER
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("RecentFilesMax");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_PREVIOUSSEARCHMODE:	PREVIOUSSEARCHMODE INTEGER
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("PreviousSearchMode");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_SAVEONLYUSEDCATEGORIES:	SAVEONLYUSEDCATEGORIES GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("SaveOnlyUsedCategories");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_SCANMIMETYPES:	SCANMIMETYPES GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("ScanMimeTypes");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_ADDMIMETOSKIP:	ADDMIMETOSKIP GSTRING INTEGER
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("AddMIMEToSkip");
			r->value = g_list_append(NULL,$2);
			r->value = g_list_append(r->value,GINT_TO_POINTER($3));
			$$ = r;
		}}
		;

line_MAINWINDOWPOSITION:	MAINWINDOWPOSITION INTEGER INTEGER INTEGER INTEGER GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("MainWindowPosition");
			r->value = g_list_append(NULL,GINT_TO_POINTER($2));
			r->value = g_list_append(r->value,GINT_TO_POINTER($3));
			r->value = g_list_append(r->value,GINT_TO_POINTER($4));
			r->value = g_list_append(r->value,GINT_TO_POINTER($5));
			r->value = g_list_append(r->value,GINT_TO_POINTER($6));
			$$ = r;
		}}
		;

line_TREEWINDOWSIZE:	TREEWINDOWSIZE INTEGER INTEGER GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("TreeWindowSize");
			r->value = g_list_append(NULL,GINT_TO_POINTER($2));
			r->value = g_list_append(r->value,GINT_TO_POINTER($3));
			r->value = g_list_append(r->value,GINT_TO_POINTER($4));
			$$ = r;
		}}
		;

line_FILETOLOAD:	FILETOLOAD GSTRING
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("FileToLoad");
			r->value = $2;
			$$ = r;
		}};

line_LOADFILEATBOOT:	LOADFILEATBOOT GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("LoadFileAtBoot");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_AUTOSAVE:	AUTOSAVE GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("Autosave");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_STRICTALPHABETICSORT:	STRICTALPHABETICSORT GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("StrictAlphabeticSort");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_KEEPBACKUPFILE:	KEEPBACKUPFILE GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("KeepBackupFile");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_MINUTESBEFOREAUTOSAVE:	MINUTESBEFOREAUTOSAVE INTEGER
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("MinutesBeforeAutosave");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_TOOLBARSTYLE:	TOOLBARSTYLE TOOLBAR_STYLE_INT
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("ToolBarStyle");			
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_NEWSEARCHTYPE:	NEWSEARCHTYPE INTEGER
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("NewSearchType");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;

line_WORKINGPATH:	WORKINGPATH GSTRING
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("DefaultWorkingDirectory");
			r->value = $2;
			$$ = r;
		}};

line_DISPLAYSPLASH:	DISPLAYSPLASH GBOOLEAN
		{{
			KEY_VALUE *r;

			r = (KEY_VALUE*)g_malloc(sizeof(KEY_VALUE));
			r->key = g_string_new("DisplaySplash");
			r->value = GINT_TO_POINTER($2);
			$$ = r;
		}}
		;



STRINGS:	GSTRING				{ $$ = g_list_append(NULL, $1); }
		| GSTRING STRINGS		{ $$ = g_list_prepend($2, $1 ); }
		;

GSTRING:	STRING				{ $$ = g_string_new($1); }
		| QSTRING			{ 
							gchar *s;
							GString *g;
							s = $1;
							s++;
							g = g_string_new(s);
							$$ = g_string_truncate(g, g->len-1);
						}
		;

/* Not used yet. This is for integers.
INTEGERS: 	INTEGER				{ $$ = g_list_append(NULL, GINT_TO_POINTER($1)); }
			| INTEGER INTEGERS	{ $$ = g_list_prepend($2, GINT_TO_POINTER($1)); }
			| INTEGER TO INTEGER	{{
									gint i, b, e;
									GList *gl;
									
									if($3<$1) { b = $3; e = $1; }
									else { b = $1; e = $3; }
									gl = g_list_append(NULL, GINT_TO_POINTER(b));
									for(i=b+1; i<=e; i++) {
										gl = g_list_append(gl, GINT_TO_POINTER(i));
									}
									$$ = gl;
								}}
			| INTEGER TO INTEGER INTEGERS	{{
									gint i, b, e;
									GList *gl;
									
									if($3<$1) { b = $3; e = $1; }
									else { b = $1; e = $3; }
									gl = g_list_append($4, GINT_TO_POINTER(b));
									for(i=b+1; i<=e; i++) {
										gl = g_list_append(gl, GINT_TO_POINTER(i));
									}
									$$ = gl;
								}}
			;

*/
%%

int
yyerror (char *s)
{
  printf (_("Error parsing the config file: %s\n"), s);
  exit (0);
  return (0);
}

gboolean
check_supermount (CONFIG * my_config)
{
#ifdef OS_LINUX
  FILE *fp;
  char line[1024];
  char s1[1024];
  char s2[1024];
  char s3[1024];
  int rc;

  fp = fopen ("/proc/mounts", "r");
  if (fp == NULL)
    {
      ERROR_DIALOG (_("Unable to open /proc/mounts\n"), main_window);
    }

  while (fgets (line, sizeof (line), fp) != 0)
    {
      rc = sscanf (line, "%1023s %1023s %1023s", s1, s2, s3);
      if ((rc >= 3) && (strcmp (s2, my_config->mount_point->str) == 0)
	  && (strcmp (s3, "supermount") == 0))
	{
	  fclose (fp);
	  return TRUE;
	}
    }
  fclose (fp);
#endif
  return FALSE;
}

GString *
get_mount_device (char *mount_point)
{
  GString *ret = NULL;
#if defined(HAVE_GETFSENT)
  struct fstab *fstab_entry;
  setfsent ();
  while ((fstab_entry = getfsent ()) != NULL)
    {
      if (!strcmp (mount_point, fstab_entry->fs_file))
	{
	  if (strcmp (fstab_entry->fs_vfstype, "supermount"))
	    {
	      ret = g_string_new (fstab_entry->fs_spec);
	    }
	  else
	    {
	      gchar **super_options;
	      gchar **option;
	      super_options = g_strsplit (fstab_entry->fs_mntops, ",", 0);
	      option = super_options;
	      while (*option != NULL)
		{
		  if (!strncmp (*option, "dev=", 4))
		    {
		      ret = g_string_new ((*option) + 4);
		      break;
		    }
		  option++;
		}
	      g_strfreev (super_options);
	    }
	  break;
	}
    }
  endfsent ();
#else
#  if defined(HAVE_GETMNTENT)
  struct mntent *fstab_entry;
  FILE *fstab;
  fstab = setmntent (FSTAB_FILE, "r");
  while ((fstab_entry = getmntent (fstab)) != NULL)
    {
      if (!strcmp (mount_point, fstab_entry->mnt_dir))
	{
	  if (strcmp (fstab_entry->mnt_type, "supermount"))
	    {
	      ret = g_string_new (fstab_entry->mnt_fsname);
	    }
	  else
	    {
	      gchar **super_options;
	      gchar **option;
	      super_options = g_strsplit (fstab_entry->mnt_opts, ",", 0);
	      option = super_options;
	      while (*option != NULL)
		{
		  if (!strncmp (*option, "dev=", 4))
		    {
		      ret = g_string_new ((*option) + 4);
		      break;
		    }
		  option++;
		}
	      g_strfreev (super_options);
	    }
	  break;
	}
    }
  endmntent (fstab);
#  endif
#endif
  return (ret);
}

void
config_struct_free_1 (GList * gl)
{
  g_string_free (((KEY_VALUE *) (gl->data))->key, TRUE);
  g_free (gl->data);
  local_config = g_list_remove_link (local_config, gl);
  g_list_free_1 (gl);
}

#define GET_TOKEN ((KEY_VALUE*)(glist_ptr1->data))->value
#define NEXT_TOKEN config_struct_free_1(glist_ptr1); glist_ptr1 = local_config
#define IS_TOKEN(my_token) (strcmp((((KEY_VALUE*)(glist_ptr1->data))->key)->str,my_token) == 0)
#define CONFIG_FILE_VERSION 1

CONFIG *
init_config (GtkWidget * w)
{
/* Returns the config file "config_file->str" formated into the structure CONFIG */
  GString *conf_file;
  GList *glist_ptr1;
  CONFIG *my_config;
  FILE *rcfile;
  GList *gl1, *gl2;
  GString *gs;
  PIX *pix;
  GtkStyle *style;
  gchar *mime;
  gchar *path;
  GString *tmpstr;

  conf_file = g_string_new (g_get_home_dir ());
  conf_file =
    g_string_append (conf_file, USER_CONFIG_DIR "/" USER_CONFIG_FILE);
  if (!g_file_test (conf_file->str, G_FILE_TEST_ISFILE))
    {
      g_string_free (conf_file, TRUE);
      conf_file = g_string_new (DATA_DIR "/gtktalog/gtktalog.cf");
      if (!g_file_test (conf_file->str, G_FILE_TEST_ISFILE))
	{
	  ERROR_DIALOG (_("Could not find config file"), main_window);
	  exit (-1);
	}
    }

  local_config = NULL;

  style = gtk_widget_get_style (GTK_WIDGET (w));

  rcfile = fopen (conf_file->str, "r");
  if (rcfile)
    {

      /* Init some fields of my_config */
      my_config = (CONFIG *) g_malloc (sizeof (CONFIG));
      my_config->pix_paths = g_tree_new ((GCompareFunc) strcmp);
      my_config->mime_icons = g_tree_new ((GCompareFunc) g_strcasecmp);
      my_config->mount = g_string_new ("/bin/mount");
      my_config->umount = g_string_new ("/bin/umount");
      my_config->eject_prog = g_string_new ("/usr/bin/eject");
      my_config->mount_point = g_string_new ("/mnt/cdrom");
      my_config->use_automount = FALSE;
      my_config->use_supermount = FALSE;
      my_config->mount_retry = 0;
      my_config->mime_extensions = g_tree_new ((GCompareFunc) strcmp);
      my_config->mime_vfs_extensions = g_tree_new ((GCompareFunc) strcmp);
      my_config->mime_to_skip_during_a_scan =
	g_tree_new ((GCompareFunc) strcmp);
      my_config->use_du_s = TRUE;
      my_config->warn_mount = FALSE;
      my_config->eject_disk = TRUE;
      my_config->read_cd_name = TRUE;
      my_config->validate_cd_name = TRUE;
      my_config->getInformation = TRUE;
      my_config->testvfs = TEST_VFS_NO;
      my_config->compression_level = 9;
      my_config->default_file_pix = NULL;
      my_config->default_dir_pix = NULL;
      my_config->default_disk_pix = NULL;
      my_config->default_unreadable_pix = NULL;
      my_config->default_vfs_pix = NULL;
      my_config->default_opened_dir_pix = NULL;
      my_config->default_opened_disk_pix = NULL;
      my_config->default_opened_vfs_pix = NULL;
      my_config->date_format = g_strdup ("%d/%m/%Y %H:%M:%S");
      my_config->display_dir_size = TRUE;
      my_config->recent_files = NULL;
      my_config->nb_max_recent_files = 4;
      my_config->previous_search_mode = EVERYTHING_MATCHES;
      my_config->save_only_used_categories = FALSE;
      my_config->scan_mime_types = FALSE;
      my_config->use_default_information_plugin = TRUE;
      my_config->default_information_plugin = NULL;
      my_config->mainwindow_x = 10;
      my_config->mainwindow_y = 10;
      my_config->mainwindow_w = 640;
      my_config->mainwindow_h = 480;
      my_config->mainwindow_save_xywh = FALSE;
      my_config->ctreewindow_w = 150;
      my_config->ctreewindow_h = 150;
      my_config->ctreewindow_save_wh = FALSE;
      my_config->sort_column = 0;
      my_config->currently_displayed_recent_files = 0;
      my_config->file_to_load = NULL;
      my_config->load_file_at_boot = FALSE;
      my_config->autosave = FALSE;
      my_config->keep_bakup_file = FALSE;
      my_config->minutes_before_autosave = 10;
      my_config->backupfile_is_saved = FALSE;
      my_config->toolbar_type = GTK_TOOLBAR_BOTH;
      my_config->new_search_type = SEARCH_TYPE_SIMPLE;
      my_config->default_working_path = NULL;
      my_config->date_format_type = DATE_FORMAT_IS_LOCALE;
      my_config->size_format = SIZE_FORMAT_B_HUMAN;
      my_config->strict_alphabetic_sort = FALSE;
      my_config->display_splash = TRUE;
      my_config->use_sudo = FALSE;
      my_config->sudo=strdup("sudo");

      /* Parse the config file */
      yyrestart (rcfile);
      yyparse ();
      fclose (rcfile);

      /* Fills some fields of my_config with the parsed data */

      glist_ptr1 = local_config;
      while (glist_ptr1)
	{
	  if (IS_TOKEN ("AddExtIcon"))
	    {
	      /* Icon */
	      gl1 = GET_TOKEN;
	      pix =
		new_pix_from_filename (w, style,
				       ((GString *) (gl1->data))->str,
				       my_config);

	      g_string_free (((GString *) (gl1->data)), TRUE);
	      gl2 = g_list_next (gl1);
	      while (gl2)
		{
		  if (pix)
		    {
		      tmpstr = g_string_new (((GString *) (gl2->data))->str);
		      tmpstr = g_string_prepend (tmpstr, "a.");
		      mime =
			g_strdup (gnome_mime_type_or_default
				  (tmpstr->str, NULL));
		      g_string_free (tmpstr, TRUE);
		      if (mime)
			{
			  g_tree_insert (my_config->mime_icons, mime, pix);
			}
		    }
		  g_string_free (gl2->data, TRUE);
		  gl2 = g_list_next (gl2);
		}

	      g_list_free (gl1);


	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("AddMimeIcon"))
	    {
	      /* Icon */
	      gl1 = GET_TOKEN;
	      pix =
		new_pix_from_filename (w, style,
				       ((GString *) (gl1->data))->str,
				       my_config);
	      g_string_free (((GString *) (gl1->data)), TRUE);
	      gl2 = g_list_next (gl1);
	      while (gl2)
		{
		  if (pix)
		    {
		      g_tree_insert (my_config->mime_icons,
				     (mime = g_strdup (((GString
							 *) (gl2->
							     data))->str)),
				     pix);
		    }
		  g_string_free (gl2->data, TRUE);
		  gl2 = g_list_next (gl2);
		}

	      g_list_free (gl1);


	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("DefaultFileIcon"))
	    {
	      gs = GET_TOKEN;
	      my_config->default_file_pix = new_pix_from_filename (w, style,
								   (path =
								    g_strdup
								    (gs->
								     str)),
								   my_config);
	      g_string_free (gs, TRUE);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("DefaultDirIcon"))
	    {
	      gs = GET_TOKEN;
	      my_config->default_dir_pix = new_pix_from_filename (w, style,
								  (path =
								   g_strdup
								   (gs->str)),
								  my_config);
	      g_string_free (gs, TRUE);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("DefaultDiskIcon"))
	    {
	      gs = GET_TOKEN;
	      my_config->default_disk_pix = new_pix_from_filename (w, style,
								   (path =
								    g_strdup
								    (gs->
								     str)),
								   my_config);
	      g_string_free (gs, TRUE);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("DefaultUnreadableIcon"))
	    {
	      gs = GET_TOKEN;

	      my_config->default_unreadable_pix = new_pix_from_filename (w,
									 style,
									 (path
									  =
									  g_strdup
									  (gs->
									   str)),
									 my_config);
	      g_string_free (gs, TRUE);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("DefaultVfsIcon"))
	    {
	      gs = GET_TOKEN;
	      my_config->default_vfs_pix = new_pix_from_filename (w, style,
								  (path =
								   g_strdup
								   (gs->str)),
								  my_config);
	      g_string_free (gs, TRUE);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("DefaultOpenedDirIcon"))
	    {
	      gs = GET_TOKEN;
	      my_config->default_opened_dir_pix =
		new_pix_from_filename (w, style, (path = g_strdup (gs->str)),
				       my_config);
	      g_string_free (gs, TRUE);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("DefaultOpenedDiskIcon"))
	    {
	      gs = GET_TOKEN;
	      my_config->default_opened_disk_pix =
		new_pix_from_filename (w, style, (path = g_strdup (gs->str)),
				       my_config);
	      g_string_free (gs, TRUE);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("DefaultOpenedVfsIcon"))
	    {
	      gs = GET_TOKEN;
	      my_config->default_opened_vfs_pix =
		new_pix_from_filename (w, style, (path = g_strdup (gs->str)),
				       my_config);
	      g_string_free (gs, TRUE);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("MountProgram"))
	    {
	      gs = GET_TOKEN;
	      g_string_free (my_config->mount, TRUE);
	      my_config->mount = gs;
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("UmountProgram"))
	    {
	      gs = GET_TOKEN;
	      g_string_free (my_config->umount, TRUE);
	      my_config->umount = gs;
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("EjectProgram"))
	    {
	      gs = GET_TOKEN;
	      g_string_free (my_config->eject_prog, TRUE);
	      my_config->eject_prog = gs;
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("MountPoint"))
	    {
	      gs = GET_TOKEN;
	      g_string_free (my_config->mount_point, TRUE);
	      my_config->mount_point = g_string_new (escapespaces (gs->str));
	      g_string_free (gs, TRUE);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("UseSudo"))
	    {
	      gs = GET_TOKEN;
	      my_config->use_sudo = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("UseAutomount"))
	    {
	      gs = GET_TOKEN;
	      my_config->use_automount = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("MountRetry"))
	    {
	      gs = GET_TOKEN;
	      my_config->mount_retry = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("OptionDus"))
	    {
	      gs = GET_TOKEN;
	      my_config->use_du_s = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("OptionWarnMount"))
	    {
	      gs = GET_TOKEN;
	      my_config->warn_mount = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("OptionEject"))
	    {
	      gs = GET_TOKEN;
	      my_config->eject_disk = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("ReadCDName"))
	    {
	      gs = GET_TOKEN;
	      my_config->read_cd_name = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("ValidateCDName"))
	    {
	      gs = GET_TOKEN;
	      my_config->validate_cd_name = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("CompressionLevel"))
	    {
	      gs = GET_TOKEN;
	      my_config->compression_level = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("TestVFS"))
	    {
	      gs = GET_TOKEN;
	      my_config->testvfs = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("Mime_Extension"))
	    {
	      gs = GET_TOKEN;
	      if (g_tree_lookup
		  (my_config->mime_extensions,
		   ((MIME_EXTENSIONS *) ((KEY_VALUE *) gs)->value)->mime->
		   str))
		{
		  MIME_EXTENSIONS *m = ((KEY_VALUE *) gs)->value;
		  g_string_free (m->mime, TRUE);
		  g_string_free (m->prog, TRUE);
		  g_string_free (m->arg, TRUE);
		  g_free (m);
		}
	      else
		{
		  g_tree_insert (my_config->mime_extensions,
				 ((MIME_EXTENSIONS *) ((KEY_VALUE *) gs)->
				  value)->mime->str,
				 ((KEY_VALUE *) gs)->value);
		}
	      g_free (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("Default_Mime_Extension"))
	    {
	      gs = GET_TOKEN;
	      if (my_config->default_information_plugin)
		{
		  g_string_free (my_config->default_information_plugin->prog,
				 TRUE);
		  g_string_free (my_config->default_information_plugin->arg,
				 TRUE);
		  g_free (my_config->default_information_plugin);
		}
	      my_config->default_information_plugin =
		(MIME_EXTENSIONS *) g_malloc (sizeof (MIME_EXTENSIONS));
	      my_config->default_information_plugin->mime = NULL;
	      my_config->default_information_plugin->prog =
		((MIME_EXTENSIONS *) gs)->prog;
	      my_config->default_information_plugin->arg =
		((MIME_EXTENSIONS *) gs)->arg;
	      my_config->default_information_plugin->state =
		((MIME_EXTENSIONS *) gs)->state;
	      g_free (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("UseDefaultMimePlugin"))
	    {
	      gs = GET_TOKEN;
	      my_config->use_default_information_plugin =
		GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("VfsExtension"))
	    {
	      gs = GET_TOKEN;
	      mime = ((MIME_VFS_EXTENSIONS
		       *) ((KEY_VALUE *) gs)->value)->mime->str;
	      if (mime)
		{
		  if (g_tree_lookup (my_config->mime_vfs_extensions, mime))
		    {
		      MIME_VFS_EXTENSIONS *m = ((KEY_VALUE *) gs)->value;
		      g_string_free (m->mime, TRUE);
		      g_string_free (m->prog, TRUE);
		      g_string_free (m->args, TRUE);
		      g_string_free (m->separator, TRUE);
		      g_string_free (m->date_format, TRUE);
		      g_free (m);
		    }
		  else
		    {
		      g_tree_insert (my_config->mime_vfs_extensions, mime,
				     ((KEY_VALUE *) gs)->value);
		      g_free (gs);
		    }
		}
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("AddMIMEToSkip"))
	    {
	      /* Icon */
	      gl1 = GET_TOKEN;
	      gl2 = g_list_next (gl1);
	      g_tree_insert (my_config->mime_to_skip_during_a_scan,
			     (mime = g_strdup (((GString
						 *) (gl1->data))->str)),
			     gl2->data);

	      g_string_free (gl1->data, TRUE);

	      g_list_free (gl1);


	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("ReadInformation"))
	    {
	      gs = GET_TOKEN;
	      my_config->getInformation = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("DbClickForInfo"))
	    {
	      gs = GET_TOKEN;
	      my_config->dbclick_opens_info = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("DisplayDirSize"))
	    {
	      gs = GET_TOKEN;
	      my_config->display_dir_size = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("DateFormatISO8601"))
	    {
	      gs = GET_TOKEN;
	      my_config->date_format_type = DATE_FORMAT_IS_ISO8601;
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("DateFormat"))
	    {
	      gs = GET_TOKEN;
	      if (my_config->date_format)
		g_free (my_config->date_format);
	      my_config->date_format = g_strdup (gs->str);
	      g_string_free (gs, TRUE);
	      my_config->date_format_type = DATE_FORMAT_IS_USERDEFINED;
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("DateFormatLocale"))
	    {
	      gs = GET_TOKEN;
	      my_config->date_format_type = DATE_FORMAT_IS_LOCALE;
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("SizeFormat"))
	    {
	      gs = GET_TOKEN;
	      my_config->size_format = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("RecentFile"))
	    {
	      gs = GET_TOKEN;
	      my_config->recent_files =
		add_file_to_recent_files (my_config->recent_files,
					  my_config->nb_max_recent_files,
					  gs->str);
	      g_string_free (gs, TRUE);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("RecentFilesMax"))
	    {
	      gs = GET_TOKEN;
	      my_config->nb_max_recent_files = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("PreviousSearchMode"))
	    {
	      gs = GET_TOKEN;
	      my_config->previous_search_mode = GPOINTER_TO_INT (gs);
	      if (my_config->previous_search_mode >= STRING_SM_NB)
		my_config->previous_search_mode = EVERYTHING_MATCHES;
	      if (my_config->previous_search_mode < 0)
		my_config->previous_search_mode = EVERYTHING_MATCHES;
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("SaveOnlyUsedCategories"))
	    {
	      gs = GET_TOKEN;
	      my_config->save_only_used_categories = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("ScanMimeTypes"))
	    {
	      gs = GET_TOKEN;
	      my_config->scan_mime_types = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("MainWindowPosition"))
	    {
	      gs = GET_TOKEN;
	      gl1 = (GList *) gs;
	      my_config->mainwindow_x = GPOINTER_TO_INT (gl1->data);
	      gl1 = gl1->next;
	      my_config->mainwindow_y = GPOINTER_TO_INT (gl1->data);
	      gl1 = gl1->next;
	      my_config->mainwindow_w = GPOINTER_TO_INT (gl1->data);
	      gl1 = gl1->next;
	      my_config->mainwindow_h = GPOINTER_TO_INT (gl1->data);
	      gl1 = gl1->next;
	      my_config->mainwindow_save_xywh = GPOINTER_TO_INT (gl1->data);
	      g_list_free ((GList *) gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("TreeWindowSize"))
	    {
	      gs = GET_TOKEN;
	      gl1 = (GList *) gs;
	      my_config->ctreewindow_w = GPOINTER_TO_INT (gl1->data);
	      gl1 = gl1->next;
	      my_config->ctreewindow_h = GPOINTER_TO_INT (gl1->data);
	      gl1 = gl1->next;
	      my_config->ctreewindow_save_wh = GPOINTER_TO_INT (gl1->data);
	      g_list_free ((GList *) gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("FileToLoad"))
	    {
	      gs = GET_TOKEN;
	      if (my_config->file_to_load)
		g_free (my_config->file_to_load);
	      my_config->file_to_load = g_strdup (gs->str);
	      g_string_free (gs, TRUE);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("LoadFileAtBoot"))
	    {
	      gs = GET_TOKEN;
	      my_config->load_file_at_boot = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("StrictAlphabeticSort"))
	    {
	      gs = GET_TOKEN;
	      my_config->strict_alphabetic_sort = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("Autosave"))
	    {
	      gs = GET_TOKEN;
	      my_config->autosave = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("KeepBackupFile"))
	    {
	      gs = GET_TOKEN;
	      my_config->keep_bakup_file = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("MinutesBeforeAutosave"))
	    {
	      gs = GET_TOKEN;
	      my_config->minutes_before_autosave = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("ToolBarStyle"))
	    {
	      gs = GET_TOKEN;
	      my_config->toolbar_type = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("NewSearchType"))
	    {
	      gs = GET_TOKEN;
	      my_config->new_search_type = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("DefaultWorkingDirectory"))
	    {
	      gs = GET_TOKEN;
	      if (my_config->default_working_path)
		g_free (my_config->default_working_path);
	      my_config->default_working_path = g_strdup (gs->str);
	      g_string_free (gs, TRUE);
	      NEXT_TOKEN;
	    }
	  else if (IS_TOKEN ("DisplaySplash"))
	    {
	      gs = GET_TOKEN;
	      my_config->display_splash = GPOINTER_TO_INT (gs);
	      NEXT_TOKEN;
	    }
	  else
	    {
	      glist_ptr1 = g_list_next (glist_ptr1);
	    }
	}
      if (my_config->use_automount)
	{
	  my_config->use_supermount = check_supermount (my_config);
	}

      if ((my_config->use_supermount) || (!(my_config->use_automount)))
	{
	  my_config->mount_device =
	    get_mount_device (my_config->mount_point->str);
	}
      else
	{
	  my_config->mount_device = NULL;
	}


      if (my_config->default_file_pix == NULL)
	{
	  my_config->default_file_pix = new_pix_from_filename (w, style,
							       DEFAULTFILEICONPATH,
							       my_config);
	  if (!my_config->default_file_pix)
	    exit (-1);
	}
      if (my_config->default_dir_pix == NULL)
	{
	  my_config->default_dir_pix = new_pix_from_filename (w, style,
							      DEFAULTDIRICONPATH,
							      my_config);
	  if (!my_config->default_dir_pix)
	    exit (-1);
	}
      if (my_config->default_disk_pix == NULL)
	{
	  my_config->default_disk_pix = new_pix_from_filename (w, style,
							       DEFAULTDISKICONPATH,
							       my_config);
	  if (!my_config->default_disk_pix)
	    exit (-1);
	}
      if (my_config->default_unreadable_pix == NULL)
	{
	  my_config->default_unreadable_pix = new_pix_from_filename (w, style,
								     DEFAULTUNREADABLEICONPATH,
								     my_config);
	  if (!my_config->default_unreadable_pix)
	    exit (-1);
	}
      if (my_config->default_vfs_pix == NULL)
	{
	  my_config->default_vfs_pix = new_pix_from_filename (w, style,
							      DEFAULTVFSICONPATH,
							      my_config);
	  if (!my_config->default_vfs_pix)
	    exit (-1);
	}
      if (my_config->default_opened_dir_pix == NULL)
	{
	  my_config->default_opened_dir_pix = new_pix_from_filename (w, style,
								     DEFAULTOPENEDDIRICONPATH,
								     my_config);
	  if (!my_config->default_opened_dir_pix)
	    exit (-1);
	}
      if (my_config->default_opened_disk_pix == NULL)
	{
	  my_config->default_opened_disk_pix =
	    new_pix_from_filename (w, style, DEFAULTOPENEDDISKICONPATH,
				   my_config);
	  if (!my_config->default_opened_disk_pix)
	    exit (-1);
	}
      if (my_config->default_opened_vfs_pix == NULL)
	{
	  my_config->default_opened_vfs_pix = new_pix_from_filename (w, style,
								     DEFAULTOPENEDVFSICONPATH,
								     my_config);
	  if (!my_config->default_opened_vfs_pix)
	    exit (-1);
	}
      if (my_config->eject_prog)
	{
	  if (my_config->eject_prog->len <= 0)
	    {
	      my_config->eject_disk = FALSE;
	    }
	}
      else
	{
	  my_config->eject_disk = FALSE;
	}
      if (my_config->eject_prog)
	{
	  if (my_config->eject_prog->len <= 0)
	    {
	      my_config->eject_disk = FALSE;
	    }
	}
      if (!my_config->default_information_plugin)
	{
	  my_config->use_default_information_plugin = FALSE;
	  my_config->default_information_plugin =
	    (MIME_EXTENSIONS *) g_malloc (sizeof (MIME_EXTENSIONS));
	  my_config->default_information_plugin->mime = NULL;
	  my_config->default_information_plugin->prog = g_string_new ("");
	  my_config->default_information_plugin->arg = g_string_new ("");
	  my_config->default_information_plugin->state = FALSE;
	}
      if (!my_config->file_to_load)
	{
	  my_config->load_file_at_boot = FALSE;
	}
      if (!my_config->minutes_before_autosave)
	{
	  my_config->autosave = FALSE;
	}
      if ((my_config->toolbar_type != GTK_TOOLBAR_TEXT)
	  && (my_config->toolbar_type != GTK_TOOLBAR_ICONS))
	{
	  my_config->toolbar_type = GTK_TOOLBAR_BOTH;
	}
      switch (my_config->size_format)
	{
	case SIZE_FORMAT_B:
	case SIZE_FORMAT_KB:
	case SIZE_FORMAT_MB:
	case SIZE_FORMAT_GB:
	case SIZE_FORMAT_HUMAN:
	case SIZE_FORMAT_B_HUMAN:
	  break;
	default:
	  my_config->size_format = SIZE_FORMAT_B_HUMAN;
	}
      /* when default_working_path is unset or garbage, define it to $HOME or
         to "/", as the last resort */
      if (my_config->default_working_path)
	{
	  if (!g_file_test
	      (my_config->default_working_path, G_FILE_TEST_ISDIR))
	    {
	      my_config->default_working_path = NULL;
	    }
	}
      if (!my_config->default_working_path)
	{
	  gchar *home = g_get_home_dir ();
	  if (home && strlen (home) >= 1)
	    my_config->default_working_path = g_strconcat (home, "/", NULL);
	  else
	    my_config->default_working_path = g_strdup ("/");
	}
      my_config->working_path = g_strdup (my_config->default_working_path);
      if (my_config->nb_max_recent_files <= 0)
	my_config->nb_max_recent_files = 4;
    }
  else
    {
      my_config = NULL;
    }
  g_string_free (conf_file, TRUE);
#ifdef OS_PPC_DARWIN
  my_config->use_automount = FALSE;
  my_config->use_supermount = FALSE;
  my_config->eject_disk = FALSE;
#endif
  return (my_config);
}
