/***************************************************************************
                          draw_ball.cpp  -  description
                             -------------------
    begin                : Tue Jan 8 2002
    copyright            : (C) 1999-2002 by Jacques Fortier & Brian Ashe
    email                : gtkpool@seul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "draw_ball.h"

draw_ball::draw_ball(GdkDrawable *p, GdkGC *g){
	pixmap = p; gc = g;
}

draw_ball::~draw_ball(){
}

void draw_ball::operator() (const Ball &b)
{
	b.draw(pixmap, gc);
	if(b.picture)
	{
		gdk_gc_set_clip_mask(gc, b.clip_bmp);
		gdk_gc_set_clip_origin(gc, int(b.x - b.diam / 2), int(b.y - b.diam / 2));
		gdk_draw_pixmap(pixmap, gc, b.picture, 0, 0, int(b.x - b.diam / 2),
		                int (b.y - b.diam / 2), BALL_SIZE, BALL_SIZE);
		gdk_gc_set_clip_origin(gc, 0, 0);
		gdk_gc_set_clip_mask(gc, (GdkWindow *)NULL);
	}
	else
	{
		gdk_gc_set_foreground(gc, b.clr);
		gdk_gc_set_background(gc, b.clr);
		gdk_draw_arc(pixmap, gc, 1, int(b.x - b.radius), int(b.y - b.radius),
		             b.diam, b.diam, 0, 360 * 64);
	}
}
