/* ----------------------------------------------------------------------------
 * gtkpbbuttons.c
 * Visual client for pbbuttnsd, the power management daemon for Apple
 * Powerbooks and other supported laptops. Certain messages of the daemon
 * will be visualized in a X window.
 * 
 * Copyright 2002-2004 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <gtk/gtk.h>
#include <popt.h>

#include <pbb.h>

#ifdef ENABLE_NLS
#  include <locale.h>
#endif

#include "gtkinterface.h"
#include "gettext_macros.h"
#include "session.h"

volatile sig_atomic_t prgexit = 0;

int main(int argc, char *argv[])
{
	struct init masterdata, *md = &masterdata;
	struct poptArgs args = {DEFAULT_AUDIO, DEFAULT_THEME, DEFAULT_PIDFILE, 0, 0};
	int rc = 1;
	
	struct poptOption options[] = {
		{"audiodev", 'a', POPT_ARG_STRING | POPT_ARGFLAG_SHOW_DEFAULT,
			&args.audiodev, 0, N_("use alternative audio device"), N_("AUDIODEV")},
		{"theme",    't', POPT_ARG_STRING | POPT_ARGFLAG_SHOW_DEFAULT,
			&args.theme,    0, N_("theme that should be used"), N_("THEME")},
		{"pidfile",  'p', POPT_ARG_STRING | POPT_ARGFLAG_SHOW_DEFAULT,
			&args.pidfile,  0, N_("use an alternative PID-file if detach"), N_("PIDFILE")},
		{"detach",   'd', POPT_ARG_NONE,
			&args.detach,   0, N_("detach process from terminal"), NULL},
		{"version",  'v', POPT_ARG_NONE,
			&args.version,  0, N_("show program version and exit"), NULL},
#ifndef ENABLE_GNOME
		POPT_AUTOHELP  /* GNOME already include this */
#endif
		POPT_TABLEEND
	};
	
#ifdef ENABLE_NLS
	setlocale(LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain (GETTEXT_PACKAGE);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif
	init_init(md, argc, argv);
	
#ifdef ENABLE_GNOME
	gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE, md->argc, md->argv,
			GNOME_PARAM_POPT_TABLE, options,
			GNOME_PARAM_POPT_FLAGS, 0,
			GNOME_PARAM_NONE);
#else
	int err;
	gtk_init (&md->argc, &md->argv);

	poptContext poptcon;
	if ((poptcon = poptGetContext (PACKAGE, md->argc, (const char **) md->argv, options, 0))) {
		if ((err = poptGetNextOpt (poptcon)) < -1) {
			printf("ERROR: Option %s: %s\n", poptBadOption(poptcon, 0), poptStrerror(err));
			poptPrintUsage (poptcon, stdout, 0);
		}
		poptFreeContext (poptcon);
		if (err < -1)
			exit (E_INVALID);
	}
#endif
	
	init_libpbb ();
	if((rc = evaluate_args(md, &args)) == 0) {	/* evaluate command line */
		if ((create_daemon ()) == 0) {
#ifdef ENABLE_GNOME
			session_init (md); /* connect to GNOME session management */
#endif
			if ((rc = prg_init(md)) == 0)
				if (! install_sighandler()) {
					gtk_timeout_add(POLLTIME, timeout_callback, md);
					gtk_main();
					rc = 0;
				}
			ipc_exit();   /* clean up IPC subsystem for clients */
#ifdef HAVE_SOUND
			cleanup_audio(&md->dsp);  /* does validity check inside */
#endif
			theme_exit(md->themedata);
		}
	}
	exit_libpbb();             /* cleanup library */
	if (rc == E_INFO) rc = 0;  /* E_INFO isn't a real error */
	exit (rc);
}

/* debug function in libpbb.a, if compiled with --enable-debug */
void peep_ipc (struct tagitem *taglist) { }
		
