#ifndef LIBGTKLP_H
#define LIBGTKLP_H

#include <glib.h>
#include <gtk/gtk.h>
#include <cups/language.h>
#include <cups/http.h>

#include <defaults.h>

extern int DEBUG;
extern int nox;
extern int PrinterChoice;
extern int PrinterNum;
extern int lastPrinterChoice;
extern unsigned char DEF_PRN[DEF_PRN_LEN+1];
extern unsigned char PrinterBannerStart[MAX_PRT][MAXLINE+1];
extern unsigned char PrinterBannerEnd[MAX_PRT][MAXLINE+1];
extern unsigned char PrinterInfos[MAX_PRT][MAXLINE+1];
extern unsigned char PrinterLocations[MAX_PRT][MAXLINE+1];
extern unsigned char PrinterNames[MAX_PRT][DEF_PRN_LEN+1];
extern char ServerName[MAX_SERVER_NAME+1];
extern char UserName[MAX_USERNAME+1];
extern char passWord[MAX_PASSLEN+1];

extern GtkWidget *mainWindow;

extern cups_lang_t *cupsLanguage;
extern http_t *cupsHttp;

void quick_message(gchar *message, int which);
void getPrinters(int loop);
void gtklp_fatal_end(char *text);
void emergency(void);
void passDestroy(void);
void passNO(GtkWidget *dialog);
void passChanged(GtkEditable *editable, gpointer data);
void loginChanged(GtkEditable *editable, gpointer data);
const char *getPass(const char *prompt);
int noX(void);
void hello(GtkWidget *widget, gpointer data);

#endif /* LIBGTKLP_H */
