/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4; coding: utf-8 -*- 
 *
 * This file tests GTK signals like expose_event on GtkImageView.
 **/
#include <src/gtkimageview.h>
#include <assert.h>

/* A fake realization function for GtkImageView. The normal can not be
   used because gdk does not like it. */
static void
fake_realize (GtkWidget *widget)
{
    GdkWindowAttr attrs;
    attrs.window_type = GDK_WINDOW_CHILD;
    attrs.x = widget->allocation.x;
    attrs.y = widget->allocation.y;
    attrs.width = widget->allocation.width;
    attrs.height = widget->allocation.height;
    attrs.wclass = GDK_INPUT_OUTPUT;
    attrs.visual = gtk_widget_get_visual (widget);
    attrs.colormap = gtk_widget_get_colormap (widget);
    attrs.event_mask = (gtk_widget_get_events (widget)
                        | GDK_EXPOSURE_MASK
                        | GDK_BUTTON_MOTION_MASK
                        | GDK_BUTTON_PRESS_MASK
                        | GDK_BUTTON_RELEASE_MASK
                        | GDK_POINTER_MOTION_MASK);
                        
    int attr_mask = (GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_COLORMAP);
    widget->window = gdk_window_new (NULL, &attrs, attr_mask);

    widget->style = gtk_style_attach (widget->style, widget->window);
    gtk_style_set_background (widget->style, widget->window, GTK_STATE_NORMAL);
}

/**
 * test_expose_event_with_pixbuf:
 *
 * The objective of this test is simply to verify that GtkImageView
 * doesn't crash when it is repainting a pixbuf.
 **/
static void
test_expose_event_with_pixbuf ()
{
    printf ("test_expose_event_with_pixbuf\n");
    GtkWidget *view = gtk_image_view_new ();
    g_object_ref (view);
    gtk_object_sink (GTK_OBJECT (view));
    GdkPixbuf *pixbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, 5, 5);

    fake_realize (view);
    view->allocation.width = 100;
    view->allocation.height = 100;
    
    gtk_image_view_set_pixbuf (GTK_IMAGE_VIEW (view), pixbuf, FALSE);

    GdkEventExpose ev = {.area = {0, 0, 999, 999}};
    GTK_WIDGET_GET_CLASS (view)->expose_event (view, &ev);

    g_object_unref (pixbuf);
    gtk_widget_destroy (view);
    g_object_unref (view);
}

int
main (int argc, char *argv[])
{
    gtk_init (&argc, &argv);
    test_expose_event_with_pixbuf ();
    printf ("1 test passed.\n");
}

