// logview.cc
//
//    logarithmic scale for tunes
//
//    Copyright (C) 1999  Florian Berger
//    Email: florian.berger@jk.uni-linz.ac.at
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License Version 2 as
//    published by the Free Software Foundation;
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//

#include <stdio.h>
#include <string.h>

#include <math.h>

#include "logview.h"

#include "resources.h"



char *note_ger[12] = {"A","B", "H","C","Db","D","Eb","E","F","Gb","G","Ab"};
char *note_us[12] =  {"A","Bb","B","C","Db","D","Eb","E","F","Gb","G","Ab"};
char *note_ger_alt[12] = {"A","B", "H","C","C#","D","D#","E","F","F#","G","G#"};
char *note_us_alt[12] =  {"A","A#","B","C","C#","D","D#","E","F","F#","G","G#"};

char **note;

char *tuning_nat[23] = 
     {"25/24","16/15","9/8","7/6","75/64","6/5","5/4","32/25","125/96",
      "4/3","25/18","45/32","36/25","3/2","25/16","8/5","5/3","125/72",
      "16/9","9/5","15/8","48/25","125/64"};

// public:
LogView::LogView() : Gtk::DrawingArea()
{
    grundton=0;
    nat_tuning_on=false;

    note=note_us;

    lfreq=1.0;
    x0=10;
    y0=26;
    h=10;

//   i_col_bg.   set("");     get_colormap().alloc(i_col_bg   );
    i_col_bg.      set("rgb:D/D/D");    get_colormap().alloc(i_col_bg     );
    i_col_draw.    set("black");        get_colormap().alloc(i_col_draw   );
    i_col_shad.    set("white");        get_colormap().alloc(i_col_shad   );
    i_col_bg2.     set("rgb:9/9/9");    get_colormap().alloc(i_col_bg2    );
    i_col_pointer. set("green");        get_colormap().alloc(i_col_pointer);
    i_col_ticks.   set("rgb:6/6/6");    get_colormap().alloc(i_col_ticks  );
    i_col_marks.   set("red"  );        get_colormap().alloc(i_col_marks  );
    
    set_events (
                  GDK_EXPOSURE_MASK
//		| GDK_LEAVE_NOTIFY_MASK
		| GDK_BUTTON_PRESS_MASK
//		| GDK_POINTER_MOTION_MASK
//                | GDK_POINTER_MOTION_HINT_MASK
               );
}


LogView::~LogView() {};


int LogView::lfreq_pos(double lfreq)
{
    return (int)( (double)x0+(double)(width()-2*x0)
                  *(double)(lfreq-lfreq0)/LOG_2+0.5 );
}


int LogView::pos_note(int pos)
{
    return( (pos-x0)*12/(width()-2*x0) );
}


void LogView::drawarrow()
{
    int x,y,x1,x2;
    
    if (!i_GC){
        Gdk_Window win_ = get_window();
        i_GC = Gdk_GC( win_ );
    }
    
    Gdk_Window win = get_window();
//        x=(int)( x0+(lfreq-lfreq0)*(width()-20)/LOG_2+0.5 );
    x=lfreq_pos(lfreq);
    y=y0;
    
    i_GC.set_foreground(i_col_pointer);
    x1=x-9;  if (x1<x0)         x1 = x0;
    x2=x+9;  if (x2>width()-x0) x2 = width()-x0;
    win.draw_rectangle( i_GC, true, x1,y+1,x2-x1+1,h-1 );
    
    i_GC.set_foreground(i_col_draw);
    win.draw_line( i_GC, x,y+1,x,y+h-1 );
}


void LogView::delarrow()
{
    int x,y,x1,x2;
    
    if (!i_GC){
        Gdk_Window win_ = get_window();
        i_GC = Gdk_GC( win_ );
    }
    
    Gdk_Window win = get_window();
//        x=(int)( x0+(lfreq-lfreq0)*(width()-20)/LOG_2+0.5 );
    x=lfreq_pos(lfreq);
    y=y0;
    
    i_GC.set_foreground(i_col_bg2);
    x1=x-9;  if (x1<x0)         x1 = x0;
             if (x1>width()-x0) x1 = width()-x0;
    x2=x+9;  if (x2>width()-x0) x2 = width()-x0;
             if (x2<x0)         x2 = x0;
    win.draw_rectangle( i_GC, true, x1,y+1,x2-x1+1,h-1 );
}


void LogView::change_lfreq(double freq)
{
    double mldf,ldf;
    int i,note;

    delarrow();
    lfreq=freq;
    while (lfreq>lfreq1) lfreq-=LOG_2;
    while (lfreq<lfreq0) lfreq+=LOG_2;
    mldf=D_NOTE_LOG; note=0;
    for( i=0; i<12; i++ ){
        ldf = fabs(lfreq-lfreqs[i]);
        if (ldf<mldf) { mldf=ldf; note=i; }
    }
    drawarrow();
}


void LogView::setScale(int scale)
{
    switch(scale){
    case us_scale:
        note=note_us;
        break;
    case german_scale:
        note=note_ger;
        break;
    case us_scale_alt:
        note=note_us_alt;
        break;
    case german_scale_alt:
        note=note_ger_alt;
        break;
    }
    draw_it();
}


// protected:

void LogView::draw_it()
{
    int i,k,x,y,x2;
    char  str[100];
    double nat_freq[23];
    double nat_lfreq[23];
    int z,n;

    Gdk_Font bigfont("8x13");
//    Gdk_Font bigfont("5x8");
    Gdk_Font font("5x8");

    if (!i_GC){
        Gdk_Window win_ = get_window();
        i_GC = Gdk_GC( win_ );
    }
    
    Gdk_Window win = get_window();

    lfreq0 = KAMMERTON_LOG - D_NOTE_LOG/2.0;
    lfreq1 = KAMMERTON_LOG - D_NOTE_LOG/2.0 + LOG_2;

    i_GC.set_foreground( i_col_bg );
    win.draw_rectangle( i_GC, true,  0,0,width(),height() );
    
    i_GC.set_foreground( i_col_bg2 );
    win.draw_rectangle( i_GC, true,  x0,y0+1,width()-2*x0,h-1 );
    
    
    delarrow();

    for(i=0;i<12;i++){
        freqs [i] = KAMMERTON * pow(D_NOTE,i);
        lfreqs[i] = KAMMERTON_LOG + (double)i*D_NOTE_LOG;
    }

    for(i=0;i<23;i++){
        sscanf(tuning_nat[i],"%d/%d",&z,&n);
        //         printf("z=%d,n=%d\n",z,n);
        nat_freq[i]=freqs[grundton]*(double)z/(double)n;
        nat_lfreq[i]=log(nat_freq[i]);
        if ( nat_lfreq[i]>lfreq1 ){
            nat_lfreq[i]-=LOG_2;
            nat_freq[i]/=2.0;
        }
    }

//        lfreq0=lfreqs[0]-D_NOTE_LOG/2.0;
      i_GC.set_foreground( i_col_ticks );
    	for(k=0;k<120;k++){
        x2=lfreq_pos(KAMMERTON_LOG + (double)(k-5)/10.0*D_NOTE_LOG);
//	      x2=(int)( (double)x0+(double)(width()-2*x0)
//                 *(double)k/120.0+0.5 );
    	 win.draw_line( i_GC, x2,y0,x2,y0-((k%5==0)?5:3) );
       	 win.draw_line( i_GC, x2,y0+h,x2,y0+h+((k%5==0)?5:3) );
    	}

      if(nat_tuning_on){
          // draw natural tuning
          i_GC.set_font(font);
          
          i_GC.set_foreground( i_col_draw );
          x2=lfreq_pos(lfreqs[grundton]);
    	  win.draw_line( i_GC, x2,y0+h,x2,y0+h+10+
                               +font.height()*2 );

          i_GC.set_foreground( i_col_shad );
          win.draw_string( font, i_GC,
                           x2-font.string_width("Key")/2+1,
                           y0+h+10+font.ascent()
                            +font.height()*2+1,
                           "Key"
                         );
          
          i_GC.set_foreground( i_col_draw );
          win.draw_string( font, i_GC,
                           x2-font.string_width("Key")/2,
                           y0+h+10+font.ascent()
                           +font.height()*2,
                           "Key"
                         );
          
          i_GC.set_foreground( i_col_marks );
          for(k=0;k<23;k++){
              x2=lfreq_pos(nat_lfreq[k]);
//    	      p.drawLine(x2,y0+h,x2,y0+h+10);
    	      win.draw_line( i_GC, x2,y0+h,x2,y0+h+10+
                                   +font.height()*(k%3) );
          }
          
          for(k=0;k<23;k++){
              x2=lfreq_pos(nat_lfreq[k]);
              i_GC.set_foreground( i_col_shad );
              win.draw_string( font, i_GC,
                               x2-font.string_width(tuning_nat[k])/2+1,
                               y0+h+10+font.ascent()
                               +font.height()*(k%3)+1,
                               tuning_nat[k]
                             );
              
              i_GC.set_foreground( i_col_draw );
              win.draw_string( font, i_GC,
                               x2-font.string_width(tuning_nat[k])/2,
                               y0+h+10+font.ascent()
                               +font.height()*(k%3),
                               tuning_nat[k]
                             );
    	   }
      }
        
      i_GC.set_foreground( i_col_draw );
      win.draw_line( i_GC, x0,y0,width()-10,y0 );
      win.draw_line( i_GC, x0,y0+h,width()-10,y0+h );
      for(i=0;i<12;i++){
          
          x=lfreq_pos(lfreqs[i]);
//    	   x=(int)( (double)x0+(double)(width()-2*x0)
//                 *(double)(lfreqs[i]-lfreq0)/LOG_2+0.5 );
          y=y0;
          win.draw_line( i_GC, x,y,x,y-7 );
          if(!nat_tuning_on)
              win.draw_line( i_GC, x,y+h,x,y+h+7 );

          i_GC.set_foreground( i_col_shad );
          win.draw_string( bigfont, i_GC,
                           x-bigfont.string_width(note[i])/2+1,y-10+1,
                           note[i]
                         );
          
          i_GC.set_foreground( i_col_draw );
          win.draw_string( bigfont, i_GC,
                           x-bigfont.string_width(note[i])/2,y-10,
                           note[i]
                         );

          if(!nat_tuning_on){
              for(k=0;k<4;k++){
                  sprintf(str,"%.2f",(double)(freqs[i]/8.0*(1<<k)));
                  i_GC.set_foreground( i_col_shad );
                  win.draw_string( font, i_GC,
                                   x-font.string_width(str)/2+1,
                                   y+h+10+font.ascent()+1
                                   +font.height()*k, str
                                 );
                  
                  i_GC.set_foreground( i_col_draw );
                  win.draw_string( font, i_GC,
                                   x-font.string_width(str)/2,
                                   y+h+10+font.ascent()
                                   +font.height()*k, str
                                 );
              }
          }
          
      }
//	y=y0+h+10+p.fontMetrics().height()*5;
//	p.setFont(QFont("System",12));
//	p.drawText(x0,y,"Frequancy [Hz]:");
}


gint LogView::expose_event_impl(GdkEventExpose* p0)
{
    printf("executing LogView::expose_event_impl(p0)\n");
    Gtk::DrawingArea::expose_event_impl(p0);
    draw_it();
    return true;
}

/*
void LogView::draw_default_impl()
{
    Gtk::Widget::draw_default_impl();
    draw_it();
}
*/


gint LogView::button_press_event_impl(GdkEventButton* p0)
{
    int x,y;

    get_pointer(x,y);
    printf("pointer:%d,%d\n",x,y);
    grundton=pos_note(x);
    printf("grundton=%d\n",grundton);
//    GdkEventExpose ev;
    //    expose_event(&ev);
    draw_it();
    Gtk::DrawingArea::button_press_event_impl(p0);
    return true;
}


void LogView::set_nat_tuning(bool state)
{
    nat_tuning_on = state;
    draw_it();
}
