/*
 *  Authors: Rodney Dawes <dobey@users.sourceforge.net>
 *
 *   ThinIce Authors: Tomas gren <stric@ing.umu.se>
 *   Clean Author: dengen40@yahoo.com
 *
 *
 *  Copyright 2002-2007 Elysium Project (elysium-project.sourceforge.net)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of version 2 of the GNU General Public License
 *  as published by the Free Software Foundation
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 *
 */

#include <gmodule.h>

#include "cleanice.h"

G_MODULE_EXPORT void theme_init (GTypeModule * module) {
  cleanice_rc_style_register_type (module);
  cleanice_style_register_type (module);
}

G_MODULE_EXPORT void theme_exit (void) {
}

G_MODULE_EXPORT GtkRcStyle * theme_create_rc_style (void) {
  void *ptr;

  ptr = GTK_RC_STYLE (g_object_new (CLEANICE_TYPE_RC_STYLE, NULL));
  return (GtkRcStyle *) ptr;
}

/* The following function will be called by GTK+ when the module
 * is loaded and checks to see if we are compatible with the
 * version of GTK+ that loads us.
 */
#if 0
G_MODULE_EXPORT const gchar * g_module_check_init (GModule * module);

const gchar * g_module_check_init (GModule * module) {
  return gtk_check_version (GTK_MAJOR_VERSION, GTK_MINOR_VERSION,
			    GTK_MICRO_VERSION - GTK_INTERFACE_AGE);
}
#endif
