//*****************************************************************************
//                                PnlGnuCapOP.hpp                             *
//                               -----------------                            *
//  Description : This class derives from the Analysis Panel base class and   *
//                provides a GUI for a user to configure a Operating Point    *
//                Analysis for GNU-Cap electronic circuit simulator.          *
//  Started     : 06/11/2003                                                  *
//  Last Update : 05/10/2007                                                  *
//  Copyright   : (C) 2003 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PNLGNUCAPOP_HPP
#define PNLGNUCAPOP_HPP

// System Includes


// wxWindows Library Includes


// Application Includes

#include "base/PnlAnaBase.hpp"

// Local Constant Declarations

//*****************************************************************************

class PnlGnuCapOP : public PnlAnaBase
{
  private:

    void  Create( void );
    void  InitStepScale( void );
    bool  bSetStepScale( eScaleType eScale );

  public:

    PnlGnuCapOP( wxWindow * poWin );
   ~PnlGnuCapOP( );

    bool  bClear( void );

    bool  bLoad( Simulation & roSim );
    bool  bSave( Simulation & roSim );

    // Event handlers
    void  OnStepScale ( wxCommandEvent & roEvtCmd );
    void  OnSigSrcCpnt( wxCommandEvent & roEvtCmd );

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // PNLGNUCAPOP_HPP
