//*****************************************************************************
//                                PnlGnuCapDC.hpp                             *
//                               -----------------                            *
//  Description : This class derives from the Analysis Panel base class and   *
//                provides a GUI for a user to configure a DC Analysis for    *
//                GNU-Cap electronic circuit simulator.                       *
//  Started     : 18/08/2003                                                  *
//  Last Update : 05/10/2007                                                  *
//  Copyright   : (C) 2003 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PNLGNUCAPDC_HPP
#define PNLGNUCAPDC_HPP

// System Includes


// wxWindows Library Includes


// Application Includes

#include "base/PnlAnaBase.hpp"

// Local Constant Declarations


//*****************************************************************************

class PnlGnuCapDC : public PnlAnaBase
{
  private:

    void  Create( void );
    void  InitSwpUnits( void );
    void  InitStepScale( void );
    bool  bSetStepScale( eScaleType eScale );

  public:

    PnlGnuCapDC( wxWindow * poWin );
   ~PnlGnuCapDC( );

    bool  bClear( void );

    bool  bLoad( Simulation & roSim );
    bool  bSave( Simulation & roSim );

    // Event handlers
    void  OnStepScale ( wxCommandEvent & roEvtCmd );
    void  OnSigSrcCpnt( wxCommandEvent & roEvtCmd );

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // PNLGNUCAPDC_HPP
