/*

struct_tm.c

Custom serializer for <time.h> struct tm

Compile this file and link it with your code.

gSOAP XML Web services tools
Copyright (C) 2000-2005, Robert van Engelen, Genivia Inc., All Rights Reserved.
This part of the software is released under one of the following licenses:
GPL, the gSOAP public license, or Genivia's license for commercial use.
--------------------------------------------------------------------------------
gSOAP public license.

The contents of this file are subject to the gSOAP Public License Version 1.3
(the "License"); you may not use this file except in compliance with the
License. You may obtain a copy of the License at
http://www.cs.fsu.edu/~engelen/soaplicense.html
Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the License.

The Initial Developer of the Original Code is Robert A. van Engelen.
Copyright (C) 2000-2005, Robert van Engelen, Genivia, Inc., All Rights Reserved.
--------------------------------------------------------------------------------
GPL license.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place, Suite 330, Boston, MA 02111-1307 USA

Author contact information:
engelen@genivia.com / engelen@acm.org
--------------------------------------------------------------------------------
A commercial use license is available from Genivia, Inc., contact@genivia.com
--------------------------------------------------------------------------------
*/

// soapH.h generated by soapcpp2 from .h file containing #import "struct_tm.h":
#include "soapH.h"

void soap_default_xsd__dateTime(struct soap *soap, struct tm *a)
{ memset(a, 0, sizeof(struct tm));
}

void soap_serialize_xsd__dateTime(struct soap *soap, struct tm const *a)
{ }

int soap_out_xsd__dateTime(struct soap *soap, const char *tag, int id, const struct tm *a, const char *type)
{ if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xsd__dateTime), type)
   || soap_string_out(soap, soap_xsd__dateTime2s(soap, *a), 0))
    return soap->error;
  return soap_element_end_out(soap, tag);
}

const char *soap_xsd__dateTime2s(struct soap *soap, const struct tm a)
{ strftime(soap->tmpbuf, sizeof(soap->tmpbuf), "%Y-%m-%dT%H:%M:%SZ", &a);
  return soap->tmpbuf;
}

struct tm *soap_in_xsd__dateTime(struct soap *soap, const char *tag, struct tm *a, const char *type)
{ if (soap_element_begin_in(soap, tag, 0, NULL))
    return NULL;
  if (*soap->type
   && soap_match_tag(soap, soap->type, type)
   && soap_match_tag(soap, soap->type, ":dateTime"))
  { soap->error = SOAP_TYPE;
    soap_revert(soap);
    return NULL;
  }
  a = (struct tm*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__dateTime, sizeof(struct tm), 0, NULL, NULL, NULL);
  if (*soap->href)
    a = (struct tm*)soap_id_forward(soap, soap->href, a, 0, SOAP_TYPE_xsd__dateTime, 0, sizeof(struct tm), 0, NULL);
  else if (a)
  { if (soap_s2xsd__dateTime(soap, soap_value(soap), a))
      return NULL;
  }
  if (soap->body && soap_element_end_in(soap, tag))
    return NULL;
  return a;
}

int soap_s2xsd__dateTime(struct soap *soap, const char *s, struct tm *a)
{ memset((void*)a, 0, sizeof(struct tm));
  if (s)
  { char zone[32];
    const char *t;
    zone[sizeof(zone)-1] = '\0';
    if (strchr(s, '-'))
      t = "%d-%d-%dT%d:%d:%d%31s";
    else if (strchr(s, ':'))
      t = "%4d%2d%2dT%d:%d:%d%31s";
    else /* parse non-XSD-standard alternative ISO 8601 format */
      t = "%4d%2d%2dT%2d%2d%2d%31s";
    sscanf(s, t, &a->tm_year, &a->tm_mon, &a->tm_mday, &a->tm_hour, &a->tm_min, &a->tm_sec, zone);
    a->tm_wday = -1;
    a->tm_yday = -1;
    if (a->tm_year == 1)
      a->tm_year = 70;
    else
      a->tm_year -= 1900;
    a->tm_mon--;
    if (*zone)
    { if (*zone == '.')
      { for (s = zone + 1; *s; s++)
          if (*s < '0' || *s > '9')
            break;
      }
      else
        s = zone;
      if (*s == '+' || *s == '-')
      { int h = 0, m = 0;
        if (s[3] == ':')
        { sscanf(s, "%d:%d", &h, &m);
          if (h < 0)
            m = -m;
        }
        else
        { m = (int)atol(s);
          h = m / 100;
          m = m % 100;
        }
        a->tm_hour -= h;
        a->tm_min -= m;
      }
      a->tm_isdst = 0;
    }
    else
      a->tm_isdst = -1;
  }
  return soap->error;
}
