/* callbacks.h --- callbacks definitions */

/* Copyright (c) E. Lassauge, 2000-2001.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 * mailto:lassauge@mail.dotcom.fr
 * http://lassauge.free.fr/
 *
 * REVISION HISTORY: see Changelog
 *
 */

#ifndef _CALLBACKS_H
#define _CALLBACKS_H

#include <gnome.h>

/* utility defines for the callbacks */
#define UP_PRESSED	1
#define DOWN_PRESSED	0

#define CANCEL_PRESSED	-1
#define APPLY_PRESSED	0
#define OK_PRESSED	1

#define SEL_PRESSED	1
#define UNSEL_PRESSED	0

/* signal callbacks */
void on_script_ok_pressed(GtkWidget * widget, GtkFileSelection *filesel);

void on_pref_ok_pressed(GtkButton * button, gpointer user_data);

void on_new_file_activate(GtkMenuItem * menuitem, gpointer user_data);

void on_goto_smssend_activate(GtkMenuItem * menuitem, gpointer user_data);

void on_sendnow_activate(GtkMenuItem * menuitem, gpointer user_data);

void on_close_activate(GtkMenuItem * menuitem, gpointer user_data);

void on_exit_activate(GtkMenuItem * menuitem, gpointer user_data);

void on_preferences_activate(GtkMenuItem * menuitem, gpointer user_data);

void on_check_updates_activate(GtkMenuItem * menuitem, gpointer user_data);

void on_manage_alias_activate(GtkMenuItem * menuitem, gpointer user_data);

void on_manage_scripts_activate(GtkMenuItem * menuitem, gpointer user_data);

void on_about_activate(GtkMenuItem * menuitem, gpointer user_data);

void on_send_pressed(GtkButton * button, gpointer user_data);

void on_message_changed(GtkEditable * editable, gpointer user_data);

void on_value_changed(GtkEditable * editable, gpointer user_data);

void on_value_check(GtkEditable * editable, gpointer user_data);

void on_alias_clist_select_row(GtkCList *clist,
                               gint     row,
                               gint     column,
                               GdkEvent *event,
                               gpointer user_data);

void on_alias_clist_unselect_row(GtkCList *clist,
                                 gint     row,
                                 gint     column,
                                 GdkEvent *event,
                                 gpointer user_data);

void on_updown_clicked(GtkButton *button, gpointer user_data);

void on_add_clicked(GtkButton *button, gpointer user_data);

void on_delete_clicked(GtkButton *button, gpointer user_data);

void on_alias_ok_pressed(GtkButton * button, gpointer user_data);

void on_script_val_pressed(GtkButton * button, gpointer user_data);

void on_script_clist_click_column(GtkCList        *clist,
                                  gint             column,
                                  gpointer         user_data);

void on_script_clist_select_row(GtkCList        *clist,
                                gint             row,
                                gint             column,
                                GdkEvent        *event,
                                gpointer         user_data);

#endif
