#ifndef GSDDictParameters_h
#define GSDDictParameters_h

/*
	GSDDictParameters.h for GSDict application

*/

#include <Foundation/NSData.h>
#include <Foundation/NSAttributedString.h>
#include <AppKit/NSDocument.h>
#include <AppKit/NSTextView.h>
#include <AppKit/NSPrintInfo.h>

@interface GSDictParameters : NSObject <NSCopying>
{
	NSString* _word;
	NSString* _hostName;
	int _port;
	NSString* _database;
	BOOL _match;
	NSString* _strategy;
	NSMutableDictionary* _parameters;
}

+ (id)parametersWithDictionary:(NSDictionary*)dico;

+ (id)defaultParameters;

- (id)initWithUserDefaults;

- (id)initWithParameters:(GSDictParameters*)parameters;

- (BOOL)saveAsDefaults;

- (void)setWord:(NSString*)word;

- (NSString*)word;

- (void)setHostName:(NSString*)hostName;

- (NSString*)hostName;

- (void)setPort:(int)port;

- (int)port;

- (void)setDatabase:(NSString*)database;

- (NSString*)database;

- (NSArray*)databases;

- (void)setMatch:(BOOL)match;

- (BOOL)match;

- (void)setStrategy:(NSString*)strategy;

- (NSString*)strategy;

- (NSArray*)strategies;

- (id) copyWithZone: (NSZone*)zone;

@end

#endif
