/*************************************************************************
 * gruftistats data structures
 * Copyright (c) 1998-9    Andy Kempling (aurikan@hotmail.com), 
 * Copyright (c) 1998-2001 Colin Phipps <cphipps@doomworld.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *************************************************************************/
/* $Id: ircstats.h,v 1.12 2001/07/21 10:18:18 cph Exp $ */
#ifndef __GRUFDATA_H__
#define __GRUFDATA_H__

#include "config.h"

#include <stdio.h>
#include <sys/types.h>
#include <regex.h>

#ifdef HAVE_LIBDMALLOC
#include <dmalloc.h>
#endif

#define NUM_RANDOM 5   
#define RECORD_MAX 5   
#define RECORD_NUM 5   

typedef struct rquote_s {
  char *quote;
  int choices;
} rquote_t;

typedef struct user_s {
  char *name;
  char *curnick;
  rquote_t quote;
  char *lastline;
  long int lines;
  long int texts[4];
  long int acts[4];
  long int letters, questions, loud, punct, statword;
  long int joins;
  long int kicked;
  long int kicks;
  long int nicks;
  long int statcalls;
  long int seens;
  long int urls;
  long int topics;
  long int sought;
  short int alive, monologues, answered;
  enum {
    UF_NONE = 0,
    UF_ASKING = 1,
  } flags;
} user;

typedef struct {
  char name[16];
  long int lines[24];
  long int tlines;
  char *curtopic;
  char date[16];
  rquote_t quote;
} chan;

typedef struct {
  unsigned int num;
  unsigned int delled;
  char* random[NUM_RANDOM];
  char* bywho[NUM_RANDOM];
} some_random_stuff;

typedef enum LTypes LT;

typedef const struct {
  char tag[20];
  char *where;
  int max;
} response_settings;

typedef struct {
int num;
char name[16];
char date[16];
} record_t;

typedef struct {
char name[32];
record_t record[RECORD_MAX];
} recordset;

/* Now for some portability stuff..
 * If we are missing certain functions, remap them
 * or define prototypes and get them from lib.c
 */

#ifndef HAVE_STRICMP  
#ifdef HAVE_STRCASECMP
#define stricmp strcasecmp
#else
#error No case insensitive string compare?
#endif
#endif

#ifndef HAVE_STRLCPY
size_t strlcpy(char* dest, const char* source, size_t len);
#endif
#ifndef HAVE_STRLCAT
size_t strlcat(char* dest, const char* source, size_t len);
#endif
#ifndef HAVE_STRLWR
char* strlwr(char* s);
#endif

/* More string utility functions */
char* strcasestr(char* haystack, const char* needle);
void stripansi(char* str);
char* strdup_from_rmatch(const char* str, const regmatch_t* prm);

/* Regexp log format stuff */
/* The type of line */
enum line_type_e {
  LT_NULL,
  LT_TEXT,
  LT_ACT,
  LT_JOIN,
  LT_PART,
  LT_SIGNOFF,
  LT_KICK,
  LT_TOPIC,
  LT_NICK,
  LT_MODE,
  LT_DATE_STAMP,
  LT_CHANNEL,
  LT_NUM
};

/* Code which represents a bit of info tha a line might contain */
enum line_part_e {
  LP_TIME,
  LP_NICK,
  LP_OTHERNICK, /* The target of a kick, or nick change */
  LP_STRING, /* This is the mode string, kick/quit reason, or line of text */
  LP_DATE,
  LP_CHANNEL,
  LP_NUM
};

struct log_parse_s {
  regex_t compiled_regex;
  int returned_bit[LP_NUM];
};

struct log_parse_s* ReadLogFormatSpec(FILE* infp, int verbose);
void output_content(FILE * output, char * line);

#endif
