/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *   delay.cpp - a delay function                                         *
 *   Authors: Lawrence Kincheloe &                                        *
 *            Philip McCauley                                             *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 2, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/ 

#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <time.h>
#include <unistd.h>
#include <math.h>
#include "delay.h"
extern "C" {
 #include <verbose.h>
}

using namespace std;

// void Retry_Delay(int x)
// Retry_Delay is called with the number of failures received when
// attempting to contact the Grub server.  Its function is to sleep
// an amount that is scaled to the amount of failures.  Probabale max
// sleep time is around a day or so with a 100 failures.  Of course
// this amount would only be achieved if the server was down for more
// than a month.
//
// function uses y = 8 * x^2 as its computation

void Retry_Delay(int failcnt)

{
	double wait_time = 0;   //retry delay time in seconds
	double drift, failures, final;
	int final_sleep;
	srand(time(NULL));
	failures = (double) failcnt;
	wait_time = 8 * pow( failures, 2.0);
	drift = rand() / ( ( RAND_MAX / ( wait_time * .40 ) ) );
	final = wait_time - ( wait_time * .20 ) + drift;	
	final_sleep = (int) final;
        Verboseprintf("\nClient sleeping for %d seconds!\n", final_sleep );
	sleep(final_sleep);
	return;
}

