#ifndef _STATUSINTERFACE_H_
#define _STATUSINTERFACE_H_

#include "ConfigFileInfo.h"
#include "../guiface/BaseFace.h"
#include <cstring>
#include <cstdio>

#define ESTIMATED_NUM_URLS 500		// estimate number of URLs that we may receive from the server

/* Status_Info is a data type that allows all parts of the client to 
 * pass status information and settings around to each part of the
 * system.  This is a globally defined struct, with all threads 
 * having equal access to it. */
struct Status_Info 
{
	bool console;			// true if in console mode, false if in GUI mode
	bool verbose;			// true if in verbose mode, false if in quiet mode
	bool superverbose;		// true if in super verbose mode, false if verbose is false
	bool dumb_mode;			// mode used to wait on settings from grubface

	bool signalhandle;	 	// true if we have already gotten a signal from the kernel

        bool bandwidth_limit;   	// boolean value to indicate crawler is undergoing bandwidth limiting
        bool host_protect;              // boolean value to indicate crawler is limiting to protect remote host
	bool sleep_indicator;		// boolean value to indicate crawler is sleeping

	bool pause;			// boolean value to indicate to the system to just "hang out"

	bool protocol_quit;		// boolean value to indicate that client talk protocol should exit (currently not used)
	bool crawler_quit;		// boolean value to indicate that crawler should exit (currently not used)
	bool coordinator_quit;		// boolean value to indicate that coordinator should exit 
	bool gui_quit;			// boolean value to indicate that GUI should exit
	bool coordinator_pause;		// boolean value to indicate that coordinator should pause
	bool crawler_pause;		// boolean value to pause the crawler class
	bool hup_request;		// boolean value to request a read of the config file and server settings
	
	const char *logpath;		// path to the logfile

        float current_url;              // current number of URLs that have been crawled this run
        float max_url;                  // number of URLs given by the server to crawl

        int current_action;             // defines current status of crawler (0 - get, 1 - crawl, 2 - put)

        int usage;                      // current bandwidth usage
	int engaged;			// current number of crawlers engaged

	int url_run;			// number of urls to crawl before exiting
	int byte_run;			// number of bytes to crawl before exiting

	int total_bytes;		// total number of bytes that have been used for this run

	int total_urls;			// total number of urls that have been crawled for this run
        int unchanged_urls;             // number of unchanged urls that have been crawled for this run
        int updated_urls;               // number of updated urls that have been crawled this run
        int redirect_urls;              // number of redirected urls that have been crawled this run
        int down_urls;                  // number of down urls that have been crawled this run
        int not_found_urls;             // number of not found urls that have been crawled this run
        int no_crawl_urls;              // number of no crawl urls that have been crawled this run
	int robot_urls;			// number of robot.txt urls that have been crawled this run

	int NewVersionFlag;		// flag from grub server indicating a new version of the client is available
					// 0 for current version, 1 for older version, 2 for outdated version

	int HistoricURLs;		// total number of URLs ever crawled by a particular client ID 
	int TodaysURLs;			// total number of URLs crawled today by client ID
	int OverallURLRank;		// ranking information for a particular client ID
	int DailyURLRank;		// ranking information for today for a client ID

        Status_Info()
        {
		// zero out the status info struct
                memset(this, 0, sizeof(Status_Info));

		// we are zeroing out the Config_Info here because
		// Config_Info needs to be a C struct, and as such
		// doesn't have a constructor.
		memset(&Config_File_Info, 0, sizeof(Config_Info));
        }
	
        ~Status_Info()
        {
		if (Config_File_Info.ClientPassword)
		{
			delete Config_File_Info.ClientPassword;
			Config_File_Info.ClientPassword = NULL;
		}

		if (Config_File_Info.Proxy)
		{
			delete Config_File_Info.Proxy;
			Config_File_Info.Proxy = NULL;
		}
	}

	void clearStatusInfo()
	{
		// zero out stats based on run
		current_url = 0;
		total_bytes = 0;
		total_urls = 0;
		unchanged_urls = 0;
		updated_urls = 0;
		redirect_urls = 0;
		down_urls = 0;
		not_found_urls = 0;
		no_crawl_urls = 0;
		robot_urls = 0;
		engaged = 0;
		usage = 0;
		max_url = ESTIMATED_NUM_URLS;
	}
	
};

extern Status_Info Crawler_Status_Info;

class Status : public BaseFace
{
	public:
		// our constructor/destructor
		Status::Status();
		Status::~Status();

		void Status::pauseCrawler(bool state);
		void Status::softShutdown();
		void Status::hardShutdown();
		bool Status::setBandwidthLimit(int new_band_limit);
		int Status::getBandwidth();
		int Status::getBandwidthLimit();
		int Status::getNumberCrawlers();
		bool Status::setNumberCrawlers(int new_number_crawlers);

		virtual void EventSetBandwidth(int Bandwidth);
		virtual void EventSetCrawlerCount(int Count);

		virtual void EventGetBandwidth();
		virtual void EventGetBandwidthLimit();
		virtual void EventGetCrawlerCount();
		virtual void EventGetStatus();

	private:
};

#endif
