'use strict';

goog.provide('grrUi.core.legacyRendererDirective.LegacyRendererController');
goog.provide('grrUi.core.legacyRendererDirective.LegacyRendererDirective');

goog.scope(function() {


/** @private {number} */
grrUi.core.legacyRendererDirective.globalIdCounter_ = 0;



/**
 * Controller for LegacyRendererDirective.
 *
 * @constructor
 * @param {!angular.Scope} $scope
 * @ngInject
 */
grrUi.core.legacyRendererDirective.LegacyRendererController = function($scope) {
  /** @private {!angular.Scope} */
  this.scope_ = $scope;

  /**
   * Current value of the global counter. Legacy renderers expect to be
   * rendered inside divs with a unique id.
   * @export {number}
   */
  this.idCounter = grrUi.core.legacyRendererDirective.globalIdCounter_++;
};

var LegacyRendererController =
    grrUi.core.legacyRendererDirective.LegacyRendererController;


/**
 * Renders a renderer inside the div generated by the directive's template.
 * This has to be called inside directive's link function, as render_ modifies
 * the DOM generated by the directive.
 * @private
 */
LegacyRendererController.prototype.render_ = function() {
  var domId = 'legacy_' + this.idCounter.toString();
  grr.layout(this.scope_['renderer'], domId, this.scope_['queryParams'],
             function() {
               // Special case handling for dialogs shown through combination
               // of legacy rendering and Bootstrap UI's $modal.
               $('#' + domId).find('button[data-dismiss=modal]').click(
                   /** @suppress {missingProperties} For jQuery.scope(). */
                   function() {
                     var parentScope = $(this).scope().$parent;
                     parentScope.$dismiss();
                   });
             });
};


/**
 * LegacyRendererDirective renders content via legacy GRR renderers.
 *
 * @return {angular.Directive} Directive definition object.
 */
grrUi.core.legacyRendererDirective.LegacyRendererDirective = function() {
  return {
    scope: {
      renderer: '@',
      queryParams: '=?'
    },
    template: '<div id="legacy_{$ ::controller.idCounter $}">Loading...</div>',
    restrict: 'E',
    controller: LegacyRendererController,
    controllerAs: 'controller',
    link: function(scope) {
      scope.controller.render_();
    }
  };
};


/**
 * Directive's name in Angular.
 *
 * @const
 * @export
 */
grrUi.core.legacyRendererDirective.LegacyRendererDirective.directive_name =
    'grrLegacyRenderer';


});  // goog.scope
