/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2001 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "game.h"
#include "intl.h"
#include "new_game_dialog.h"

NewGameDialog::NewGameDialog(Game* game) : Dialog(_("New Game")), _game(game)
{
   // Create 'size' frame.
   GtkWidget* frame = gtk_frame_new(_("Size"));
   gtk_container_border_width(GTK_CONTAINER(frame), 10);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(_window)->vbox), frame, TRUE, TRUE, 
		      10);
   gtk_widget_show(frame);

   GtkWidget* table = gtk_table_new(6, 2, FALSE);
   gtk_container_border_width(GTK_CONTAINER(table), 10);
   gtk_container_add(GTK_CONTAINER(frame), table);

   gtk_table_set_row_spacings(GTK_TABLE(table), 5);
   gtk_table_set_col_spacings(GTK_TABLE(table), 5);
   gtk_widget_show(table);

   GSList* group;

   _beginner = gtk_radio_button_new_with_label(NULL, _("Beginner (2x2)"));
   gtk_table_attach_defaults(GTK_TABLE(table), _beginner, 0, 1, 0, 1);
   gtk_widget_show(_beginner);

   group = gtk_radio_button_group(GTK_RADIO_BUTTON(_beginner));
   _intermediate = gtk_radio_button_new_with_label(group, 
						   _("Intermediate (5x5)"));
   gtk_table_attach_defaults(GTK_TABLE(table), _intermediate, 0, 1, 1, 2);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(_intermediate), TRUE);
   gtk_widget_show(_intermediate);

   group = gtk_radio_button_group(GTK_RADIO_BUTTON(_intermediate));
   _expert = gtk_radio_button_new_with_label(group, _("Expert (9x9)"));
   gtk_table_attach_defaults(GTK_TABLE(table), _expert, 0, 1, 2, 3);
   gtk_widget_show(_expert);

   group = gtk_radio_button_group(GTK_RADIO_BUTTON(_expert));
   _user_definable = gtk_radio_button_new_with_label(group, 
						     _("User definable"));
   gtk_table_attach_defaults(GTK_TABLE(table), _user_definable, 0, 1, 3, 4);
   gtk_signal_connect(GTK_OBJECT(_user_definable), "clicked",
		      GTK_SIGNAL_FUNC(NewGameDialog::UserDefinableCB), 
		      (gpointer) this);
   gtk_widget_show(_user_definable);

   _column_label = gtk_label_new(_("Columns:"));
   gtk_table_attach_defaults(GTK_TABLE(table), _column_label, 0, 1, 4, 5);
   gtk_widget_show(_column_label);

   _row_label = gtk_label_new(_("Rows:"));
   gtk_table_attach_defaults(GTK_TABLE(table), _row_label, 0, 1, 5, 6);
   gtk_widget_show(_row_label);
   
   GtkObject* adj1 = gtk_adjustment_new(2, 2, 10, 1, 1, 1);
   _columns = gtk_spin_button_new(GTK_ADJUSTMENT(adj1), 1, 0);
   gtk_entry_set_editable(GTK_ENTRY(_columns), FALSE);
   gtk_table_attach_defaults(GTK_TABLE(table), _columns, 1, 2, 4, 5);
   gtk_widget_show(_columns);

   GtkObject* adj2 = gtk_adjustment_new(2, 2, 10, 1, 1, 1);
   _rows = gtk_spin_button_new(GTK_ADJUSTMENT(adj2), 1, 0);
   gtk_entry_set_editable(GTK_ENTRY(_rows), FALSE);
   gtk_table_attach_defaults(GTK_TABLE(table), _rows, 1, 2, 5, 6);
   gtk_widget_show(_rows);

   SetRowColumns(FALSE);
   AddCancelButton();
}

void
NewGameDialog::SetRowColumns(gint sensitive)
{
   gtk_widget_set_sensitive(_column_label, sensitive);
   gtk_widget_set_sensitive(_row_label, sensitive);
   gtk_widget_set_sensitive(_columns, sensitive);
   gtk_widget_set_sensitive(_rows, sensitive);
}

void 
NewGameDialog::UserDefinableCB(GtkWidget *widget, gpointer data)
{
   ((NewGameDialog*) data)->SetRowColumns(
      gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
}


void
NewGameDialog::OnOk()
{
   if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(_beginner))) {
      _game->NewBeginnerGame();
   } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(_intermediate))) {
      _game->NewIntermediateGame();
   } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(_expert))) {
      _game->NewExpertGame();
   } else {
      int columns = gtk_spin_button_get_value_as_int(
	 GTK_SPIN_BUTTON(_columns));
      int rows = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(_rows));
      _game->NewGame(rows, columns);
   }
}

