#!/usr/bin/python
#
# Copyright 2009 Martin Owens
#
# This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
#
"""Script for configuring the bazaar configuration."""

# Import standard python libs
import sys
import logging

from GroundControl.launchpadweb import LaunchpadWeb
from GroundControl.configuration import LaunchpadBazaar

import locale
locale.setlocale(locale.LC_ALL, '')
import gettext
gettext.install("groundcontrol")

if __name__ == '__main__':
    conf = LaunchpadBazaar()
    if not conf.has_bazaar_config():
        myself = LaunchpadWeb()
        if not myself.loggedin():
            logging.warn(_("Launchpad user not logged in, nothing to do."))
            sys.exit(1)
        conf.set_bazaar_config(myself.user, myself.name, myself.emailaddr)
    else:
        logging.warn(_("Nothing to do, launchpad bzr config already set up"))
    sys.exit(0)
