/*
 *  xml2_shim.c
 *  graphviz
 *
 *  Created by Glen Low on Fri Apr 16 2004.
 *  Copyright (c) 2004, Pixelglow Software. All rights reserved.
 *  http://www.pixelglow.com/graphviz/
 *  graphviz@pixelglow.com
 *
 *  Redistribution and use in source and binary forms, with or without modification, are permitted
 *  provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this list of conditions
 *    and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions
 *    and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *  * Neither the name of Pixelglow Software nor the names of its contributors may be used to endorse or
 *    promote products derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
// This shim is to correct a nasty bug on Mac OS X 10.2, where if a framework dylib (dotneato) is weak linked to
// another dylib (libxml2), dyld will crash before hitting main. Since libxml2 is only present on 10.3, we have
// cannot strong link to it. So we will programmatically load it ourselves and bind it to the right functions.

#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/xmlIO.h>
#include <libxml/xmlreader.h>

#include <mach-o/dyld.h>

// one static function pointer per function

#define FUNCTION(NAME)  static void* NAME##_ptr = 0;

#include <xml2_shim.h>

#undef FUNCTION

int xml2_available ()
{
	static int once = 1;
	static const struct mach_header* image = NULL;
	
	if (once) {
		if ((image = NSAddImage ("/usr/lib/libxml2.dylib",
			NSADDIMAGE_OPTION_WITH_SEARCHING |NSADDIMAGE_OPTION_RETURN_ON_ERROR))) {
			NSSymbol symbol;
			
			// bind each static function pointer to the right function
			
			#define FUNCTION(NAME)																				\
			symbol = NSLookupSymbolInImage (image, "_" #NAME, NSLOOKUPSYMBOLINIMAGE_OPTION_RETURN_ON_ERROR);	\
			NAME##_ptr = symbol ? NSAddressOfSymbol (symbol) : NULL;
			
			#include <xml2_shim.h>
			
			#undef FUNCTION
		}
		once = 0;
	}

	return (int) image;
}

void stubs ()
{
	// one Mach-O stub for each xml2 function
	
	#define FUNCTION(NAME) asm (								\
		".align 2\n\t"											\
		".globl _" #NAME "\n"									\
		"_" #NAME ":\n\t"										\
		"mflr r0\n\t"											\
		"bcl 20,31,1f\n"										\
		"1:\n\t"												\
		"mflr r11\n\t"											\
		"mtlr r0\n\t"											\
		"addis r11,r11,ha16(_" #NAME "_ptr-1b)\n\t"				\
		"lwz r12,lo16(_" #NAME "_ptr-1b)(r11)\n\t"				\
		"mtctr r12\n\t"											\
		"bctr");
		
	#include <xml2_shim.h>

	#undef FUNCTION
}