/* $Id: freelist.h,v 1.6 2005/04/05 12:02:55 ellson Exp $ $Revision: 1.6 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#ifndef freelist_h
#define freelist_h

#define COUNT_ALLOCATED
template<typename T>
struct Freelist {
	T *alloc() {
		if(!head) {
			int amount = sizeof(Blockheader) + blocksize * sizeof(T);
#ifdef COUNT_ALLOCATED
			allocated+=amount;
#endif
			Blockheader *mem = reinterpret_cast<Blockheader*>(malloc(amount));
			char *cp = reinterpret_cast<char*>(mem) + sizeof(Blockheader);
			for(int i=0; i<blocksize; i++)
				free(reinterpret_cast<T*>(cp) + i);
			mem->next = blocks;
			blocks = mem;
		}
		Freenode *t = head;
		head = t->nextfree;
		new(t) T;
		return reinterpret_cast<T*>(t);
	}
	void free(T *x) {
		Freenode *f = reinterpret_cast<Freenode*>(x);
		f->nextfree = head;
		head = f;
	}
	void clear() {
		head = 0;
		if(blocks) 
			for(Blockheader *bp = blocks,*np; bp; bp = np) {
				np = bp->next;
				::free(bp);
			}
		blocks = 0;
#ifdef COUNT_ALLOCATED
		allocated=0;
#endif
	}
	Freelist(int blocksize) : head(0),blocksize(blocksize),blocks(0) {
#ifdef COUNT_ALLOCATED
		allocated=0;
#endif
	}
	~Freelist() { clear(); }
protected:
	struct Freenode {
		Freenode *nextfree;
	};

	struct Blockheader {
		Blockheader *next;
	};

	Freenode *head; // list of free nodes
	int blocksize; // number of nodes per block
	Blockheader *blocks; // list of blocks
#ifdef COUNT_ALLOCATED
public:
	int allocated;
#endif
};
#endif // freelist_h
