// -*- c++ -*-
// generated by glade--
//------------------------------------------------------------------------------
// $Id: AboutGRAPP.cpp,v 1.16 2008/07/21 03:04:40 vlg Exp $
//------------------------------------------------------------------------------
//                            AboutGRAPP.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2004,2006 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Sun May 30 21:09:23 EDT 2004
//
//------------------------------------------------------------------------------

#include <gtkmm/image.h>
#include <gtkmm/label.h>
#include <gtkmm/alignment.h>
#include <gtkmm/scrolledwindow.h>

#ifdef HAVE_CONFIG_H
#    include "config.h"
#endif

#include "AboutGRAPP.h"

#ifdef IS_PDA
static const int AG_PADDING = 0;
#else
static const int AG_PADDING = 20;
#endif

AboutGRAPP::
AboutGRAPP () :
	m_url ("http://granule.sourceforge.net/")
{
#if defined (IS_WIN32)
	m_icon_path = "granule.ico";
#else
	m_icon_path = (DATDIR "/pixmaps/granule.png");
#endif

	Gtk::Label* label;

	Gtk::Alignment* align;

	align = manage (new Gtk::Alignment (0.5, 0.2, 0, 0));
	align->set_border_width (AG_PADDING);

	Gtk::VBox* contents = manage (new Gtk::VBox (false, AG_PADDING));
	align->add (*contents);

	/** HBox holds Icon image and package name
	 */
	Gtk::HBox* hbox = manage (new Gtk::HBox (false, 3));
	
	Gtk::Image* icon = manage (new Gtk::Image (m_icon_path));
	hbox->pack_start (*icon, Gtk::PACK_SHRINK, 2);
	icon->set_alignment (1.0, 0.5);

	label = manage (new Gtk::Label);
	hbox->pack_start (*label, Gtk::PACK_SHRINK, 2);
	label->set_markup ("<span size=\"x-large\" weight=\"heavy\">" PACKAGE
					   " " VERSION " </span>\n" + m_url);

	contents->pack_start (*hbox);

	/** Label is the rest of it
	 */
	Glib::ustring info_msg ("\nThe Flashcards Program.\n");
	info_msg += "by Vladislav Grinchenko\n";
	info_msg += "Copyright (C) 2004-2008\n";
	label = manage (new Gtk::Label (info_msg));

	contents->pack_start (*label);

	/** Add <Close> button
	 */
	Gtk::Button* close_b = manage (new Gtk::Button ("Close"));
	Gtk::Box* action_box = get_action_area ();
	if (action_box) {
		action_box->pack_start (*close_b);
	}
	close_b->signal_clicked ().connect (
		sigc::mem_fun (*this, &AboutGRAPP::on_close_clicked));

#if defined(IS_HILDON) || defined(IS_PDA)
	Gtk::ScrolledWindow* scrollw = Gtk::manage (new Gtk::ScrolledWindow);
	scrollw->set_flags (Gtk::CAN_FOCUS);
	scrollw->set_shadow_type (Gtk::SHADOW_NONE);
	scrollw->set_policy (Gtk::POLICY_AUTOMATIC , Gtk::POLICY_AUTOMATIC);
#ifdef GLIBMM_PROPERTIES_ENABLED
	scrollw->property_window_placement ().set_value (Gtk::CORNER_TOP_LEFT);
#endif
	scrollw->add (*align);
	get_vbox ()->pack_start (*scrollw);

#ifdef IS_PDA
	set_resizable (false);
	Gdk::Geometry dp_geometry =	{ 240, 320,	240, 320, 240, 320,-1, -1, -1, -1};
	set_geometry_hints (*this, dp_geometry, 
				Gdk::HINT_MIN_SIZE | Gdk::HINT_MAX_SIZE | Gdk::HINT_BASE_SIZE);
#endif

#ifdef IS_HILDON
	Gdk::Geometry dp_geometry =	{ 640, 480, 640, 480, 640, 480, -1, -1, -1, -1};
	set_geometry_hints (*this, dp_geometry, 
				Gdk::HINT_MIN_SIZE | Gdk::HINT_MAX_SIZE | Gdk::HINT_BASE_SIZE);
#endif

#else  /* Desktop */
	get_vbox ()->pack_start (*align);
#endif

	show_all_children ();
}



	
