#include "config.h"

#include <stdlib.h>

#include <iostream>
#include <string>

#include "gql++/driver-manager.h"
#include "gql++/exception.h"
#include "gql++/result-set.h"
#include "gql++/statement.h"
#include "gql++/database-metadata.h"
#include "gql++/result-set-metadata.h"

using namespace GQL;
using namespace std;

static void usage();

int main(int argc, char *argv[])
{
  DriverManager man;
  string url, user, passwd, tablename;
  
  if (argc < 3 || argc > 5)
  {
    usage();
    exit(EXIT_FAILURE);
  }

  url = argv[1];
  tablename = argv[2];
  
  if (argc > 3)
    user = argv[3];
  if (argc > 4)
    passwd = argv[4];
  
  try
  {
    Connection *conn = man.get_connection(url, user, passwd);
    DatabaseMetaData *dbmd = conn->get_meta_data();
    ResultSet *rs;
    vector<string> types;
    
    dbmd = conn->get_meta_data();
    types.push_back("TABLE");
    rs = dbmd->get_tables("", "", tablename, types);

    if (!rs->next())
    {
      cerr << "No Table '" << tablename << "' found" << endl;
      delete rs;
      exit(EXIT_FAILURE);
    }
    delete rs;
    
    SQLObject *obj = conn->create_object();
      
    rs = dbmd->get_columns("", "", tablename, "%");
    
    while (rs->next())
    {
      rs->get(3, obj);
      string name = obj->to_string();
      rs->get(4, obj);
      string type = obj->to_string();
      rs->get(5, obj);
      string nullable = obj->is_null() ? "-" : obj->to_string();
      rs->get(6, obj);
      string remarks = obj->to_string();
      rs->get(7, obj);
      string default_val = obj->to_string();
      cout << name << "\t| " << type << "\t| " << nullable << "\t| " << remarks
           << "\t| " << default_val << endl;
    }
    delete rs;

    delete conn;
  }

  catch (SQLException e)
  {
    cout << "SQLException: " << e.what() << endl;
    return(EXIT_FAILURE);
  }
}

static void usage()
{
  cout << "usage: show-table <database> <tablename> "
       << "[<username> [<passwd>]]" << endl;
}
