#include "statement.h"

namespace GQL
{

namespace MySQL
{

MyStatement::~MyStatement()
{
  close();
}

void MyStatement::close()
{
  result_set_->unreference();
}


bool MyStatement::execute(const string& sql)
{
  clear_warnings();
  
  result_set_ = dynamic_cast<MyResultSet *>(
          dynamic_cast<MyConnection *>(get_connection())->exec_sql(sql));

  return(true);
}

ResultSet *MyStatement::execute_query(const string& sql)
{
  execute(sql);
  
  return(result_set_);
}

int MyStatement::execute_update(const string& sql)
{
  execute(sql);
  
  return(0);
}

}
}
