/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_GDBI_DRIVER_H)
#define __INC_GDBI_DRIVER_H

#include <vector>
#include <string>

#include <sigc++/signal_system.h>
#include <gql++/driver-manager.h>

#include "uc++/error-handler.h"

namespace gdbi
{

class Session;

class Driver : public uC::ErrorHandler
{
    friend class Session;
  public:
    std::string id() const { return(driver_->get_id()); }
    std::string name() const { return(driver_->get_name()); }
    int major_version() const { return(driver_->get_major_version()); }
    int minor_version() const { return(driver_->get_minor_version()); }
  protected:
    Driver(GQL::Driver *driver) {
      driver_ = driver;
    }
  private:
    GQL::Driver *driver_;
};

}

#endif
