#ifndef _EVAL_DEBUG_H
#define _EVAL_DEBUG_H

#include <QWidget>
#include <QDialog>
#include <QModelIndex>
#include "osl/state/numEffectState.h"
#include "osl/stl/vector.h"
#include "osl/container/pieceValues.h"

class QAbstractItemModel;
class QTableWidget;
class EvalDebugDetail;
class EvalDebugModel;
class EvalDebugDetailAttackDefensePanel;

class EvalDebug : public QWidget
{
  Q_OBJECT
public:
  EvalDebug(
    const osl::state::NumEffectState &s,
    QWidget *parent = 0, const char *name = 0);
  void setStatus(const osl::state::SimpleState &state);
private slots:
  void itemClicked(const QModelIndex &index);
private:
  EvalDebugModel *model;
  EvalDebugDetail *detail;
};

class EvalDebugDetail : public QWidget
{
  Q_OBJECT
private:
  void showEndgameBonus(const osl::state::SimpleState &state,
			const osl::container::PieceValues &values);
public:
  EvalDebugDetail(QWidget *parent = 0, const char *name = 0);
  void clear();
  void showAttackDefenseBonus(const osl::state::SimpleState &state);
  void showAttackBonus(const osl::state::SimpleState &state);
  void showDefenseBonus(const osl::state::SimpleState &state);
  void showProgressBonus(const EvalDebugModel &model);
  void showProgressIndependentBonus(const EvalDebugModel &model);
  void showProgressDependentBonus(const EvalDebugModel &model);
  void showMinorPiecesBonus(const EvalDebugModel &model);
private slots:
  void showAttackDefense();
  void showAttack();
  void showDefense();
private:
  QTableWidget *table;
  EvalDebugDetailAttackDefensePanel *panel;
};

class EvalDebugDialog : public QDialog
{
  Q_OBJECT
public:
  EvalDebugDialog(const osl::state::SimpleState &s,
		  QWidget *parent = 0, const char *name = 0);
public slots:
  void setStatus(const osl::state::SimpleState &state,
		 const osl::stl::vector<osl::Move> &,
		 int, osl::Move);
private:
  EvalDebug *debug;
};

class OpenMidEndingEvalDebugModel;
class OpenMidEndingEvalDebug : public QWidget
{
  Q_OBJECT
public:
  OpenMidEndingEvalDebug(
    const osl::state::NumEffectState &s,
    QWidget *parent = 0, const char *name = 0);
  void setStatus(const osl::state::SimpleState &state);
private:
  OpenMidEndingEvalDebugModel *model;
};

class OpenMidEndingEvalDebugDialog : public QDialog
{
  Q_OBJECT
public:
  OpenMidEndingEvalDebugDialog(const osl::state::SimpleState &s,
		      QWidget *parent = 0, const char *name = 0);
public slots:
  void setStatus(const osl::state::SimpleState &state,
		 const osl::stl::vector<osl::Move> &,
		 int, osl::Move);
private:
  OpenMidEndingEvalDebug *debug;
};

#endif // _EVAL_DEBUG_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
