/* analyzer.h
 */
#ifndef GPSSHOGI_LEARN_ANALYZER_H
#define GPSSHOGI_LEARN_ANALYZER_H

#include "instanceData.h"
#include "pvVector.h"
#include "osl/state/historyState.h"
#include "osl/container/moveVector.h"
#include "osl/stat/average.h"

#include <boost/shared_ptr.hpp>
#include <cmath>

namespace gpsshogi
{
  using namespace osl;
  
  struct MoveData
  {
    typedef vector<std::pair<int,double> > vector_t;

    int value, piece_value;
    vector_t diffs;
    explicit MoveData() : value(0), piece_value(0)
    {
    }
    void clear()
    {
      diffs.clear();
    }
    void sort();
  };
  std::ostream& operator<<(std::ostream& os, const MoveData& md);
  class Eval;
  class Quiesce;
  struct SigmoidUtil
  {
    static const double eps = 0.00001;
    static double tx(double x, double pawn) 
    {
      return 1.0/(1.0+exp(-x*3.0/pawn));
    }
    /** differential of tx */
    static double tpx(double x, double pawn) 
    {
      const double v = tx(x, pawn);
      return 3.0/pawn*v*(1.0-v);
    }
  };
  /** helper for Analyzer */
  class PairAnalyzer : protected SigmoidUtil
  {
  protected:
    Eval *eval;
  public:
    const size_t dimension;
    PairAnalyzer(Eval *);
    virtual ~PairAnalyzer();
    virtual void analyzePair(int turn_coef, double coef, 
			     const MoveData& selected,
			     const MoveData& sibling)=0;
    virtual void merge(const PairAnalyzer&);
    virtual void update(int delta);
    virtual void reset();
  };

  /** framework of analyses of sibling relation */
  class Analyzer : protected SigmoidUtil
  {
  public:
    static void analyzeLeaf(const NumEffectState& state, 
			    const PVVector& pv, Eval&,
			    MoveData& data);
    static void makeLeaf(HistoryState& state, const PVVector& pv);

    static boost::shared_ptr<InstanceData> 
    makeInstance(double turn_coef, const MoveData& selected, const MoveData& sibling,
		 const vector<size_t>& frequency, int min_frequency);
    static boost::shared_ptr<InstanceData> 
    makeInstance(double turn_coef, const MoveData& selected, const MoveData& sibling);
    static void
    makeInstance(double turn_coef, const MoveData& selected, const MoveData& sibling,
		 const vector<size_t>& frequency, int min_frequency, InstanceData& out);
    static void
    makeInstance(double turn_coef, const MoveData& selected, const MoveData& sibling,
		 InstanceData& out);
    static void
    makeInstanceOne(double turn_coef, const MoveData& data, 
		    const vector<size_t>& frequency, int min_frequency, InstanceData& out);
  };
}

#endif /* GPSSHOGI_LEARN_ANALYZER_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
