#!/usr/bin/perl -w
# Ÿͤpdp ؤmapping
use strict;
use POSIX;

sub expansion_value ($$) {
    my ($result, $tree) = @_;
    my $value = 1.0/sqrt(sqrt($tree));
    return ($result == 0) ? $value : -$value;
}

sub index($) {
    my ($value) = @_;
    return floor(($value+1)*10);
}

my @table;
sub init_table() {
    my $big_nuber = 1000000;
    foreach my $index (0..20) {
	$table[$index] = { count => 0, 
			   proof => $big_nuber, disproof => $big_nuber,
			   p_sum => 0.0, d_sum => 0.0,
			 };
    }
}
sub fix_table() {
    foreach my $index (0..20) {
	if ($table[$index]->{count} == 0) {
	    $table[$index]->{count} = 1;
	    $table[$index]->{proof} = 1;
	    $table[$index]->{disproof} = 1;
	    $table[$index]->{p_sum} = 1.0;
	    $table[$index]->{d_sum} = 1.0;
	}
    }
}

sub register_table($$$) {
    my ($index, $proof, $disproof) = @_;
    $table[$index]->{count} += 1;
    $table[$index]->{proof} = $proof
	if ($proof < $table[$index]->{proof});
    $table[$index]->{disproof} = $disproof
	if ($disproof < $table[$index]->{disproof});
    $table[$index]->{p_sum} += $proof;
    $table[$index]->{d_sum} += $disproof;
}

sub show_table () {
    my $index = 0;
    foreach my $record (@table) {
	my $key = ($index/10.0 - 1.0);
	my $count = $record->{count};
	my $p_ave = floor($record->{p_sum} / $count);
	my $d_ave = floor($record->{d_sum} / $count);
	print "$key\t$count\t$record->{proof}\t$record->{disproof}\t\t$p_ave\t$d_ave\n";
	++$index;
    }
}

&init_table();
while (<>) {
    my ($record, $move, $result, $tree, $proof, $disproof) = split;
    # histogram
    my $value = &expansion_value($result, $tree);
    my $index = &index($value);
    &register_table($index, $proof, $disproof);
}
&fix_table();
&show_table();
