#include "analyze_check_result.h"
#include "osl/checkmate/dualCheckmateSearcher.h"
#include "osl/checkmate/dualCheckmateSearcher.tcc"
#include "osl/checkmate/checkmateSearcher.tcc"

#include "osl/checkmate/dominanceTable.h"
#include "osl/checkmate/checkmateRecorder.h"
#include "osl/checkmate/libertyEstimator.h"
#include "osl/checkmate/pieceCost.h"
#include "osl/checkmate/nullCost.h"
#include "osl/checkmate/nullEstimator.h"
#include "osl/record/csaRecord.h"
#include "osl/record/kisen.h"
#include "osl/hashEffectState.h"
#include "osl/perfmon.h"

#include <boost/scoped_ptr.hpp>
#include <sstream>
#include <string>
#include <fstream>
#include <cstdlib>
#include <unistd.h>

using namespace osl;
using namespace osl::checkmate;
using record::csa::ICsaRecordStream;

/**
 * @file
 * ʤ顤̤ФNΡɸǵ;Ƥ.
 *     1        2    3 4        5 6       7 8 
 * : ֹ  [] [¨]    [ͤ]
 * ;Υץѥƥ: proof disproof
 * (Ե)λ proof, disproof  1,N (N,1)
 * Ŭξϡ(-1,-1)
 * (Ǥʤβ䡤ʬ˲꤬äƤεͤ)
 */
void usage(const char *prog)
{
  using namespace std;
  cerr << "Usage: " << prog << " [-o out] [-l nodelimit] [-k kisen_file_name] "
       << "[-F skip-first-n-records] csa-filenames "
       << endl;
  exit(1);
}

size_t limit = 20;
std::ostream *output = 0;
void search(size_t id, const char *filename);
void search(size_t id, const osl::vector<osl::Move>& moves);

int main(int argc, char **argv)
{
  const char *program_name = argv[0];
  bool error_flag = false;

  bool verbose = true;
  const char *kisen_filename = 0;
  size_t num_records = 10;
  const char *output_filename = 0;
  size_t skip_head = 0;

  extern char *optarg;
  extern int optind;
  char c;
  while ((c = getopt(argc, argv, "F:N:k:l:o:vh")) != EOF)
  {
    switch(c)
    {
    case 'F':	skip_head = atoi(optarg);
      break;
    case 'N':	num_records = atoi(optarg);
      break;
    case 'k':	kisen_filename = optarg;
      break;
    case 'l':	limit = atoi(optarg);
      assert(limit);
      break;
    case 'o':	output_filename = optarg;
      assert(output_filename);
      break;
    default:	error_flag = true;
    }
  }
  argc -= optind;
  argv += optind;

  if (error_flag || ((! kisen_filename) && (argc < 1)))
    usage(program_name);

  boost::scoped_ptr<std::ostream> os;
  if (output_filename)
  {
    os.reset(new std::ofstream(output_filename));
    output = &*os;
  }
  else
  {
    output = &std::cout;
  }

  try
  {
    nice(20);
    if (kisen_filename)
    {
      KisenFile kisen_file(kisen_filename);
      if (num_records == 0)
	num_records = kisen_file.size();
      for (size_t i=skip_head; i<num_records+skip_head; i++)
      {
	if (i % 1000 == 0)
	  std::cerr << "\nprocessing " << i << "-" << i+1000 << " th record\n";
	const osl::vector<Move> moves=kisen_file.getMoves(i);
	search(i, moves);
      }
    }
    for (int i=skip_head; i<argc; ++i)
    {
      if (verbose)
	std::cerr << "\nsolving " << argv[i] << "\n";
      search(i, argv[i]);
    }
  }
  catch (std::exception& e)
  {
    std::cerr << e.what() << "\n";
    return 1;
  }
}

void evalState(std::ostream& os, size_t record_id, size_t move_id, 
	       const SimpleState& sstate, Move lastMove)
{
  HashEffectState state(sstate);
  // typedef DualCheckmateSearcher<HashEffectState,DominanceTable,PureLibertyEstimator,NullCost>
  typedef DualCheckmateSearcher<HashEffectState,DominanceTable,NullEstimator,NullCost>
    searcher_t;
  searcher_t searcher(20000000, false);

  typedef searcher_t::table_t table_t;
  const Player turn = state.getTurn();
  const PathEncoding path(state.getTurn());
  os << record_id << " " << move_id << " ";
  if (! state.hasEffectBy(alt(turn), state.getKingPosition(turn)))
  {
    output_invalid(os);
  }
  else
  {
    // ꤫鲦꤬äƤ
    const bool lose = searcher.isLosingStateSlow(limit, state, path, lastMove);
    const table_t& table = searcher.getTable(alt(turn));
    const CheckHashRecord *record = table.find(state.getHash());
    analyze_check_result(lose, record, path, table.getTwinTable(), limit, os);
  }

  // Ĥ
  Move checkmateMove;
  const bool win = searcher.isWinningStateSlow(limit, state, path, checkmateMove);
  const table_t& table = searcher.getTable(turn);
  const CheckHashRecord *record = table.find(state.getHash());

  analyze_check_result(win, record, path, table.getTwinTable(), limit, os);

  // ʬĤ?
  if (state.hasEffectBy(alt(turn), state.getKingPosition(turn)))
  {
    output_invalid(os);
  }
  else
  {
    state.changeTurn();
    const PathEncoding tsumero_path(state.getTurn());
  
    const bool tsumero 
      = searcher.isWinningStateSlow(limit, state, tsumero_path, checkmateMove);
    const table_t& tsumero_table = searcher.getTable(alt(turn));
    const CheckHashRecord *tsumero_record = tsumero_table.find(state.getHash());
    assert(tsumero_record);

    analyze_check_result(tsumero, tsumero_record, tsumero_path,
			 table.getTwinTable(), limit, os);

    state.changeTurn();
  }
  os << "\n" << std::flush;
}

void search(size_t id, const osl::vector<osl::Move>& moves)
{
  SimpleState state(HIRATE);
  size_t i=0;
  try
  {
    for (; i<moves.size(); i++)
    {
      ApplyMoveOfTurn::doMove(state, moves[i]);
      const Position opKingPosition 
	= state.getKingPosition(alt(state.getTurn()));
      // ʬμ֤β => ľμ꤬ˡ
      if (state.hasEffectBy(state.getTurn(),opKingPosition))
      {
	std::cerr << "e"; // state;
	break;
      }
      if (i < 50)
	continue;
      evalState(*output, id, i, state, moves[i-1]);
    }
  }
  catch (...)
  {
    std::cerr << id << " " << i << "\n" << state << "\n";
    throw;
  }
  *output << std::flush;
}

void search(size_t id, const char *filename)
{
  Record rec=CsaFile(filename).getRecord();
  osl::vector<osl::Move> moves=rec.getMoves();
  search(id, moves);
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
