/* $Id: polling.cc,v 1.6 2000/09/29 10:15:37 bergo Exp $ */

/*

    GPS - Graphical Process Statistics
    Copyright (C) 1999-2000 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/* if you wish to extend the way gPS gathers information, you'll
   probably want to read polling.h first. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include "transient.h"
#include "gps.h"
#include "polling.h"

/* ********************************************************
 * 
 *
 *                    ProcessListItem
 *	      
 *
 * ********************************************************* */

ProcessListItem::ProcessListItem() {
  pid[0]=0;
  name[0]=0;
  longname[0]=0;
  owner[0]=0;
  state[0]=0;
  cpu[0]=0;
  size[0]=0;
  rss[0]=0;
  nice[0]=0;
  priority[0]=0;
  start[0]=0;
}

void ProcessListItem::setField(ProcessField f,char *value) {
  char x[2];
  if (value==NULL) {
    x[0]=0;
    value=x;
  }
  switch(f) {
  case PID:
    strncpy(pid,value,16);
    pid[15]=0;
    break;
  case NAME:
    strncpy(name,value,GPS_MAXPROCESSNAME);
    name[GPS_MAXPROCESSNAME-1]=0;
    break;
  case LONGNAME:
    strncpy(longname,value,GPS_MAXPROCESSLONGNAME);
    longname[GPS_MAXPROCESSLONGNAME-1]=0;
    break;
  case OWNER:
    strncpy(owner,value,GPS_MAXOWNER);
    owner[GPS_MAXOWNER-1]=0;
    break;
  case MACHINE:
    strncpy(machine,value,GPS_MAXHOSTNAME);
    owner[GPS_MAXHOSTNAME-1]=0;
    break;
  case STATE:
    strncpy(state,value,16);
    state[15]=0;
    break;
  case CPU:
    strncpy(cpu,value,32);
    state[31]=0;
    break;
  case SIZE:
    strncpy(size,value,GPS_MAXMEMSTRING);
    size[GPS_MAXMEMSTRING-1]=0;
    break;
  case RSS:
    strncpy(rss,value,GPS_MAXMEMSTRING);
    rss[GPS_MAXMEMSTRING-1]=0;
    break;
  case NICE:
    strncpy(nice,value,16);
    nice[15]=0;
    break;
  case PRIORITY:
    strncpy(priority,value,16);
    priority[15]=0;
    break;  
  case START:
    strncpy(start,value,GPS_MAXTIMESTRING);
    start[GPS_MAXTIMESTRING-1]=0;
    break;
  }
}

/* ********************************************************
 * 
 *
 *                    ProcessItem
 *	      
 *
 * ********************************************************* */

ProcessItem::ProcessItem() : ProcessListItem() {
  ppid[15]=pgid[15]=sid[15]=tpgid[15]=0;
  tty[63]=0;
  sigpend[255]=sigblock[255]=sigign[255]=sigcau[255]=rssl[255]=0;
  minflt[31]=cminflt[31]=majflt[31]=cmajflt[31]=0;
  uj[31]=kj[31]=cuj[31]=ckj[31]=0;
}

void ProcessItem::setField(ProcessField f,char *value) {
  char x[2];
  if (value==NULL) {
    x[0]=0;
    value=x;
  }
  switch(f) {
  case PID:
  case NAME:
  case LONGNAME:
  case OWNER:
  case MACHINE:
  case STATE:
  case CPU:
  case SIZE:
  case RSS:
  case NICE:
  case PRIORITY:
  case START:
    ProcessListItem::setField(f,value);
    break;
  case PPID:
    strncpy(ppid,value,16);
    ppid[15]=0;
    break;
  case PGID:
    strncpy(pgid,value,16);
    pgid[15]=0;
    break;
  case SID:
    strncpy(sid,value,16);
    sid[15]=0;
    break;
  case TPGID:
    strncpy(tpgid,value,16);
    tpgid[15]=0;
    break;
  case TTY:
    strncpy(tty,value,64);
    tty[63]=0;
    break;
  case SIGPENDING:
    strncpy(sigpend,value,256);
    sigpend[255]=0;
    break;
  case SIGBLOCKED:
    strncpy(sigblock,value,256);
    sigblock[255]=0;
    break;
  case SIGIGNORED:
    strncpy(sigign,value,256);
    sigign[255]=0;
    break;
  case SIGCAUGHT:
    strncpy(sigcau,value,256);
    sigcau[255]=0;
    break;
  case USRJIFFIES:
    strncpy(uj,value,32);
    uj[31]=0;
    break;
  case KRNJIFFIES:
    strncpy(kj,value,32);
    kj[31]=0;
    break;
  case CUSRJIFFIES:
    strncpy(cuj,value,32);
    cuj[31]=0;
    break;
  case CKRNJIFFIES:
    strncpy(ckj,value,32);
    ckj[31]=0;
    break;
  case RSSLIM:
    strncpy(rssl,value,256);
    rssl[255]=0;
    break;
  case MINFLT:
    strncpy(minflt,value,32);
    minflt[31]=0;
    break;
  case MAJFLT:
    strncpy(majflt,value,32);
    majflt[31]=0;
    break;
  case CMINFLT:
    strncpy(cminflt,value,32);
    cminflt[31]=0;
    break;
  case CMAJFLT:
    strncpy(cmajflt,value,32);
    cmajflt[31]=0;
    break;
  case FLAGS:
    strncpy(flags,value,256);
    flags[255]=0;
    break;
  }
}
  
/* ********************************************************
 * 
 *
 *                    ProcessListPoller
 *	      
 *
 * ********************************************************* */

ProcessListPoller::ProcessListPoller() {
  process_list=NULL;
}

ProcessListPoller::~ProcessListPoller() {
  reset();
}

void ProcessListPoller::terminate() {

}

/* deallocates both list and contents */
void ProcessListPoller::reset() {
  GList *pt;
  if (process_list!=NULL) {
    for(pt=process_list;pt!=NULL;pt=g_list_next(pt))
      delete((ProcessListItem *)(pt->data));
    g_list_free(process_list);
    process_list=NULL;
  }
}

/**************

 UnixHostNames

 **************/

char * UnixHostnames::get_local_hostname() {
  gethostname(hostbuffer,GPS_MAXHOSTNAME-1);
  return(hostbuffer);
}

/* ********************************************************
 * 
 *
 *                 ProcessDetailsPoller
 *	      
 *
 * ********************************************************* */

ProcessDetailsPoller::ProcessDetailsPoller() {
  item=new ProcessItem();
}

ProcessDetailsPoller::~ProcessDetailsPoller() {
  reset();
}

void ProcessDetailsPoller::terminate() {

}

void ProcessDetailsPoller::reset() {
  if (item!=NULL) {
    delete item;
    item=NULL;
  }
}

/* ********************************************************
 * 
 *
 *                 SystemInfoProvider
 *	      
 *
 * ********************************************************* */

double SystemInfoProvider::mem_fraction() {
  double a;
  if (memory_total==0) /* bad connections will give all 0's */
    return(0.0);
  a=((double)memory_used)/((double)memory_total);
  if (a>1.0) a=1.0;
  return(a);
}

double SystemInfoProvider::swap_fraction() {
  double a;
  if (swap_total==0)
    return(0.0);
  a=((double)swap_used)/((double)swap_total);
  if (a>1.0) a=1.0;
  return(a);
}

void SystemInfoProvider::terminate() {

}

void SystemInfoProvider::SMP_faker() {
  CpuCount=1;
  cpus_load[0]=cpu_usage;
}
