/* $Id: globalvars.cc,v 1.9 2000/09/29 10:15:35 bergo Exp $ */

/*

    GPS - Graphical Process Statistics
    Copyright (C) 1999-2000 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <gtk/gtk.h>
#include "transient.h"
#include "gps.h"
#include "filter.h"
#include "polling.h"

/* Global Flags */
gint show_long_names=FALSE;
gint continuum=FALSE;
gint poll_local_only=FALSE;
gint jelly_bar=FALSE;
int gotgui=0;

gint net_halt_request=0;

gint netcritical=0;
gint nettimeout=DEFAULT_NET_TIMEOUT;

/* Pollers */
ProcessListPoller *list_poller;
ProcessDetailsPoller *details_poller;
SystemInfoProvider *info_provider;

int watch_count=0;
GList *listwatch=NULL;
GList *detailswatch=NULL;
GList *sysinfowatch=NULL;

/* Filtering */
gint have_filter=FALSE;
struct filter_info fi_work={0,0,"0"},fi_stru;

/* Network watch list */
GList *hostlist_fixed=NULL; /* netwatch host list */

/* selection and local host */
gint pid_sel=-1;
char host_sel[128],this_host[128];

/* gui stuff */
GtkWidget *hdlg=NULL;
GtkWidget *status_label[3];

GtkWindow *MainWindow;

gint to_history=-1;

gchar col_title[PROCESS_LIST_COLUMNS][10]=
      {"PID","Name","Owner","Host","State","%CPU","Size",
       "RSS","Nice","Pri","Start"};

/* signals */

char *posixnames[]={
  "SIGHUP", "SIGINT", "SIGQUIT","SIGILL", "SIGABRT","SIGFPE",
  "SIGKILL","SIGSEGV","SIGPIPE","SIGALRM","SIGTERM","SIGUSR1",
  "SIGUSR2","SIGCHLD","SIGCONT","SIGSTOP","SIGTSTP","SIGTTIN",
  "SIGTTOU"};

gint posixvalues[]={
  SIGHUP,SIGINT,SIGQUIT,SIGILL,SIGABRT,SIGFPE,
  SIGKILL,SIGSEGV,SIGPIPE,SIGALRM,SIGTERM,SIGUSR1,
  SIGUSR2,SIGCHLD,SIGCONT,SIGSTOP,SIGTSTP,SIGTTIN,
  SIGTTOU};

char *T_SNT=" \n\t";

// colors

int c_history_cpu_a;    // 0x00ff00
int c_history_cpu_b;    // 0x004000
int c_history_cpu_c;    // 0x006000
int c_history_grid;     // 0x008000

int c_history_swap_a;   // 0xff0000
int c_history_swap_b;   // 0x800000
int c_history_swap_c;   // 0x600000

int c_blue_a;   // 0x0000ff
int c_blue_b;   // 0x000080
int c_blue_c;   // 0x000060

int c_yellow_a;   // 0xffff00
int c_yellow_b;   // 0x808000
int c_yellow_c;   // 0x606000

int c_ubox_cpu_a;       // 0x7070e0
int c_ubox_cpu_b;       // 0x202080
int c_ubox_cpu_c;       // 0x8080f0
int c_ubox_cpu_d;       // 0x000060

int c_ubox_mem_a;       // 0xffaf4f
int c_ubox_mem_b;       // 0xff7700
int c_ubox_mem_c;       // 0xffe060
int c_ubox_mem_d;       // 0x806015

int c_ubox_uline;       // 0xb0b0b0
int c_ubox_link;        // 0xffffff
int c_ubox_border;      // 0xe0e0e0
int c_ubox_label;       // 0xffffff

char ** pix_mem;
char ** pix_swp;

int history_interval;
int list_interval;
