/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*

  timeout.c: Timer functions for gpredict  

  Copyright (C)  2001-2003  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/


#include <gnome.h>
#include <gconf/gconf-client.h>
#include "defaults.h"
#include "sun.h"
#include "moon.h"
#include "satlog.h"
#include "timeout.h"

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif


extern GnomeApp *app;
extern GConfClient *client;



gint sun_timer_id = -1;
gint sun_timer_callback (gpointer data)
{
	/* This is the timeout function for the Sun
	   which is called periodically.
	*/
	sun_update ();

	return TRUE;
}

void sun_timer_start ()
{
	/* This function can be called
	   to start the Sun timer.
	*/
	guint32 tval;

	if (sun_timer_id != -1)
		satlog_log (SAT_LOG_WARNING, _("sun_timer already running. Action ignored."));
	else {
		/* get user defined or default timeout value */
		tval = (gconf_client_get_int (client, SUN_TIMER_PATH, NULL) == 0) ?
			SUN_DEF_TIMER : gconf_client_get_int (client, SUN_TIMER_PATH, NULL);
		sun_timer_id = gtk_timeout_add (tval, 
						sun_timer_callback, 
						NULL);
	}
}

void sun_timer_stop ()
{
	/* This function can be called to stop
	   the Sun timer.
	*/
	if (sun_timer_id != -1) {
		/* we have a real timeout running */
		gtk_timeout_remove (sun_timer_id);
		sun_timer_id = -1;
	}
	else 
		satlog_log (SAT_LOG_WARNING, _("sun_timer not running. Action ignored."));
}



gint moon_timer_id = -1;
gint moon_timer_callback (gpointer data)
{
	/* This is the timeout function
	   for the Moon which is called
	   periodically.
	*/
	moon_update ();

	return TRUE;
}

void moon_timer_start ()
{
	/* This function can be called
	   to start the Moon timer.
	*/
	guint32 tval;

	if (moon_timer_id != -1)
		satlog_log (SAT_LOG_WARNING, _("moon_timer already running. Action ignored."));
	else {
		/* get user defined or default timeout value */
		tval = (gconf_client_get_int (client, MOON_TIMER_PATH, NULL) == 0) ?
			MOON_DEF_TIMER : gconf_client_get_int (client, MOON_TIMER_PATH, NULL);
		moon_timer_id = gtk_timeout_add (tval, 
						 moon_timer_callback, 
						 NULL);
	}
}

void moon_timer_stop ()
{
	/* This function can be called
	   to stop the Moon timer.
	*/
	if (moon_timer_id != -1) {
		/* we have a real timeout running */
		gtk_timeout_remove (moon_timer_id);
		moon_timer_id = -1;
	}
	else 
		satlog_log (SAT_LOG_WARNING, _("moon_timer not running. Action ignored."));
}

