/* GtkScintilla2: Wrapper widget for the Scintilla editing component.
 *
 * Copyright (c) 2010  Jose Rostagno <joserostagno@hotmail.com>
 * Copyright (c) 2002  Dennis J Houy <djhouy@paw.co.za>
 * Copyright (c) 2001  Michele Campeotto <micampe@micampe.it>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GTK_SCINTILLA_H__
#define __GTK_SCINTILLA_H__

#include <gtk/gtk.h>
#include "scintilla/include/Scintilla.h"
#include "scintilla/include/SciLexer.h"

G_BEGIN_DECLS /* adds extern "C" around the header */


#define GTK_TYPE_SCINTILLA            (gtk_scintilla_get_type ())
#define GTK_SCINTILLA(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_SCINTILLA, GtkScintilla))
#define GTK_SCINTILLA_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST  ((klass), GTK_TYPE_SCINTILLA, GtkScintillaClass))
#define GTK_IS_SCINTILLA(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_SCINTILLA))
#define GTK_IS_SCINTILLA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_SCINTILLA))

typedef struct _GtkScintilla      GtkScintilla;
typedef struct _GtkScintillaClass GtkScintillaClass;

struct _GtkScintilla {
    GtkFrame parent;
    
    GtkWidget *scintilla;
    
    GtkAccelGroup *accel_group;
};

struct _GtkScintillaClass {
    GtkFrameClass parent_class;

    void (* style_needed)        (GtkWidget *w, gint position, gpointer user_data);
    void (* char_added)          (GtkWidget *w, gint ch, gpointer user_data);
    void (* save_point_reached)  (GtkWidget *w, gpointer user_data);
    void (* save_point_left)     (GtkWidget *w, gpointer user_data);
    void (* modify_attempt_ro)   (GtkWidget *w, gpointer user_data);
    void (* key)                 (GtkWidget *w, gint ch, gint modifiers, gpointer user_data);
    void (* double_click)        (GtkWidget *w, gpointer user_data);
    void (* update_ui)           (GtkWidget *w, gpointer user_data);
    void (* modified)            (GtkWidget *w, gpointer user_data);
    void (* macro_record)        (GtkWidget *w, gint message, gint wparam, gint lparam, gpointer user_data);
    void (* margin_click)        (GtkWidget *w, gint modifiers, gint position, gint margin, gpointer user_data);
    void (* need_shown)          (GtkWidget *w, gint position, gint lenght, gpointer user_data);
    void (* painted)             (GtkWidget *w, gpointer user_data);
    void (* user_list_selection) (GtkWidget *w, gint type, gchar *text, gpointer user_data);
    void (* uri_dropped)         (GtkWidget *w, gchar *text, gpointer user_data);
    void (* dwell_start)         (GtkWidget *w, gint position, gpointer user_data);
    void (* dwell_end)           (GtkWidget *w, gint position, gpointer user_data);
    void (* zoom)                (GtkWidget *w, gpointer user_data);
};


GType      gtk_scintilla_get_type       (void) G_GNUC_CONST;
GtkWidget *gtk_scintilla_new            (void);

glong      gtk_scintilla_find_text      (GtkScintilla *sci,
                                         gint          flags,
                                         gchar        *text,
                                         glong         chrg_min,
                                         glong         chrg_max,
                                         glong        *text_min,
                                         glong        *text_max);

gchar     *gtk_scintilla_get_text_range (GtkScintilla *sci,
                                         gint          start,
                                         gint          end,
                                         gint         *length) G_GNUC_WARN_UNUSED_RESULT G_GNUC_MALLOC;

gchar     * gtk_scintilla_get_full_text (GtkScintilla *sci) G_GNUC_WARN_UNUSED_RESULT G_GNUC_MALLOC;

gchar     * gtk_scintilla_get_current_selected_text(GtkScintilla *sci) G_GNUC_WARN_UNUSED_RESULT G_GNUC_MALLOC;
/* --- Start of autogenerated code --- */

void gtk_scintilla_add_text(GtkScintilla *sci, gint length, const gchar * text);
void gtk_scintilla_insert_text(GtkScintilla *sci, glong pos, const gchar * text);
void gtk_scintilla_clear_all(GtkScintilla *sci);
void gtk_scintilla_clear_document_style(GtkScintilla *sci);
gint gtk_scintilla_get_length(GtkScintilla *sci);
gint gtk_scintilla_get_char_at(GtkScintilla *sci, glong pos);
glong gtk_scintilla_get_current_pos(GtkScintilla *sci);
glong gtk_scintilla_get_anchor(GtkScintilla *sci);
gint gtk_scintilla_get_style_at(GtkScintilla *sci, glong pos);
void gtk_scintilla_redo(GtkScintilla *sci);
void gtk_scintilla_set_undo_collection(GtkScintilla *sci, gboolean collect_undo);
void gtk_scintilla_select_all(GtkScintilla *sci);
void gtk_scintilla_set_save_point(GtkScintilla *sci);
gboolean gtk_scintilla_can_redo(GtkScintilla *sci);
gint gtk_scintilla_marker_line_from_handle(GtkScintilla *sci, gint handle);
void gtk_scintilla_marker_delete_handle(GtkScintilla *sci, gint handle);
gboolean gtk_scintilla_get_undo_collection(GtkScintilla *sci);
gint gtk_scintilla_get_view_ws(GtkScintilla *sci);
void gtk_scintilla_set_view_ws(GtkScintilla *sci, gint view_ws);
glong gtk_scintilla_position_from_point(GtkScintilla *sci, gint x, gint y);
glong gtk_scintilla_position_from_point_close(GtkScintilla *sci, gint x, gint y);
void gtk_scintilla_goto_line(GtkScintilla *sci, gint line);
void gtk_scintilla_goto_pos(GtkScintilla *sci, glong pos);
void gtk_scintilla_set_anchor(GtkScintilla *sci, glong pos_anchor);
gint gtk_scintilla_get_cur_line(GtkScintilla *sci, gint length, gchar * text);
glong gtk_scintilla_get_end_styled(GtkScintilla *sci);
void gtk_scintilla_convert_eols(GtkScintilla *sci, gint eol_mode);
gint gtk_scintilla_get_eol_mode(GtkScintilla *sci);
void gtk_scintilla_set_eol_mode(GtkScintilla *sci, gint eol_mode);
void gtk_scintilla_start_styling(GtkScintilla *sci, glong pos, gint mask);
void gtk_scintilla_set_styling(GtkScintilla *sci, gint length, gint style);
gboolean gtk_scintilla_get_buffered_draw(GtkScintilla *sci);
void gtk_scintilla_set_buffered_draw(GtkScintilla *sci, gboolean buffered);
void gtk_scintilla_set_tab_width(GtkScintilla *sci, gint tab_width);
gint gtk_scintilla_get_tab_width(GtkScintilla *sci);
void gtk_scintilla_set_code_page(GtkScintilla *sci, gint code_page);
void gtk_scintilla_set_use_palette(GtkScintilla *sci, gboolean use_palette);
void gtk_scintilla_marker_define(GtkScintilla *sci, gint marker_number, gint marker_symbol);
void gtk_scintilla_marker_set_fore(GtkScintilla *sci, gint marker_number, glong fore);
void gtk_scintilla_marker_set_back(GtkScintilla *sci, gint marker_number, glong back);
gint gtk_scintilla_marker_add(GtkScintilla *sci, gint line, gint marker_number);
void gtk_scintilla_marker_delete(GtkScintilla *sci, gint line, gint marker_number);
void gtk_scintilla_marker_delete_all(GtkScintilla *sci, gint marker_number);
gint gtk_scintilla_marker_get(GtkScintilla *sci, gint line);
gint gtk_scintilla_marker_next(GtkScintilla *sci, gint line_start, gint marker_mask);
gint gtk_scintilla_marker_previous(GtkScintilla *sci, gint line_start, gint marker_mask);
void gtk_scintilla_marker_define_pixmap(GtkScintilla *sci, gint marker_number, const gchar * pixmap);
void gtk_scintilla_marker_add_set(GtkScintilla *sci, gint line, gint set);
void gtk_scintilla_marker_set_alpha(GtkScintilla *sci, gint marker_number, gint alpha);
void gtk_scintilla_set_margin_type_n(GtkScintilla *sci, gint margin, gint margin_type);
gint gtk_scintilla_get_margin_type_n(GtkScintilla *sci, gint margin);
void gtk_scintilla_set_margin_width_n(GtkScintilla *sci, gint margin, gint pixel_width);
gint gtk_scintilla_get_margin_width_n(GtkScintilla *sci, gint margin);
void gtk_scintilla_set_margin_mask_n(GtkScintilla *sci, gint margin, gint mask);
gint gtk_scintilla_get_margin_mask_n(GtkScintilla *sci, gint margin);
void gtk_scintilla_set_margin_sensitive_n(GtkScintilla *sci, gint margin, gboolean sensitive);
gboolean gtk_scintilla_get_margin_sensitive_n(GtkScintilla *sci, gint margin);
void gtk_scintilla_style_clear_all(GtkScintilla *sci);
void gtk_scintilla_style_set_fore(GtkScintilla *sci, gint style, glong fore);
void gtk_scintilla_style_set_back(GtkScintilla *sci, gint style, glong back);
void gtk_scintilla_style_set_bold(GtkScintilla *sci, gint style, gboolean bold);
void gtk_scintilla_style_set_italic(GtkScintilla *sci, gint style, gboolean italic);
void gtk_scintilla_style_set_size(GtkScintilla *sci, gint style, gint size_points);
void gtk_scintilla_style_set_font(GtkScintilla *sci, gint style, const gchar * font_name);
void gtk_scintilla_style_set_eol_filled(GtkScintilla *sci, gint style, gboolean filled);
void gtk_scintilla_style_reset_default(GtkScintilla *sci);
void gtk_scintilla_style_set_underline(GtkScintilla *sci, gint style, gboolean underline);
glong gtk_scintilla_style_get_fore(GtkScintilla *sci, gint style);
glong gtk_scintilla_style_get_back(GtkScintilla *sci, gint style);
gboolean gtk_scintilla_style_get_bold(GtkScintilla *sci, gint style);
gboolean gtk_scintilla_style_get_italic(GtkScintilla *sci, gint style);
gint gtk_scintilla_style_get_size(GtkScintilla *sci, gint style);
gint gtk_scintilla_style_get_font(GtkScintilla *sci, gint style, gchar * font_name);
gboolean gtk_scintilla_style_get_eol_filled(GtkScintilla *sci, gint style);
gboolean gtk_scintilla_style_get_underline(GtkScintilla *sci, gint style);
gint gtk_scintilla_style_get_case(GtkScintilla *sci, gint style);
gint gtk_scintilla_style_get_character_set(GtkScintilla *sci, gint style);
gboolean gtk_scintilla_style_get_visible(GtkScintilla *sci, gint style);
gboolean gtk_scintilla_style_get_changeable(GtkScintilla *sci, gint style);
gboolean gtk_scintilla_style_get_hot_spot(GtkScintilla *sci, gint style);
void gtk_scintilla_style_set_case(GtkScintilla *sci, gint style, gint case_force);
void gtk_scintilla_style_set_character_set(GtkScintilla *sci, gint style, gint character_set);
void gtk_scintilla_style_set_hot_spot(GtkScintilla *sci, gint style, gboolean hotspot);
void gtk_scintilla_set_sel_fore(GtkScintilla *sci, gboolean use_setting, glong fore);
void gtk_scintilla_set_sel_back(GtkScintilla *sci, gboolean use_setting, glong back);
gint gtk_scintilla_get_sel_alpha(GtkScintilla *sci);
void gtk_scintilla_set_sel_alpha(GtkScintilla *sci, gint alpha);
gboolean gtk_scintilla_get_sel_eol_filled(GtkScintilla *sci);
void gtk_scintilla_set_sel_eol_filled(GtkScintilla *sci, gboolean filled);
void gtk_scintilla_set_caret_fore(GtkScintilla *sci, glong fore);
void gtk_scintilla_clear_all_cmd_keys(GtkScintilla *sci);
void gtk_scintilla_set_styling_ex(GtkScintilla *sci, gint length, const gchar * styles);
void gtk_scintilla_style_set_visible(GtkScintilla *sci, gint style, gboolean visible);
gint gtk_scintilla_get_caret_period(GtkScintilla *sci);
void gtk_scintilla_set_caret_period(GtkScintilla *sci, gint period_milliseconds);
void gtk_scintilla_set_word_chars(GtkScintilla *sci, const gchar * characters);
void gtk_scintilla_begin_undo_action(GtkScintilla *sci);
void gtk_scintilla_end_undo_action(GtkScintilla *sci);
void gtk_scintilla_indic_set_style(GtkScintilla *sci, gint indic, gint style);
gint gtk_scintilla_indic_get_style(GtkScintilla *sci, gint indic);
void gtk_scintilla_indic_set_fore(GtkScintilla *sci, gint indic, glong fore);
glong gtk_scintilla_indic_get_fore(GtkScintilla *sci, gint indic);
void gtk_scintilla_indic_set_under(GtkScintilla *sci, gint indic, gboolean under);
gboolean gtk_scintilla_indic_get_under(GtkScintilla *sci, gint indic);
void gtk_scintilla_set_whitespace_fore(GtkScintilla *sci, gboolean use_setting, glong fore);
void gtk_scintilla_set_whitespace_back(GtkScintilla *sci, gboolean use_setting, glong back);
void gtk_scintilla_set_whitespace_size(GtkScintilla *sci, gint size);
gint gtk_scintilla_get_whitespace_size(GtkScintilla *sci);
void gtk_scintilla_set_style_bits(GtkScintilla *sci, gint bits);
gint gtk_scintilla_get_style_bits(GtkScintilla *sci);
void gtk_scintilla_set_line_state(GtkScintilla *sci, gint line, gint state);
gint gtk_scintilla_get_line_state(GtkScintilla *sci, gint line);
gint gtk_scintilla_get_max_line_state(GtkScintilla *sci);
gboolean gtk_scintilla_get_caret_line_visible(GtkScintilla *sci);
void gtk_scintilla_set_caret_line_visible(GtkScintilla *sci, gboolean show);
glong gtk_scintilla_get_caret_line_back(GtkScintilla *sci);
void gtk_scintilla_set_caret_line_back(GtkScintilla *sci, glong back);
void gtk_scintilla_style_set_changeable(GtkScintilla *sci, gint style, gboolean changeable);
void gtk_scintilla_autoc_show(GtkScintilla *sci, gint len_entered, const gchar * item_list);
void gtk_scintilla_autoc_cancel(GtkScintilla *sci);
gboolean gtk_scintilla_autoc_active(GtkScintilla *sci);
glong gtk_scintilla_autoc_pos_start(GtkScintilla *sci);
void gtk_scintilla_autoc_complete(GtkScintilla *sci);
void gtk_scintilla_autoc_stops(GtkScintilla *sci, const gchar * character_set);
void gtk_scintilla_autoc_set_separator(GtkScintilla *sci, gint separator_character);
gint gtk_scintilla_autoc_get_separator(GtkScintilla *sci);
void gtk_scintilla_autoc_select(GtkScintilla *sci, const gchar * text);
void gtk_scintilla_autoc_set_cancel_at_start(GtkScintilla *sci, gboolean cancel);
gboolean gtk_scintilla_autoc_get_cancel_at_start(GtkScintilla *sci);
void gtk_scintilla_autoc_set_fill_ups(GtkScintilla *sci, const gchar * character_set);
void gtk_scintilla_autoc_set_choose_single(GtkScintilla *sci, gboolean choose_single);
gboolean gtk_scintilla_autoc_get_choose_single(GtkScintilla *sci);
void gtk_scintilla_autoc_set_ignore_case(GtkScintilla *sci, gboolean ignore_case);
gboolean gtk_scintilla_autoc_get_ignore_case(GtkScintilla *sci);
void gtk_scintilla_user_list_show(GtkScintilla *sci, gint list_type, const gchar * item_list);
void gtk_scintilla_autoc_set_auto_hide(GtkScintilla *sci, gboolean auto_hide);
gboolean gtk_scintilla_autoc_get_auto_hide(GtkScintilla *sci);
void gtk_scintilla_autoc_set_drop_rest_of_word(GtkScintilla *sci, gboolean drop_rest_of_word);
gboolean gtk_scintilla_autoc_get_drop_rest_of_word(GtkScintilla *sci);
void gtk_scintilla_register_image(GtkScintilla *sci, gint type, const gchar * xpm_data);
void gtk_scintilla_clear_registered_images(GtkScintilla *sci);
gint gtk_scintilla_autoc_get_type_separator(GtkScintilla *sci);
void gtk_scintilla_autoc_set_type_separator(GtkScintilla *sci, gint separator_character);
void gtk_scintilla_autoc_set_max_width(GtkScintilla *sci, gint character_count);
gint gtk_scintilla_autoc_get_max_width(GtkScintilla *sci);
void gtk_scintilla_autoc_set_max_height(GtkScintilla *sci, gint row_count);
gint gtk_scintilla_autoc_get_max_height(GtkScintilla *sci);
void gtk_scintilla_set_indent(GtkScintilla *sci, gint indent_size);
gint gtk_scintilla_get_indent(GtkScintilla *sci);
void gtk_scintilla_set_use_tabs(GtkScintilla *sci, gboolean use_tabs);
gboolean gtk_scintilla_get_use_tabs(GtkScintilla *sci);
void gtk_scintilla_set_line_indentation(GtkScintilla *sci, gint line, gint indent_size);
gint gtk_scintilla_get_line_indentation(GtkScintilla *sci, gint line);
glong gtk_scintilla_get_line_indent_position(GtkScintilla *sci, gint line);
gint gtk_scintilla_get_column(GtkScintilla *sci, glong pos);
void gtk_scintilla_set_h_scroll_bar(GtkScintilla *sci, gboolean show);
gboolean gtk_scintilla_get_h_scroll_bar(GtkScintilla *sci);
void gtk_scintilla_set_indentation_guides(GtkScintilla *sci, gint indent_view);
gint gtk_scintilla_get_indentation_guides(GtkScintilla *sci);
void gtk_scintilla_set_highlight_guide(GtkScintilla *sci, gint column);
gint gtk_scintilla_get_highlight_guide(GtkScintilla *sci);
gint gtk_scintilla_get_line_end_position(GtkScintilla *sci, gint line);
gint gtk_scintilla_get_code_page(GtkScintilla *sci);
glong gtk_scintilla_get_caret_fore(GtkScintilla *sci);
gboolean gtk_scintilla_get_use_palette(GtkScintilla *sci);
gboolean gtk_scintilla_get_read_only(GtkScintilla *sci);
void gtk_scintilla_set_current_pos(GtkScintilla *sci, glong pos);
void gtk_scintilla_set_selection_start(GtkScintilla *sci, glong pos);
glong gtk_scintilla_get_selection_start(GtkScintilla *sci);
void gtk_scintilla_set_selection_end(GtkScintilla *sci, glong pos);
glong gtk_scintilla_get_selection_end(GtkScintilla *sci);
void gtk_scintilla_set_print_magnification(GtkScintilla *sci, gint magnification);
gint gtk_scintilla_get_print_magnification(GtkScintilla *sci);
void gtk_scintilla_set_print_colour_mode(GtkScintilla *sci, gint mode);
gint gtk_scintilla_get_print_colour_mode(GtkScintilla *sci);
gint gtk_scintilla_get_first_visible_line(GtkScintilla *sci);
gint gtk_scintilla_get_line(GtkScintilla *sci, gint line, gchar * text);
gint gtk_scintilla_get_line_count(GtkScintilla *sci);
void gtk_scintilla_set_margin_left(GtkScintilla *sci, gint pixel_width);
gint gtk_scintilla_get_margin_left(GtkScintilla *sci);
void gtk_scintilla_set_margin_right(GtkScintilla *sci, gint pixel_width);
gint gtk_scintilla_get_margin_right(GtkScintilla *sci);
gboolean gtk_scintilla_get_modify(GtkScintilla *sci);
void gtk_scintilla_set_sel(GtkScintilla *sci, glong start, glong end);
gint gtk_scintilla_get_sel_text(GtkScintilla *sci, gchar * text);
void gtk_scintilla_hide_selection(GtkScintilla *sci, gboolean normal);
gint gtk_scintilla_point_x_from_position(GtkScintilla *sci, glong pos);
gint gtk_scintilla_point_y_from_position(GtkScintilla *sci, glong pos);
gint gtk_scintilla_line_from_position(GtkScintilla *sci, glong pos);
glong gtk_scintilla_position_from_line(GtkScintilla *sci, gint line);
void gtk_scintilla_line_scroll(GtkScintilla *sci, gint columns, gint lines);
void gtk_scintilla_scroll_caret(GtkScintilla *sci);
void gtk_scintilla_replace_sel(GtkScintilla *sci, const gchar * text);
void gtk_scintilla_set_read_only(GtkScintilla *sci, gboolean read_only);
void gtk_scintilla_null(GtkScintilla *sci);
gboolean gtk_scintilla_can_paste(GtkScintilla *sci);
gboolean gtk_scintilla_can_undo(GtkScintilla *sci);
void gtk_scintilla_empty_undo_buffer(GtkScintilla *sci);
void gtk_scintilla_undo(GtkScintilla *sci);
void gtk_scintilla_cut(GtkScintilla *sci);
void gtk_scintilla_copy(GtkScintilla *sci);
void gtk_scintilla_paste(GtkScintilla *sci);
void gtk_scintilla_clear(GtkScintilla *sci);
void gtk_scintilla_set_text(GtkScintilla *sci, const gchar * text);
gint gtk_scintilla_get_text(GtkScintilla *sci, gint length, gchar * text);
gint gtk_scintilla_get_text_length(GtkScintilla *sci);
gint gtk_scintilla_get_direct_function(GtkScintilla *sci);
gint gtk_scintilla_get_direct_pointer(GtkScintilla *sci);
void gtk_scintilla_set_overtype(GtkScintilla *sci, gboolean overtype);
gboolean gtk_scintilla_get_overtype(GtkScintilla *sci);
void gtk_scintilla_set_caret_width(GtkScintilla *sci, gint pixel_width);
gint gtk_scintilla_get_caret_width(GtkScintilla *sci);
void gtk_scintilla_set_target_start(GtkScintilla *sci, glong pos);
glong gtk_scintilla_get_target_start(GtkScintilla *sci);
void gtk_scintilla_set_target_end(GtkScintilla *sci, glong pos);
glong gtk_scintilla_get_target_end(GtkScintilla *sci);
gint gtk_scintilla_replace_target(GtkScintilla *sci, gint length, const gchar * text);
gint gtk_scintilla_replace_target_re(GtkScintilla *sci, gint length, const gchar * text);
gint gtk_scintilla_search_in_target(GtkScintilla *sci, gint length, const gchar * text);
void gtk_scintilla_set_search_flags(GtkScintilla *sci, gint flags);
gint gtk_scintilla_get_search_flags(GtkScintilla *sci);
void gtk_scintilla_call_tip_show(GtkScintilla *sci, glong pos, const gchar * definition);
void gtk_scintilla_call_tip_cancel(GtkScintilla *sci);
gboolean gtk_scintilla_call_tip_active(GtkScintilla *sci);
glong gtk_scintilla_call_tip_pos_start(GtkScintilla *sci);
void gtk_scintilla_call_tip_set_hlt(GtkScintilla *sci, gint start, gint end);
void gtk_scintilla_call_tip_set_back(GtkScintilla *sci, glong back);
void gtk_scintilla_call_tip_set_fore(GtkScintilla *sci, glong fore);
void gtk_scintilla_call_tip_set_fore_hlt(GtkScintilla *sci, glong fore);
void gtk_scintilla_call_tip_use_style(GtkScintilla *sci, gint tab_size);
gint gtk_scintilla_visible_from_doc_line(GtkScintilla *sci, gint line);
gint gtk_scintilla_doc_line_from_visible(GtkScintilla *sci, gint line_display);
gint gtk_scintilla_wrap_count(GtkScintilla *sci, gint line);
void gtk_scintilla_set_fold_level(GtkScintilla *sci, gint line, gint level);
gint gtk_scintilla_get_fold_level(GtkScintilla *sci, gint line);
gint gtk_scintilla_get_last_child(GtkScintilla *sci, gint line, gint level);
gint gtk_scintilla_get_fold_parent(GtkScintilla *sci, gint line);
void gtk_scintilla_show_lines(GtkScintilla *sci, gint line_start, gint line_end);
void gtk_scintilla_hide_lines(GtkScintilla *sci, gint line_start, gint line_end);
gboolean gtk_scintilla_get_line_visible(GtkScintilla *sci, gint line);
void gtk_scintilla_set_fold_expanded(GtkScintilla *sci, gint line, gboolean expanded);
gboolean gtk_scintilla_get_fold_expanded(GtkScintilla *sci, gint line);
void gtk_scintilla_toggle_fold(GtkScintilla *sci, gint line);
void gtk_scintilla_ensure_visible(GtkScintilla *sci, gint line);
void gtk_scintilla_set_fold_flags(GtkScintilla *sci, gint flags);
void gtk_scintilla_ensure_visible_enforce_policy(GtkScintilla *sci, gint line);
void gtk_scintilla_set_tab_indents(GtkScintilla *sci, gboolean tab_indents);
gboolean gtk_scintilla_get_tab_indents(GtkScintilla *sci);
void gtk_scintilla_set_backspace_unindents(GtkScintilla *sci, gboolean bs_unindents);
gboolean gtk_scintilla_get_backspace_unindents(GtkScintilla *sci);
void gtk_scintilla_set_mouse_dwell_time(GtkScintilla *sci, gint period_milliseconds);
gint gtk_scintilla_get_mouse_dwell_time(GtkScintilla *sci);
gint gtk_scintilla_word_start_position(GtkScintilla *sci, glong pos, gboolean only_word_characters);
gint gtk_scintilla_word_end_position(GtkScintilla *sci, glong pos, gboolean only_word_characters);
void gtk_scintilla_set_wrap_mode(GtkScintilla *sci, gint mode);
gint gtk_scintilla_get_wrap_mode(GtkScintilla *sci);
void gtk_scintilla_set_wrap_visual_flags(GtkScintilla *sci, gint wrap_visual_flags);
gint gtk_scintilla_get_wrap_visual_flags(GtkScintilla *sci);
void gtk_scintilla_set_wrap_visual_flags_location(GtkScintilla *sci, gint wrap_visual_flags_location);
gint gtk_scintilla_get_wrap_visual_flags_location(GtkScintilla *sci);
void gtk_scintilla_set_wrap_start_indent(GtkScintilla *sci, gint indent);
gint gtk_scintilla_get_wrap_start_indent(GtkScintilla *sci);
void gtk_scintilla_set_wrap_indent_mode(GtkScintilla *sci, gint mode);
gint gtk_scintilla_get_wrap_indent_mode(GtkScintilla *sci);
void gtk_scintilla_set_layout_cache(GtkScintilla *sci, gint mode);
gint gtk_scintilla_get_layout_cache(GtkScintilla *sci);
void gtk_scintilla_set_scroll_width(GtkScintilla *sci, gint pixel_width);
gint gtk_scintilla_get_scroll_width(GtkScintilla *sci);
void gtk_scintilla_set_scroll_width_tracking(GtkScintilla *sci, gboolean tracking);
gboolean gtk_scintilla_get_scroll_width_tracking(GtkScintilla *sci);
gint gtk_scintilla_text_width(GtkScintilla *sci, gint style, const gchar * text);
void gtk_scintilla_set_end_at_last_line(GtkScintilla *sci, gboolean end_at_last_line);
gboolean gtk_scintilla_get_end_at_last_line(GtkScintilla *sci);
gint gtk_scintilla_text_height(GtkScintilla *sci, gint line);
void gtk_scintilla_set_v_scroll_bar(GtkScintilla *sci, gboolean show);
gboolean gtk_scintilla_get_v_scroll_bar(GtkScintilla *sci);
void gtk_scintilla_append_text(GtkScintilla *sci, gint length, const gchar * text);
gboolean gtk_scintilla_get_two_phase_draw(GtkScintilla *sci);
void gtk_scintilla_set_two_phase_draw(GtkScintilla *sci, gboolean two_phase);
void gtk_scintilla_set_font_quality(GtkScintilla *sci, gint font_quality);
gint gtk_scintilla_get_font_quality(GtkScintilla *sci);
void gtk_scintilla_set_first_visible_line(GtkScintilla *sci, gint line_display);
void gtk_scintilla_set_multi_paste(GtkScintilla *sci, gint multi_paste);
gint gtk_scintilla_get_multi_paste(GtkScintilla *sci);
gint gtk_scintilla_get_tag(GtkScintilla *sci, gint tag_number, gchar * tag_value);
void gtk_scintilla_target_from_selection(GtkScintilla *sci);
void gtk_scintilla_lines_join(GtkScintilla *sci);
void gtk_scintilla_lines_split(GtkScintilla *sci, gint pixel_width);
void gtk_scintilla_set_fold_margin_colour(GtkScintilla *sci, gboolean use_setting, glong back);
void gtk_scintilla_set_fold_margin_hi_colour(GtkScintilla *sci, gboolean use_setting, glong fore);
void gtk_scintilla_line_down(GtkScintilla *sci);
void gtk_scintilla_line_down_extend(GtkScintilla *sci);
void gtk_scintilla_line_up(GtkScintilla *sci);
void gtk_scintilla_line_up_extend(GtkScintilla *sci);
void gtk_scintilla_char_left(GtkScintilla *sci);
void gtk_scintilla_char_left_extend(GtkScintilla *sci);
void gtk_scintilla_char_right(GtkScintilla *sci);
void gtk_scintilla_char_right_extend(GtkScintilla *sci);
void gtk_scintilla_word_left(GtkScintilla *sci);
void gtk_scintilla_word_left_extend(GtkScintilla *sci);
void gtk_scintilla_word_right(GtkScintilla *sci);
void gtk_scintilla_word_right_extend(GtkScintilla *sci);
void gtk_scintilla_home(GtkScintilla *sci);
void gtk_scintilla_home_extend(GtkScintilla *sci);
void gtk_scintilla_line_end(GtkScintilla *sci);
void gtk_scintilla_line_end_extend(GtkScintilla *sci);
void gtk_scintilla_document_start(GtkScintilla *sci);
void gtk_scintilla_document_start_extend(GtkScintilla *sci);
void gtk_scintilla_document_end(GtkScintilla *sci);
void gtk_scintilla_document_end_extend(GtkScintilla *sci);
void gtk_scintilla_page_up(GtkScintilla *sci);
void gtk_scintilla_page_up_extend(GtkScintilla *sci);
void gtk_scintilla_page_down(GtkScintilla *sci);
void gtk_scintilla_page_down_extend(GtkScintilla *sci);
void gtk_scintilla_edit_toggle_overtype(GtkScintilla *sci);
void gtk_scintilla_cancel(GtkScintilla *sci);
void gtk_scintilla_delete_back(GtkScintilla *sci);
void gtk_scintilla_tab(GtkScintilla *sci);
void gtk_scintilla_back_tab(GtkScintilla *sci);
void gtk_scintilla_new_line(GtkScintilla *sci);
void gtk_scintilla_form_feed(GtkScintilla *sci);
void gtk_scintilla_v_c_home(GtkScintilla *sci);
void gtk_scintilla_v_c_home_extend(GtkScintilla *sci);
void gtk_scintilla_zoom_in(GtkScintilla *sci);
void gtk_scintilla_zoom_out(GtkScintilla *sci);
void gtk_scintilla_del_word_left(GtkScintilla *sci);
void gtk_scintilla_del_word_right(GtkScintilla *sci);
void gtk_scintilla_del_word_right_end(GtkScintilla *sci);
void gtk_scintilla_line_cut(GtkScintilla *sci);
void gtk_scintilla_line_delete(GtkScintilla *sci);
void gtk_scintilla_line_transpose(GtkScintilla *sci);
void gtk_scintilla_line_duplicate(GtkScintilla *sci);
void gtk_scintilla_lower_case(GtkScintilla *sci);
void gtk_scintilla_upper_case(GtkScintilla *sci);
void gtk_scintilla_line_scroll_down(GtkScintilla *sci);
void gtk_scintilla_line_scroll_up(GtkScintilla *sci);
void gtk_scintilla_delete_back_not_line(GtkScintilla *sci);
void gtk_scintilla_home_display(GtkScintilla *sci);
void gtk_scintilla_home_display_extend(GtkScintilla *sci);
void gtk_scintilla_line_end_display(GtkScintilla *sci);
void gtk_scintilla_line_end_display_extend(GtkScintilla *sci);
void gtk_scintilla_home_wrap(GtkScintilla *sci);
void gtk_scintilla_home_wrap_extend(GtkScintilla *sci);
void gtk_scintilla_line_end_wrap(GtkScintilla *sci);
void gtk_scintilla_line_end_wrap_extend(GtkScintilla *sci);
void gtk_scintilla_v_c_home_wrap(GtkScintilla *sci);
void gtk_scintilla_v_c_home_wrap_extend(GtkScintilla *sci);
void gtk_scintilla_line_copy(GtkScintilla *sci);
void gtk_scintilla_move_caret_inside_view(GtkScintilla *sci);
gint gtk_scintilla_line_length(GtkScintilla *sci, gint line);
void gtk_scintilla_brace_highlight(GtkScintilla *sci, glong pos1, glong pos2);
void gtk_scintilla_brace_bad_light(GtkScintilla *sci, glong pos);
glong gtk_scintilla_brace_match(GtkScintilla *sci, glong pos);
gboolean gtk_scintilla_get_view_eol(GtkScintilla *sci);
void gtk_scintilla_set_view_eol(GtkScintilla *sci, gboolean visible);
gint gtk_scintilla_get_doc_pointer(GtkScintilla *sci);
void gtk_scintilla_set_doc_pointer(GtkScintilla *sci, gint pointer);
void gtk_scintilla_set_mod_event_mask(GtkScintilla *sci, gint mask);
gint gtk_scintilla_get_edge_column(GtkScintilla *sci);
void gtk_scintilla_set_edge_column(GtkScintilla *sci, gint column);
gint gtk_scintilla_get_edge_mode(GtkScintilla *sci);
void gtk_scintilla_set_edge_mode(GtkScintilla *sci, gint mode);
glong gtk_scintilla_get_edge_colour(GtkScintilla *sci);
void gtk_scintilla_set_edge_colour(GtkScintilla *sci, glong edge_colour);
void gtk_scintilla_search_anchor(GtkScintilla *sci);
gint gtk_scintilla_search_next(GtkScintilla *sci, gint flags, const gchar * text);
gint gtk_scintilla_search_prev(GtkScintilla *sci, gint flags, const gchar * text);
gint gtk_scintilla_lines_on_screen(GtkScintilla *sci);
void gtk_scintilla_use_pop_up(GtkScintilla *sci, gboolean allow_pop_up);
gboolean gtk_scintilla_selection_is_rectangle(GtkScintilla *sci);
void gtk_scintilla_set_zoom(GtkScintilla *sci, gint zoom);
gint gtk_scintilla_get_zoom(GtkScintilla *sci);
gint gtk_scintilla_create_document(GtkScintilla *sci);
void gtk_scintilla_add_ref_document(GtkScintilla *sci, gint doc);
void gtk_scintilla_release_document(GtkScintilla *sci, gint doc);
gint gtk_scintilla_get_mod_event_mask(GtkScintilla *sci);
void gtk_scintilla_set_focus(GtkScintilla *sci, gboolean focus);
gboolean gtk_scintilla_get_focus(GtkScintilla *sci);
void gtk_scintilla_set_status(GtkScintilla *sci, gint status_code);
gint gtk_scintilla_get_status(GtkScintilla *sci);
void gtk_scintilla_set_mouse_down_captures(GtkScintilla *sci, gboolean captures);
gboolean gtk_scintilla_get_mouse_down_captures(GtkScintilla *sci);
void gtk_scintilla_set_cursor(GtkScintilla *sci, gint cursor_type);
gint gtk_scintilla_get_cursor(GtkScintilla *sci);
void gtk_scintilla_set_control_char_symbol(GtkScintilla *sci, gint symbol);
gint gtk_scintilla_get_control_char_symbol(GtkScintilla *sci);
void gtk_scintilla_word_part_left(GtkScintilla *sci);
void gtk_scintilla_word_part_left_extend(GtkScintilla *sci);
void gtk_scintilla_word_part_right(GtkScintilla *sci);
void gtk_scintilla_word_part_right_extend(GtkScintilla *sci);
void gtk_scintilla_set_visible_policy(GtkScintilla *sci, gint visible_policy, gint visible_slop);
void gtk_scintilla_del_line_left(GtkScintilla *sci);
void gtk_scintilla_del_line_right(GtkScintilla *sci);
void gtk_scintilla_set_x_offset(GtkScintilla *sci, gint new_offset);
gint gtk_scintilla_get_x_offset(GtkScintilla *sci);
void gtk_scintilla_choose_caret_x(GtkScintilla *sci);
void gtk_scintilla_grab_focus(GtkScintilla *sci);
void gtk_scintilla_set_x_caret_policy(GtkScintilla *sci, gint caret_policy, gint caret_slop);
void gtk_scintilla_set_y_caret_policy(GtkScintilla *sci, gint caret_policy, gint caret_slop);
void gtk_scintilla_set_print_wrap_mode(GtkScintilla *sci, gint mode);
gint gtk_scintilla_get_print_wrap_mode(GtkScintilla *sci);
void gtk_scintilla_set_hotspot_active_fore(GtkScintilla *sci, gboolean use_setting, glong fore);
glong gtk_scintilla_get_hotspot_active_fore(GtkScintilla *sci);
void gtk_scintilla_set_hotspot_active_back(GtkScintilla *sci, gboolean use_setting, glong back);
glong gtk_scintilla_get_hotspot_active_back(GtkScintilla *sci);
void gtk_scintilla_set_hotspot_active_underline(GtkScintilla *sci, gboolean underline);
gboolean gtk_scintilla_get_hotspot_active_underline(GtkScintilla *sci);
void gtk_scintilla_set_hotspot_single_line(GtkScintilla *sci, gboolean single_line);
gboolean gtk_scintilla_get_hotspot_single_line(GtkScintilla *sci);
void gtk_scintilla_para_down(GtkScintilla *sci);
void gtk_scintilla_para_down_extend(GtkScintilla *sci);
void gtk_scintilla_para_up(GtkScintilla *sci);
void gtk_scintilla_para_up_extend(GtkScintilla *sci);
glong gtk_scintilla_position_before(GtkScintilla *sci, glong pos);
glong gtk_scintilla_position_after(GtkScintilla *sci, glong pos);
void gtk_scintilla_copy_range(GtkScintilla *sci, glong start, glong end);
void gtk_scintilla_copy_text(GtkScintilla *sci, gint length, const gchar * text);
void gtk_scintilla_set_selection_mode(GtkScintilla *sci, gint mode);
gint gtk_scintilla_get_selection_mode(GtkScintilla *sci);
glong gtk_scintilla_get_line_sel_start_position(GtkScintilla *sci, gint line);
glong gtk_scintilla_get_line_sel_end_position(GtkScintilla *sci, gint line);
void gtk_scintilla_line_down_rect_extend(GtkScintilla *sci);
void gtk_scintilla_line_up_rect_extend(GtkScintilla *sci);
void gtk_scintilla_char_left_rect_extend(GtkScintilla *sci);
void gtk_scintilla_char_right_rect_extend(GtkScintilla *sci);
void gtk_scintilla_home_rect_extend(GtkScintilla *sci);
void gtk_scintilla_v_c_home_rect_extend(GtkScintilla *sci);
void gtk_scintilla_line_end_rect_extend(GtkScintilla *sci);
void gtk_scintilla_page_up_rect_extend(GtkScintilla *sci);
void gtk_scintilla_page_down_rect_extend(GtkScintilla *sci);
void gtk_scintilla_stuttered_page_up(GtkScintilla *sci);
void gtk_scintilla_stuttered_page_up_extend(GtkScintilla *sci);
void gtk_scintilla_stuttered_page_down(GtkScintilla *sci);
void gtk_scintilla_stuttered_page_down_extend(GtkScintilla *sci);
void gtk_scintilla_word_left_end(GtkScintilla *sci);
void gtk_scintilla_word_left_end_extend(GtkScintilla *sci);
void gtk_scintilla_word_right_end(GtkScintilla *sci);
void gtk_scintilla_word_right_end_extend(GtkScintilla *sci);
void gtk_scintilla_set_whitespace_chars(GtkScintilla *sci, const gchar * characters);
void gtk_scintilla_set_chars_default(GtkScintilla *sci);
gint gtk_scintilla_autoc_get_current(GtkScintilla *sci);
gint gtk_scintilla_autoc_get_current_text(GtkScintilla *sci, gchar * s);
void gtk_scintilla_allocate(GtkScintilla *sci, gint bytes);
gint gtk_scintilla_target_as_u_t_f8(GtkScintilla *sci, gchar * s);
void gtk_scintilla_set_length_for_encode(GtkScintilla *sci, gint bytes);
gint gtk_scintilla_encoded_from_u_t_f8(GtkScintilla *sci, const gchar * utf8, gchar * encoded);
gint gtk_scintilla_find_column(GtkScintilla *sci, gint line, gint column);
gint gtk_scintilla_get_caret_sticky(GtkScintilla *sci);
void gtk_scintilla_set_caret_sticky(GtkScintilla *sci, gint use_caret_sticky_behaviour);
void gtk_scintilla_toggle_caret_sticky(GtkScintilla *sci);
void gtk_scintilla_set_paste_convert_endings(GtkScintilla *sci, gboolean convert);
gboolean gtk_scintilla_get_paste_convert_endings(GtkScintilla *sci);
void gtk_scintilla_selection_duplicate(GtkScintilla *sci);
void gtk_scintilla_set_caret_line_back_alpha(GtkScintilla *sci, gint alpha);
gint gtk_scintilla_get_caret_line_back_alpha(GtkScintilla *sci);
void gtk_scintilla_set_caret_style(GtkScintilla *sci, gint caret_style);
gint gtk_scintilla_get_caret_style(GtkScintilla *sci);
void gtk_scintilla_set_indicator_current(GtkScintilla *sci, gint indicator);
gint gtk_scintilla_get_indicator_current(GtkScintilla *sci);
void gtk_scintilla_set_indicator_value(GtkScintilla *sci, gint value);
gint gtk_scintilla_get_indicator_value(GtkScintilla *sci);
void gtk_scintilla_indicator_fill_range(GtkScintilla *sci, gint position, gint fill_length);
void gtk_scintilla_indicator_clear_range(GtkScintilla *sci, gint position, gint clear_length);
gint gtk_scintilla_indicator_all_on_for(GtkScintilla *sci, gint position);
gint gtk_scintilla_indicator_value_at(GtkScintilla *sci, gint indicator, gint position);
gint gtk_scintilla_indicator_start(GtkScintilla *sci, gint indicator, gint position);
gint gtk_scintilla_indicator_end(GtkScintilla *sci, gint indicator, gint position);
void gtk_scintilla_set_position_cache(GtkScintilla *sci, gint size);
gint gtk_scintilla_get_position_cache(GtkScintilla *sci);
void gtk_scintilla_copy_allow_line(GtkScintilla *sci);
gint gtk_scintilla_get_character_pointer(GtkScintilla *sci);
void gtk_scintilla_set_keys_unicode(GtkScintilla *sci, gboolean keys_unicode);
gboolean gtk_scintilla_get_keys_unicode(GtkScintilla *sci);
void gtk_scintilla_indic_set_alpha(GtkScintilla *sci, gint indicator, gint alpha);
gint gtk_scintilla_indic_get_alpha(GtkScintilla *sci, gint indicator);
void gtk_scintilla_set_extra_ascent(GtkScintilla *sci, gint extra_ascent);
gint gtk_scintilla_get_extra_ascent(GtkScintilla *sci);
void gtk_scintilla_set_extra_descent(GtkScintilla *sci, gint extra_descent);
gint gtk_scintilla_get_extra_descent(GtkScintilla *sci);
gint gtk_scintilla_marker_symbol_defined(GtkScintilla *sci, gint marker_number);
void gtk_scintilla_margin_set_text(GtkScintilla *sci, gint line, const gchar * text);
gint gtk_scintilla_margin_get_text(GtkScintilla *sci, gint line, gchar * text);
void gtk_scintilla_margin_set_style(GtkScintilla *sci, gint line, gint style);
gint gtk_scintilla_margin_get_style(GtkScintilla *sci, gint line);
void gtk_scintilla_margin_set_styles(GtkScintilla *sci, gint line, const gchar * styles);
gint gtk_scintilla_margin_get_styles(GtkScintilla *sci, gint line, gchar * styles);
void gtk_scintilla_margin_text_clear_all(GtkScintilla *sci);
void gtk_scintilla_margin_set_style_offset(GtkScintilla *sci, gint style);
gint gtk_scintilla_margin_get_style_offset(GtkScintilla *sci);
void gtk_scintilla_annotation_set_text(GtkScintilla *sci, gint line, const gchar * text);
gint gtk_scintilla_annotation_get_text(GtkScintilla *sci, gint line, gchar * text);
void gtk_scintilla_annotation_set_style(GtkScintilla *sci, gint line, gint style);
gint gtk_scintilla_annotation_get_style(GtkScintilla *sci, gint line);
void gtk_scintilla_annotation_set_styles(GtkScintilla *sci, gint line, const gchar * styles);
gint gtk_scintilla_annotation_get_styles(GtkScintilla *sci, gint line, gchar * styles);
gint gtk_scintilla_annotation_get_lines(GtkScintilla *sci, gint line);
void gtk_scintilla_annotation_clear_all(GtkScintilla *sci);
void gtk_scintilla_annotation_set_visible(GtkScintilla *sci, gint visible);
gint gtk_scintilla_annotation_get_visible(GtkScintilla *sci);
void gtk_scintilla_annotation_set_style_offset(GtkScintilla *sci, gint style);
gint gtk_scintilla_annotation_get_style_offset(GtkScintilla *sci);
void gtk_scintilla_add_undo_action(GtkScintilla *sci, gint token, gint flags);
glong gtk_scintilla_char_position_from_point(GtkScintilla *sci, gint x, gint y);
glong gtk_scintilla_char_position_from_point_close(GtkScintilla *sci, gint x, gint y);
void gtk_scintilla_set_multiple_selection(GtkScintilla *sci, gboolean multiple_selection);
gboolean gtk_scintilla_get_multiple_selection(GtkScintilla *sci);
void gtk_scintilla_set_additional_selection_typing(GtkScintilla *sci, gboolean additional_selection_typing);
gboolean gtk_scintilla_get_additional_selection_typing(GtkScintilla *sci);
void gtk_scintilla_set_additional_carets_blink(GtkScintilla *sci, gboolean additional_carets_blink);
gboolean gtk_scintilla_get_additional_carets_blink(GtkScintilla *sci);
void gtk_scintilla_set_additional_carets_visible(GtkScintilla *sci, gboolean additional_carets_blink);
gboolean gtk_scintilla_get_additional_carets_visible(GtkScintilla *sci);
gint gtk_scintilla_get_selections(GtkScintilla *sci);
void gtk_scintilla_clear_selections(GtkScintilla *sci);
gint gtk_scintilla_set_selection(GtkScintilla *sci, gint caret, gint anchor);
gint gtk_scintilla_add_selection(GtkScintilla *sci, gint caret, gint anchor);
void gtk_scintilla_set_main_selection(GtkScintilla *sci, gint selection);
gint gtk_scintilla_get_main_selection(GtkScintilla *sci);
void gtk_scintilla_set_selection_n_caret(GtkScintilla *sci, gint selection, glong pos);
glong gtk_scintilla_get_selection_n_caret(GtkScintilla *sci, gint selection);
void gtk_scintilla_set_selection_n_anchor(GtkScintilla *sci, gint selection, glong pos_anchor);
glong gtk_scintilla_get_selection_n_anchor(GtkScintilla *sci, gint selection);
void gtk_scintilla_set_selection_n_caret_virtual_space(GtkScintilla *sci, gint selection, gint space);
gint gtk_scintilla_get_selection_n_caret_virtual_space(GtkScintilla *sci, gint selection);
void gtk_scintilla_set_selection_n_anchor_virtual_space(GtkScintilla *sci, gint selection, gint space);
gint gtk_scintilla_get_selection_n_anchor_virtual_space(GtkScintilla *sci, gint selection);
void gtk_scintilla_set_selection_n_start(GtkScintilla *sci, gint selection, glong pos);
glong gtk_scintilla_get_selection_n_start(GtkScintilla *sci, gint selection);
glong gtk_scintilla_get_selection_n_end(GtkScintilla *sci, gint selection);
void gtk_scintilla_set_rectangular_selection_caret(GtkScintilla *sci, glong pos);
glong gtk_scintilla_get_rectangular_selection_caret(GtkScintilla *sci);
void gtk_scintilla_set_rectangular_selection_anchor(GtkScintilla *sci, glong pos_anchor);
glong gtk_scintilla_get_rectangular_selection_anchor(GtkScintilla *sci);
void gtk_scintilla_set_rectangular_selection_caret_virtual_space(GtkScintilla *sci, gint space);
gint gtk_scintilla_get_rectangular_selection_caret_virtual_space(GtkScintilla *sci);
void gtk_scintilla_set_rectangular_selection_anchor_virtual_space(GtkScintilla *sci, gint space);
gint gtk_scintilla_get_rectangular_selection_anchor_virtual_space(GtkScintilla *sci);
void gtk_scintilla_set_virtual_space_options(GtkScintilla *sci, gint virtual_space_options);
gint gtk_scintilla_get_virtual_space_options(GtkScintilla *sci);
void gtk_scintilla_set_rectangular_selection_modifier(GtkScintilla *sci, gint modifier);
gint gtk_scintilla_get_rectangular_selection_modifier(GtkScintilla *sci);
void gtk_scintilla_set_additional_sel_fore(GtkScintilla *sci, glong fore);
void gtk_scintilla_set_additional_sel_back(GtkScintilla *sci, glong back);
void gtk_scintilla_set_additional_sel_alpha(GtkScintilla *sci, gint alpha);
gint gtk_scintilla_get_additional_sel_alpha(GtkScintilla *sci);
void gtk_scintilla_set_additional_caret_fore(GtkScintilla *sci, glong fore);
glong gtk_scintilla_get_additional_caret_fore(GtkScintilla *sci);
void gtk_scintilla_rotate_selection(GtkScintilla *sci);
void gtk_scintilla_swap_main_anchor_caret(GtkScintilla *sci);
gint gtk_scintilla_change_lexer_state(GtkScintilla *sci, glong start, glong end);
gint gtk_scintilla_contracted_fold_next(GtkScintilla *sci, gint line_start);
void gtk_scintilla_vertical_centre_caret(GtkScintilla *sci);
void gtk_scintilla_start_record(GtkScintilla *sci);
void gtk_scintilla_stop_record(GtkScintilla *sci);
void gtk_scintilla_set_lexer(GtkScintilla *sci, gint lexer);
gint gtk_scintilla_get_lexer(GtkScintilla *sci);
void gtk_scintilla_colourise(GtkScintilla *sci, glong start, glong end);
void gtk_scintilla_set_property(GtkScintilla *sci, const gchar * key, const gchar * value);
void gtk_scintilla_set_keywords(GtkScintilla *sci, gint keyword_set, const gchar * key_words);
void gtk_scintilla_set_lexer_language(GtkScintilla *sci, const gchar * language);
void gtk_scintilla_load_lexer_library(GtkScintilla *sci, const gchar * path);
gint gtk_scintilla_get_property(GtkScintilla *sci, const gchar * key, gchar * buf);
gint gtk_scintilla_get_property_expanded(GtkScintilla *sci, const gchar * key, gchar * buf);
gint gtk_scintilla_get_property_int(GtkScintilla *sci, const gchar * key);
gint gtk_scintilla_get_style_bits_needed(GtkScintilla *sci);
gint gtk_scintilla_get_lexer_language(GtkScintilla *sci, gchar * text);
gint gtk_scintilla_private_lexer_call(GtkScintilla *sci, gint operation, gint pointer);
gint gtk_scintilla_property_names(GtkScintilla *sci, gchar * names);
gint gtk_scintilla_property_type(GtkScintilla *sci, const gchar * name);
gint gtk_scintilla_describe_property(GtkScintilla *sci, const gchar * name, gchar * description);
gint gtk_scintilla_describe_key_word_sets(GtkScintilla *sci, gchar * descriptions);

/* --- End of autogenerated code --- */

G_END_DECLS 

#endif /* __GTK_SCINTILLA_H__ */
