/***************************************************************************
                          gpc_image.h  -  Current image description
                             -------------------
    begin                : Wed May 17 2000
    copyright            : (C) 2000 by Thierry Florac
    email                : tflorac@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GPC_IMAGE_H
#define GPC_IMAGE_H

#include "pg_connection.h"
#include "pg_query.h"


typedef struct _GpcImageInfos GpcImageInfos;


GpcImageInfos *gpc_image_infos_new (void);
GpcImageInfos *gpc_image_get_infos (pgConnection *connection, gint ID);

gboolean gpc_image_exists (pgConnection *connection, gchar *dirname, gchar *filename);
gboolean gpc_image_exists_with_id (pgConnection *connection, gint ID);
gboolean gpc_image_file_exists (pgConnection *connection,  gint ID);

gboolean gpc_image_create_thumbnail (pgConnection *connection, GpcImageInfos *infos);

gboolean gpc_image_append (pgConnection *connection, gchar *filename);
gboolean gpc_image_insert (pgConnection *connection, gint film_id, gchar *dirname, gchar *filename);
gboolean gpc_image_update (pgConnection *connection, gint film_id, gchar *dirname, gchar *filename);
gboolean gpc_image_delete (pgConnection *connection, gint ID);

pgQuery* gpc_image_get_list_from_film (pgConnection *connection, gint film_ID);
pgQuery* gpc_image_get_list_where (pgConnection *connection, gchar *where);

gint gpc_image_get_id (GpcImageInfos *infos);
gint gpc_image_get_film_id (GpcImageInfos *infos);
gchar* gpc_image_get_filename (GpcImageInfos *infos);
gint   gpc_image_get_width (GpcImageInfos *infos);
gint   gpc_image_get_height (GpcImageInfos *infos);
gchar* gpc_image_get_mime_type (GpcImageInfos *infos);
gchar* gpc_image_get_number (GpcImageInfos *infos);
gchar* gpc_image_get_lens_maker (GpcImageInfos *infos);
gchar* gpc_image_get_lens_model (GpcImageInfos *infos);
gshort gpc_image_get_focal (GpcImageInfos *infos);
gfloat gpc_image_get_aperture (GpcImageInfos *infos);
gchar* gpc_image_get_speed (GpcImageInfos *infos);
gfloat gpc_image_get_latitude (GpcImageInfos *infos);
gfloat gpc_image_get_longitude (GpcImageInfos *infos);
gfloat gpc_image_get_elevation (GpcImageInfos *infos);
gfloat gpc_image_get_direction (GpcImageInfos *infos);
gfloat gpc_image_get_pitch (GpcImageInfos *infos);
gfloat gpc_image_get_roll (GpcImageInfos *infos);
gshort gpc_image_get_interest_note (GpcImageInfos *infos);
gshort gpc_image_get_quality_note (GpcImageInfos *infos);
gchar* gpc_image_get_description (GpcImageInfos *infos);
GList* gpc_image_get_keywords (GpcImageInfos *infos);

void gpc_image_set_filename (GpcImageInfos *infos, gchar *value);
void gpc_image_set_width (GpcImageInfos *infos, gint value);
void gpc_image_set_height (GpcImageInfos *infos, gint value);
void gpc_image_set_mime_type (GpcImageInfos *infos, gchar *value);
void gpc_image_set_number (GpcImageInfos *infos, gchar *value);
void gpc_image_set_lens_maker (GpcImageInfos *infos, gchar *value);
void gpc_image_set_lens_model (GpcImageInfos *infos, gchar *value);
void gpc_image_set_focal (GpcImageInfos *infos, gshort value);
void gpc_image_set_aperture (GpcImageInfos *infos, gfloat value);
void gpc_image_set_speed (GpcImageInfos *infos, gchar *value);
void gpc_image_set_latitude (GpcImageInfos *infos, gfloat value);
void gpc_image_set_longitude (GpcImageInfos *infos, gfloat value);
void gpc_image_set_elevation (GpcImageInfos *infos, gfloat value);
void gpc_image_set_direction (GpcImageInfos *infos, gfloat value);
void gpc_image_set_pitch (GpcImageInfos *infos, gfloat value);
void gpc_image_set_roll (GpcImageInfos *infos, gfloat value);
void gpc_image_set_interest_note (GpcImageInfos *infos, gshort value);
void gpc_image_set_quality_note (GpcImageInfos *infos, gshort value);
void gpc_image_set_description (GpcImageInfos *infos, gchar *value);
void gpc_image_set_keywords (GpcImageInfos *infos, GList *value, gboolean free_it);

gboolean gpc_image_infos_store (pgConnection *connection, GpcImageInfos *infos);
gboolean gpc_image_infos_store_keywords (pgConnection *connection, GpcImageInfos *infos);
gboolean gpc_image_store_references (pgConnection *connection, GpcImageInfos *infos);

void gpc_image_infos_free (GpcImageInfos *infos);

#endif
