/* 
   Copyright (C) 1999 Kyle R. Burton, All Rights Reserved
   mortis@voicenet.com
   http://www.bgw.org
   http://www.voicenet.com/~mortis

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/
#define CVS_VERSION   "$Header: /home/periodic/cvsroot/gperiodic/src/strings.cc,v 1.4 1999/06/30 20:46:02 periodic Exp $";
#define CVS_REVISION  "$Revision: 1.4 $";
#define CVS_DATE      "$Date: 1999/06/30 20:46:02 $";
#define CVS_AUTHOR    "$Author: periodic $";

#include <gtk/gtk.h>
#include <gperiodic.h>

char** strings_en = (char**)NULL;
char** strings_fr = (char**)NULL;
char** strings_pt = (char**)NULL;
char** strings_es = (char**)NULL;
char** strings_de = (char**)NULL;

void init_strings_en(void);
void init_strings_fr(void);
void init_strings_pt(void);
void init_strings_es(void);
void init_strings_de(void);

void init_strings(void)
{
  init_strings_en();
  init_strings_fr();
  init_strings_pt();
  init_strings_es();
  init_strings_de();
}

void init_strings_en(void)
{
  strings_en = new char*[STRINGS_NUM_STRINGS];

  for( unsigned int i = 0; i < STRINGS_NUM_STRINGS; ++i ) {
    strings_en[i] = (char*)NULL;
  }

  strings_en[STR_MENU_PATH_FILE]                  = "/_File";
  strings_en[STR_MENU_PATH_FILE_QUIT]             = "/_File/_Quit";
  strings_en[STR_MENU_PATH_HELP]                  = "/_Help";
  strings_en[STR_MENU_PATH_HELP_ABOUT]            = "/_Help/_About ...";
  strings_en[STR_NO_SYMBOL_FOR_INDEX]             = "No symbol for index";
  strings_en[STR_ERROR_BUTTON_WAS_NULL]           = "Error button was null?";
  strings_en[STR_SYMBOL]                          = "Symbol : ";
  strings_en[STR_NAME]                            = "Name : ";
  strings_en[STR_NUMBER]                          = "Number : ";
  strings_en[STR_WEIGHT]                          = "Weight : ";
  strings_en[STR_MELTING_POINT]                   = "Melting Point : ";
  strings_en[STR_BOILING_POINT]                   = "Boiling Point : ";
  strings_en[STR_PAULING_NEGATIVITY_NUMBER]       = "Pauling Negativity Number : ";
  strings_en[STR_OK]                              = "Ok";
  strings_en[STR_FRENCH_ADAPTATION]               = "French Adaptation";
  strings_en[STR_PORTUG_ADAPTATION]               = "Portuguese Adaptation";
  strings_en[STR_SPANISH_ADAPTATION]              = "Spanish adaptation";
  strings_en[STR_GERMAN_ADAPTATION]               = "German adaptation";
	strings_en[STR_TOOLTIPS_FORMAT_STRING]          = "%s  n:%s w:%s";
}

void init_strings_fr(void)
{
  strings_fr = new char*[STRINGS_NUM_STRINGS];

  for( unsigned int i = 0; i < STRINGS_NUM_STRINGS; ++i ) {
    strings_fr[i] = (char*)NULL;
  }

  strings_fr[STR_MENU_PATH_FILE]                  = "/_Fichier";
  strings_fr[STR_MENU_PATH_FILE_QUIT]             = "/_Fichier/_Quitter";
  strings_fr[STR_MENU_PATH_HELP]                  = "/_Aide";
  strings_fr[STR_MENU_PATH_HELP_ABOUT]            = "/_Aide/_Au sujet de ...";
  strings_fr[STR_NO_SYMBOL_FOR_INDEX]             = "Pas de symbole pour l'index";
  strings_fr[STR_ERROR_BUTTON_WAS_NULL]           = "Le bouton d'erreur tait null?";
  strings_fr[STR_SYMBOL]                          = "Symbole : ";
  strings_fr[STR_NAME]                            = "Nom : ";
  strings_fr[STR_NUMBER]                          = "Numro : ";
  strings_fr[STR_WEIGHT]                          = "Nombre de masse : ";
  strings_fr[STR_MELTING_POINT]                   = "Point de fusion : ";
  strings_fr[STR_BOILING_POINT]                   = "Point d'bullition : ";
  strings_fr[STR_PAULING_NEGATIVITY_NUMBER]       = "Pauling Negativity Number : ";
  strings_fr[STR_OK]                              = "Ok";
  strings_fr[STR_FRENCH_ADAPTATION]               = "adaptation franaise";
  strings_fr[STR_PORTUG_ADAPTATION]               = "adaptation portuguese";
  strings_fr[STR_SPANISH_ADAPTATION]              = "adaptation espaol";
  strings_fr[STR_GERMAN_ADAPTATION]               = "adaptation german";
	strings_fr[STR_TOOLTIPS_FORMAT_STRING]          = "%s  Z = %s; M = %s";
}

void init_strings_pt(void)
{
  strings_pt = new char*[STRINGS_NUM_STRINGS];

  for( unsigned int i = 0; i < STRINGS_NUM_STRINGS; ++i ) {
    strings_pt[i] = (char*)NULL;
  }
  strings_pt[STR_MENU_PATH_FILE]                  = "/_Arquivo";
  strings_pt[STR_MENU_PATH_FILE_QUIT]             = "/_Arquivo/_Sair";
  strings_pt[STR_MENU_PATH_HELP]                  = "/_Ajuda";
  strings_pt[STR_MENU_PATH_HELP_ABOUT]            = "/_Ajuda/_Sobre ...";
  strings_pt[STR_NO_SYMBOL_FOR_INDEX]             = "Sem smbolo para o ndice";
  strings_pt[STR_ERROR_BUTTON_WAS_NULL]           = "Boto de erro era null?";
  strings_pt[STR_SYMBOL]                          = "Smbolo : ";
  strings_pt[STR_NAME]                            = "Nome : ";
  strings_pt[STR_NUMBER]                          = "Nmero Atmico : ";
  strings_pt[STR_WEIGHT]                          = "Peso Atmico : ";
  strings_pt[STR_MELTING_POINT]                   = "Ponto de Fuso : ";
  strings_pt[STR_BOILING_POINT]                   = "Ponto de Evaporao : ";
  strings_pt[STR_PAULING_NEGATIVITY_NUMBER]       = "Pauling Negativity Number : ";
  strings_pt[STR_OK]                              = "Fechar";
  strings_pt[STR_FRENCH_ADAPTATION]               = "Adaptao em Francs";
  strings_pt[STR_PORTUG_ADAPTATION]               = "Adaptao em Portugus";
  strings_pt[STR_SPANISH_ADAPTATION]              = "Adaptao em Espanhol";
  strings_pt[STR_GERMAN_ADAPTATION]               = "Adaptao em Alemo";
 strings_pt[STR_TOOLTIPS_FORMAT_STRING]          = "%s  n:%s p:%s";
}


void init_strings_es(void)
{
  strings_es = new char*[STRINGS_NUM_STRINGS];

  for( unsigned int i = 0; i < STRINGS_NUM_STRINGS; ++i ) {
    strings_es[i] = (char*)NULL;
  }

  strings_es[STR_MENU_PATH_FILE]                  = "/_Archivo";
  strings_es[STR_MENU_PATH_FILE_QUIT]             = "/_Archivo/_Salir";
  strings_es[STR_MENU_PATH_HELP]                  = "/_Ayuda";
  strings_es[STR_MENU_PATH_HELP_ABOUT]            = "/_Ayuda/_Acerca de ...";
  strings_es[STR_NO_SYMBOL_FOR_INDEX]             = "Sin smbolo para el ndice";
  strings_es[STR_ERROR_BUTTON_WAS_NULL]           = "El botn de error era nulo?";
  strings_es[STR_SYMBOL]                          = "Smbolo : ";
  strings_es[STR_NAME]                            = "Nombre : ";
  strings_es[STR_NUMBER]                          = "Nmero : ";
  strings_es[STR_WEIGHT]                          = "Peso Atmico : ";
  strings_es[STR_MELTING_POINT]                   = "Punto de fusin : ";
  strings_es[STR_BOILING_POINT]                   = "Punto de ebullicin : ";
  strings_es[STR_PAULING_NEGATIVITY_NUMBER]       = "Nmero de Negatividad de Pauling : ";
  strings_es[STR_OK]                              = "Ok";
  strings_es[STR_FRENCH_ADAPTATION]               = "adaptacin al francs";
	strings_es[STR_PORTUG_ADAPTATION]               = "adaptacin al portugus";
  strings_es[STR_SPANISH_ADAPTATION]              = "adaptacin al espaol";
  strings_es[STR_GERMAN_ADAPTATION]               = "German adaptation";
	strings_es[STR_TOOLTIPS_FORMAT_STRING]          = "%s  n:%s w:%s";
}

void init_strings_de(void)
{
  strings_de = new char*[STRINGS_NUM_STRINGS];

  for( unsigned int i = 0; i < STRINGS_NUM_STRINGS; ++i ) {
    strings_de[i] = (char*)NULL;
  }

  strings_de[STR_MENU_PATH_FILE]                  = "/_File";
  strings_de[STR_MENU_PATH_FILE_QUIT]             = "/_File/_Quit";
  strings_de[STR_MENU_PATH_HELP]                  = "/_Help";
  strings_de[STR_MENU_PATH_HELP_ABOUT]            = "/_Help/_About ...";
  strings_de[STR_NO_SYMBOL_FOR_INDEX]             = "No symbol for index";
  strings_de[STR_ERROR_BUTTON_WAS_NULL]           = "Error button was null?";
  strings_de[STR_SYMBOL]                          = "Symbol : ";
  strings_de[STR_NAME]                            = "Name : ";
  strings_de[STR_NUMBER]                          = "Number : ";
  strings_de[STR_WEIGHT]                          = "Weight : ";
  strings_de[STR_MELTING_POINT]                   = "Melting Point : ";
  strings_de[STR_BOILING_POINT]                   = "Boiling Point : ";
  strings_de[STR_PAULING_NEGATIVITY_NUMBER]       = "Pauling Negativity Number : ";
  strings_de[STR_OK]                              = "Ok";
  strings_de[STR_FRENCH_ADAPTATION]               = "French Adaptation";
	strings_de[STR_PORTUG_ADAPTATION]               = "Portuguese Adaptation";
  strings_de[STR_SPANISH_ADAPTATION]              = "spanish adaptation";
  strings_de[STR_GERMAN_ADAPTATION]               = "German adaptation";
	strings_de[STR_TOOLTIPS_FORMAT_STRING]          = "%s  n:%s w:%s";
}

