/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>

#include "helper.h"
#include "application.h"
#include "change-master-password.h"

GType
gpass_change_master_password_get_type(void)
{
    static GType type = 0;
    
    if (type == 0) {
        static const GTypeInfo info = {
            sizeof(GPassChangeMasterPasswordClass),
            NULL,
            NULL,
            NULL,
            NULL,
            NULL,
            sizeof(GPassChangeMasterPassword),
            0,
            NULL,
        };
        
        type = g_type_register_static(GPASS_TYPE_VIEW,
                                      "GPassChangeMasterPasswordType", &info, 0);
    }
    return type;
}

/***********************************************************
 *
 * Signal handlers
 *
 ***********************************************************/
static gboolean
change_master_password(GPassChangeMasterPassword *self)
{
    GPassApplication *app;
    GtkWidget *current_entry, *new_entry, *verify_entry;
    const gchar *current, *new, *verify;

    current_entry = glade_xml_get_widget(GPASS_VIEW(self)->xml, "current");
    current = gtk_entry_get_text(GTK_ENTRY(current_entry));
    new_entry = glade_xml_get_widget(GPASS_VIEW(self)->xml, "new");
    new = gtk_entry_get_text(GTK_ENTRY(new_entry));
    verify_entry = glade_xml_get_widget(GPASS_VIEW(self)->xml, "verify");
    verify = gtk_entry_get_text(GTK_ENTRY(verify_entry));
    
    app = GPASS_APPLICATION(GPASS_VIEW(self)->model);
    if (strcmp(current, app->file->master_password) != 0) {
        gpass_view_show_error_message
            (GPASS_VIEW(self), _("Incorrect password!"), current_entry);
    }
    else if (strlen(new) < 1) {
        gpass_view_show_error_message
            (GPASS_VIEW(self), _("Empty passwords not allowed!"), new_entry);
    }
    else if (strcmp(new, verify) != 0) {
        gpass_view_show_error_message
            (GPASS_VIEW(self), _("The entered passwords do not match!"),
             new_entry);
    }
    else {
        gpass_application_change_master_password(app, new);
        return TRUE;
    }
    return FALSE;
}

void
gpass_change_master_password_on_response(GtkWidget *widget, gint response_id,
                                         gpointer user_data)
{
    GPassChangeMasterPassword *self;
    
    gpass_view_self_from_widget(widget, (gpointer **) &self);
    if (response_id == GTK_RESPONSE_OK) {
        if (change_master_password(self)) {
            GPASS_VIEW(self)->result = GPASS_VIEW_RESULT_SUCCEED;
            gpass_view_shutdown_main_loop(GPASS_VIEW(self));
        }
    }
    else {
        GPASS_VIEW(self)->result = GPASS_VIEW_RESULT_FAILED;
        gpass_view_shutdown_main_loop(GPASS_VIEW(self));
    }
}
