# tests/test_alarm.py
#
#
#    def __init__(self, botname, i, nick, ttime, txt):

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import stringinlist
from gozerbot.fleet import fleet
from gozerbot.bot import Bot
from gozerbot.users import users
from gozerbot.generic import enable_logging
from gozerbot.config import config
from gozerbot.plugins import plugins
from gozerplugs.plugs.alarm import alarms
import unittest, time

plugins.reload('gozerplugs.plugs', 'alarm')

class test_alarm(unittest.TestCase):

    b = Bot()

    def __init__(self, bla):
        unittest.TestCase.__init__(self, bla)  
        self.b.userhosts['test'] = 'test@test'
        
    def test_alarm(self):
        result = self.b.test('alarm')
        self.assert_(stringinlist('alarm', result))

    def test_alarm2(self):
        result = self.b.test('alarm +mekker test')
        self.assert_(stringinlist('use', result))

    def test_alarm3(self):
        result = self.b.test('alarm +2 test')
        self.assert_(stringinlist('set at', result))
        time.sleep(3)

    def test_alarm4(self):
        result = self.b.test('alarm +9999999999999999 test')
        self.assert_(stringinlist('overflow', result))

    def test_alarm5(self):
        result = self.b.test('alarm test')
        self.assert_(stringinlist("can't", result))

    def test_alarm6(self):
        result = self.b.test('alarm +5')
        self.assert_(stringinlist("need", result))

    def test_alarm7(self):
        result = self.b.test('alarm 23:59')
        self.assert_(stringinlist("need", result))

    def test_alarm8(self):
        result = self.b.test('alarm 0:01 test')
        self.assert_(stringinlist("already", result))

    def test_alarm9(self):
        result = self.b.test('alarm 23:59 test')
        nr = result[0].split()[1]
        self.b.test('alarm-del %s' % nr)
        self.assert_(stringinlist("set", result))

    def test_alarmlist(self):
        result = self.b.test('alarm-list')
        self.assert_(stringinlist("no alarms", result) or \
stringinlist(')', result))

    def test_alarmmylist(self):
        result = self.b.test('alarm-mylist')
        self.assert_(stringinlist("no alarms", result) or \
stringinlist(')', result))

    def test_alarmdel(self):
        result = self.b.test('alarm-del')
        self.assert_(stringinlist('<nr>', result))

    def test_alarmdel2(self):
        result = self.b.test('alarm-del mekker')
        self.assert_(stringinlist("argument", result))

    def test_alarmdel3(self):
        result = self.b.test('alarm-del 999999999999')
        self.assert_(stringinlist("failed", result))

    def test_alarmdel4(self):
        result = self.b.test('alarm 23:59 test')
        nr = result[0].split()[1]
        result = self.b.test('alarm-del %s' % nr)
        self.assert_(stringinlist("deleted", result))
