# gozerbot/botbase.py
#
#

""" bot base class """

from gozerbot.generic import rlog
from gozerbot.less import Less
from gozerbot.pdol import Pdol
from gozerbot.dol import Dol
from gozerbot.persiststate import PersistState
from gozerbot.runner import runner
from gozerbot.eventhandler import commandhandler
from gozerbot.channels import Channels
from gozerbot.datadir import datadir
from gozerbot.pdod import Pdod
from gozerbot.config import config
import time, threading, os, types

class BotBase(object):

    def __init__(self, name='main', owner=[]):
        self.name = name
        self.owner = owner
        self.type = "irc"
        self.nick = ""
        self.orignick = ""
        self.server = ""
        self.port = None
        self.ssl = False
        self.password = ""
        self.ipv6 = False
        self.blocking = True
        self.lastoutput = 0
        self.stopped = False
        self.connected = False
        self.connecting = False
        self.connectok = threading.Event()
        self.starttime = time.time()
        self.nrevents = 0
        self.gcevents = 0
        self.less = Less(5)
        self.userchannels = Dol()
        self.channels = Channels(datadir + os.sep + '%s.channels' % self.name)
        self.userhosts = PersistState(datadir + os.sep + '%s.userhosts' % \
self.name)
        self.state = Pdod(datadir + os.sep + '%s.state' % self.name)
        if not self.state.has_key('joinedchannels'):
            self.state['joinedchannels'] = []
        if not self.state.has_key('allowed'):
            self.state['allowed'] = []
        self.jabber = False
        self.google = False
        runner.start()
        commandhandler.start()

    def ownercheck(self, ievent, txt=None):
        if self.jabber:
            owner = self.owner or config['jabberowner']
        else:
            owner = self.owner or config['owneruserhost']
        if type(owner) == types.ListType:           
            if ievent.userhost in owner:            
                return 1
        elif owner == ievent.userhost:              
            return 1    
        else:
            if not txt:
                ievent.reply("only owner (see config file) is allowed \
to perform this command")
            else:
                ievent.reply("only owner (see config file) %s" % txt)
            return 0

    def save(self):
        self.channels.save()
        self.userhosts.save()
        self.state.save()

    def stop(self):
        self.stopped = True
        rlog(10, self.name, 'stopped')

    def exit(self):
        pass

    def connect(self):
        pass

    def joinchannels(self):
        pass

    def broadcast(self):
        pass

    def send(self, txt):
        pass

    def shutdown(self):
        pass
