/*
 * Googlizer: A demonstration of the value of selections
 *
 *	(c) Copyright 2000-2002 Alan Cox, All Rights Reserved
 *	(c) Copyright 2002 Robert McQueen, All Rights Reserved
 *	(c) Copyright 2002 Philip Downer. All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#define VERSION "Permian"

#include <gtk/gtk.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <gnome.h>

static void got_selection(GtkWidget *widget, GtkSelectionData *data, gpointer val, char *url)
{
	char *p, *tp;
	char *bptr;
	
	if(data->length<0)
		exit(1);
	if(data->type!=GDK_SELECTION_TYPE_STRING)
		exit(1);
	bptr=malloc(3*data->length+strlen(url)+1);
	if(bptr==NULL)
		exit(1);
	p=data->data;
	tp=bptr+sprintf(bptr, url);
	while(*p)
	{
		if(*p==' ')
		{
			*tp++='+';
			p++;
		}
		else if(*p<' '||*p>'z' || *p=='&' || *p=='%')
		{
			sprintf(tp, "%%%02x", *p);
			tp+=3;
			p++;
		}
		else *tp++=*p++;
	}
	*tp=0;

#if (GTK_MAJOR_VERSION > 1)	
	{
		GError *err = NULL;
	
		gnome_url_show(bptr, &err);
		if (err != NULL)
	        { 
		    fprintf(stderr, N_("An error has occured: %s \n"), err->message);
		    g_error_free (err);
	        }
	}
#else
	gnome_url_show(bptr);
#endif
	exit(0);
}

static int get_selection(GtkWidget *w)
{
	static GdkAtom atomos = GDK_NONE;
	if(atomos==GDK_NONE)
		atomos=gdk_atom_intern("STRING", FALSE);
	gtk_selection_convert(w, GDK_SELECTION_PRIMARY, atomos, GDK_CURRENT_TIME);
}

int main(int argc, char *argv[])
{
	GtkWidget *window;
	char *url = N_("http://www.google.com/search?q=");
	struct poptOption options[] = {
		{"url", 'u', POPT_ARG_STRING, &url, 0,
			N_("Search URL to append selected string to (defaults to local Google)"),
			N_("URL")},
		{NULL, '\0', 0, NULL, 0}
	};
	
	gnome_init_with_popt_table("Googlizer", VERSION, argc, argv, options, 0, NULL);
	
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_exit), NULL);
	gtk_signal_connect(GTK_OBJECT(window), "selection_received", GTK_SIGNAL_FUNC(got_selection), url);
	get_selection(window);
	gtk_main();
}
