// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/iam/admin/v1/iam.proto
// DO NOT EDIT!

/*
Package google_iam_admin_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/iam/admin/v1/iam.proto

It has these top-level messages:
	ServiceAccount
	CreateServiceAccountRequest
	ListServiceAccountsRequest
	ListServiceAccountsResponse
	GetServiceAccountRequest
	DeleteServiceAccountRequest
	ListServiceAccountKeysRequest
	ListServiceAccountKeysResponse
	GetServiceAccountKeyRequest
	ServiceAccountKey
	CreateServiceAccountKeyRequest
	DeleteServiceAccountKeyRequest
	SignBlobRequest
	SignBlobResponse
	Role
	QueryGrantableRolesRequest
	QueryGrantableRolesResponse
*/
package google_iam_admin_v1 // import "google.golang.org/genproto/googleapis/iam/admin/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_iam_v11 "google.golang.org/genproto/googleapis/iam/v1"
import google_iam_v1 "google.golang.org/genproto/googleapis/iam/v1"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"
import _ "google.golang.org/genproto/protobuf"
import google_protobuf3 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Supported key algorithms.
type ServiceAccountKeyAlgorithm int32

const (
	// An unspecified key algorithm.
	ServiceAccountKeyAlgorithm_KEY_ALG_UNSPECIFIED ServiceAccountKeyAlgorithm = 0
	// 1k RSA Key.
	ServiceAccountKeyAlgorithm_KEY_ALG_RSA_1024 ServiceAccountKeyAlgorithm = 1
	// 2k RSA Key.
	ServiceAccountKeyAlgorithm_KEY_ALG_RSA_2048 ServiceAccountKeyAlgorithm = 2
)

var ServiceAccountKeyAlgorithm_name = map[int32]string{
	0: "KEY_ALG_UNSPECIFIED",
	1: "KEY_ALG_RSA_1024",
	2: "KEY_ALG_RSA_2048",
}
var ServiceAccountKeyAlgorithm_value = map[string]int32{
	"KEY_ALG_UNSPECIFIED": 0,
	"KEY_ALG_RSA_1024":    1,
	"KEY_ALG_RSA_2048":    2,
}

func (x ServiceAccountKeyAlgorithm) String() string {
	return proto.EnumName(ServiceAccountKeyAlgorithm_name, int32(x))
}
func (ServiceAccountKeyAlgorithm) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Supported private key output formats.
type ServiceAccountPrivateKeyType int32

const (
	// Unspecified. Equivalent to `TYPE_GOOGLE_CREDENTIALS_FILE`.
	ServiceAccountPrivateKeyType_TYPE_UNSPECIFIED ServiceAccountPrivateKeyType = 0
	// PKCS12 format.
	// The password for the PKCS12 file is `notasecret`.
	// For more information, see https://tools.ietf.org/html/rfc7292.
	ServiceAccountPrivateKeyType_TYPE_PKCS12_FILE ServiceAccountPrivateKeyType = 1
	// Google Credentials File format.
	ServiceAccountPrivateKeyType_TYPE_GOOGLE_CREDENTIALS_FILE ServiceAccountPrivateKeyType = 2
)

var ServiceAccountPrivateKeyType_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "TYPE_PKCS12_FILE",
	2: "TYPE_GOOGLE_CREDENTIALS_FILE",
}
var ServiceAccountPrivateKeyType_value = map[string]int32{
	"TYPE_UNSPECIFIED":             0,
	"TYPE_PKCS12_FILE":             1,
	"TYPE_GOOGLE_CREDENTIALS_FILE": 2,
}

func (x ServiceAccountPrivateKeyType) String() string {
	return proto.EnumName(ServiceAccountPrivateKeyType_name, int32(x))
}
func (ServiceAccountPrivateKeyType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Supported public key output formats.
type ServiceAccountPublicKeyType int32

const (
	// Unspecified. Returns nothing here.
	ServiceAccountPublicKeyType_TYPE_NONE ServiceAccountPublicKeyType = 0
	// X509 PEM format.
	ServiceAccountPublicKeyType_TYPE_X509_PEM_FILE ServiceAccountPublicKeyType = 1
	// Raw public key.
	ServiceAccountPublicKeyType_TYPE_RAW_PUBLIC_KEY ServiceAccountPublicKeyType = 2
)

var ServiceAccountPublicKeyType_name = map[int32]string{
	0: "TYPE_NONE",
	1: "TYPE_X509_PEM_FILE",
	2: "TYPE_RAW_PUBLIC_KEY",
}
var ServiceAccountPublicKeyType_value = map[string]int32{
	"TYPE_NONE":           0,
	"TYPE_X509_PEM_FILE":  1,
	"TYPE_RAW_PUBLIC_KEY": 2,
}

func (x ServiceAccountPublicKeyType) String() string {
	return proto.EnumName(ServiceAccountPublicKeyType_name, int32(x))
}
func (ServiceAccountPublicKeyType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// `KeyType` filters to selectively retrieve certain varieties
// of keys.
type ListServiceAccountKeysRequest_KeyType int32

const (
	// Unspecified key type. The presence of this in the
	// message will immediately result in an error.
	ListServiceAccountKeysRequest_KEY_TYPE_UNSPECIFIED ListServiceAccountKeysRequest_KeyType = 0
	// User-managed keys (managed and rotated by the user).
	ListServiceAccountKeysRequest_USER_MANAGED ListServiceAccountKeysRequest_KeyType = 1
	// System-managed keys (managed and rotated by Google).
	ListServiceAccountKeysRequest_SYSTEM_MANAGED ListServiceAccountKeysRequest_KeyType = 2
)

var ListServiceAccountKeysRequest_KeyType_name = map[int32]string{
	0: "KEY_TYPE_UNSPECIFIED",
	1: "USER_MANAGED",
	2: "SYSTEM_MANAGED",
}
var ListServiceAccountKeysRequest_KeyType_value = map[string]int32{
	"KEY_TYPE_UNSPECIFIED": 0,
	"USER_MANAGED":         1,
	"SYSTEM_MANAGED":       2,
}

func (x ListServiceAccountKeysRequest_KeyType) String() string {
	return proto.EnumName(ListServiceAccountKeysRequest_KeyType_name, int32(x))
}
func (ListServiceAccountKeysRequest_KeyType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{6, 0}
}

// A service account in the Identity and Access Management API.
//
// To create a service account, specify the `project_id` and the `account_id`
// for the account.  The `account_id` is unique within the project, and is used
// to generate the service account email address and a stable
// `unique_id`.
//
// If the account already exists, the account's resource name is returned
// in util::Status's ResourceInfo.resource_name in the format of
// projects/{project}/serviceAccounts/{email}. The caller can use the name in
// other methods to access the account.
//
// All other methods can identify the service account using the format
// `projects/{project}/serviceAccounts/{account}`.
// Using `-` as a wildcard for the project will infer the project from
// the account. The `account` value can be the `email` address or the
// `unique_id` of the service account.
type ServiceAccount struct {
	// The resource name of the service account in the following format:
	// `projects/{project}/serviceAccounts/{account}`.
	//
	// Requests using `-` as a wildcard for the project will infer the project
	// from the `account` and the `account` value can be the `email` address or
	// the `unique_id` of the service account.
	//
	// In responses the resource name will always be in the format
	// `projects/{project}/serviceAccounts/{email}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// @OutputOnly The id of the project that owns the service account.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// @OutputOnly The unique and stable id of the service account.
	UniqueId string `protobuf:"bytes,4,opt,name=unique_id,json=uniqueId" json:"unique_id,omitempty"`
	// @OutputOnly The email address of the service account.
	Email string `protobuf:"bytes,5,opt,name=email" json:"email,omitempty"`
	// Optional. A user-specified description of the service account.  Must be
	// fewer than 100 UTF-8 bytes.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// Used to perform a consistent read-modify-write.
	Etag []byte `protobuf:"bytes,7,opt,name=etag,proto3" json:"etag,omitempty"`
	// @OutputOnly. The OAuth2 client id for the service account.
	// This is used in conjunction with the OAuth2 clientconfig API to make
	// three legged OAuth2 (3LO) flows to access the data of Google users.
	Oauth2ClientId string `protobuf:"bytes,9,opt,name=oauth2_client_id,json=oauth2ClientId" json:"oauth2_client_id,omitempty"`
}

func (m *ServiceAccount) Reset()                    { *m = ServiceAccount{} }
func (m *ServiceAccount) String() string            { return proto.CompactTextString(m) }
func (*ServiceAccount) ProtoMessage()               {}
func (*ServiceAccount) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// The service account create request.
type CreateServiceAccountRequest struct {
	// Required. The resource name of the project associated with the service
	// accounts, such as `projects/my-project-123`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Required. The account id that is used to generate the service account
	// email address and a stable unique id. It is unique within a project,
	// must be 6-30 characters long, and match the regular expression
	// `[a-z]([-a-z0-9]*[a-z0-9])` to comply with RFC1035.
	AccountId string `protobuf:"bytes,2,opt,name=account_id,json=accountId" json:"account_id,omitempty"`
	// The [ServiceAccount][google.iam.admin.v1.ServiceAccount] resource to create.
	// Currently, only the following values are user assignable:
	// `display_name` .
	ServiceAccount *ServiceAccount `protobuf:"bytes,3,opt,name=service_account,json=serviceAccount" json:"service_account,omitempty"`
}

func (m *CreateServiceAccountRequest) Reset()                    { *m = CreateServiceAccountRequest{} }
func (m *CreateServiceAccountRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateServiceAccountRequest) ProtoMessage()               {}
func (*CreateServiceAccountRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *CreateServiceAccountRequest) GetServiceAccount() *ServiceAccount {
	if m != nil {
		return m.ServiceAccount
	}
	return nil
}

// The service account list request.
type ListServiceAccountsRequest struct {
	// Required. The resource name of the project associated with the service
	// accounts, such as `projects/my-project-123`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Optional limit on the number of service accounts to include in the
	// response. Further accounts can subsequently be obtained by including the
	// [ListServiceAccountsResponse.next_page_token][google.iam.admin.v1.ListServiceAccountsResponse.next_page_token]
	// in a subsequent request.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Optional pagination token returned in an earlier
	// [ListServiceAccountsResponse.next_page_token][google.iam.admin.v1.ListServiceAccountsResponse.next_page_token].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListServiceAccountsRequest) Reset()                    { *m = ListServiceAccountsRequest{} }
func (m *ListServiceAccountsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListServiceAccountsRequest) ProtoMessage()               {}
func (*ListServiceAccountsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// The service account list response.
type ListServiceAccountsResponse struct {
	// The list of matching service accounts.
	Accounts []*ServiceAccount `protobuf:"bytes,1,rep,name=accounts" json:"accounts,omitempty"`
	// To retrieve the next page of results, set
	// [ListServiceAccountsRequest.page_token][google.iam.admin.v1.ListServiceAccountsRequest.page_token]
	// to this value.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListServiceAccountsResponse) Reset()                    { *m = ListServiceAccountsResponse{} }
func (m *ListServiceAccountsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListServiceAccountsResponse) ProtoMessage()               {}
func (*ListServiceAccountsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ListServiceAccountsResponse) GetAccounts() []*ServiceAccount {
	if m != nil {
		return m.Accounts
	}
	return nil
}

// The service account get request.
type GetServiceAccountRequest struct {
	// The resource name of the service account in the following format:
	// `projects/{project}/serviceAccounts/{account}`.
	// Using `-` as a wildcard for the project will infer the project from
	// the account. The `account` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetServiceAccountRequest) Reset()                    { *m = GetServiceAccountRequest{} }
func (m *GetServiceAccountRequest) String() string            { return proto.CompactTextString(m) }
func (*GetServiceAccountRequest) ProtoMessage()               {}
func (*GetServiceAccountRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// The service account delete request.
type DeleteServiceAccountRequest struct {
	// The resource name of the service account in the following format:
	// `projects/{project}/serviceAccounts/{account}`.
	// Using `-` as a wildcard for the project will infer the project from
	// the account. The `account` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteServiceAccountRequest) Reset()                    { *m = DeleteServiceAccountRequest{} }
func (m *DeleteServiceAccountRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteServiceAccountRequest) ProtoMessage()               {}
func (*DeleteServiceAccountRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// The service account keys list request.
type ListServiceAccountKeysRequest struct {
	// The resource name of the service account in the following format:
	// `projects/{project}/serviceAccounts/{account}`.
	//
	// Using `-` as a wildcard for the project, will infer the project from
	// the account. The `account` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Filters the types of keys the user wants to include in the list
	// response. Duplicate key types are not allowed. If no key type
	// is provided, all keys are returned.
	KeyTypes []ListServiceAccountKeysRequest_KeyType `protobuf:"varint,2,rep,packed,name=key_types,json=keyTypes,enum=google.iam.admin.v1.ListServiceAccountKeysRequest_KeyType" json:"key_types,omitempty"`
}

func (m *ListServiceAccountKeysRequest) Reset()                    { *m = ListServiceAccountKeysRequest{} }
func (m *ListServiceAccountKeysRequest) String() string            { return proto.CompactTextString(m) }
func (*ListServiceAccountKeysRequest) ProtoMessage()               {}
func (*ListServiceAccountKeysRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

// The service account keys list response.
type ListServiceAccountKeysResponse struct {
	// The public keys for the service account.
	Keys []*ServiceAccountKey `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
}

func (m *ListServiceAccountKeysResponse) Reset()                    { *m = ListServiceAccountKeysResponse{} }
func (m *ListServiceAccountKeysResponse) String() string            { return proto.CompactTextString(m) }
func (*ListServiceAccountKeysResponse) ProtoMessage()               {}
func (*ListServiceAccountKeysResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ListServiceAccountKeysResponse) GetKeys() []*ServiceAccountKey {
	if m != nil {
		return m.Keys
	}
	return nil
}

// The service account key get by id request.
type GetServiceAccountKeyRequest struct {
	// The resource name of the service account key in the following format:
	// `projects/{project}/serviceAccounts/{account}/keys/{key}`.
	//
	// Using `-` as a wildcard for the project will infer the project from
	// the account. The `account` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The output format of the public key requested.
	// X509_PEM is the default output format.
	PublicKeyType ServiceAccountPublicKeyType `protobuf:"varint,2,opt,name=public_key_type,json=publicKeyType,enum=google.iam.admin.v1.ServiceAccountPublicKeyType" json:"public_key_type,omitempty"`
}

func (m *GetServiceAccountKeyRequest) Reset()                    { *m = GetServiceAccountKeyRequest{} }
func (m *GetServiceAccountKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*GetServiceAccountKeyRequest) ProtoMessage()               {}
func (*GetServiceAccountKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

// Represents a service account key.
//
// A service account has two sets of key-pairs: user-managed, and
// system-managed.
//
// User-managed key-pairs can be created and deleted by users.  Users are
// responsible for rotating these keys periodically to ensure security of
// their service accounts.  Users retain the private key of these key-pairs,
// and Google retains ONLY the public key.
//
// System-managed key-pairs are managed automatically by Google, and rotated
// daily without user intervention.  The private key never leaves Google's
// servers to maximize security.
//
// Public keys for all service accounts are also published at the OAuth2
// Service Account API.
type ServiceAccountKey struct {
	// The resource name of the service account key in the following format
	// `projects/{project}/serviceAccounts/{account}/keys/{key}`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The output format for the private key.
	// Only provided in `CreateServiceAccountKey` responses, not
	// in `GetServiceAccountKey` or `ListServiceAccountKey` responses.
	//
	// Google never exposes system-managed private keys, and never retains
	// user-managed private keys.
	PrivateKeyType ServiceAccountPrivateKeyType `protobuf:"varint,2,opt,name=private_key_type,json=privateKeyType,enum=google.iam.admin.v1.ServiceAccountPrivateKeyType" json:"private_key_type,omitempty"`
	// Specifies the algorithm (and possibly key size) for the key.
	KeyAlgorithm ServiceAccountKeyAlgorithm `protobuf:"varint,8,opt,name=key_algorithm,json=keyAlgorithm,enum=google.iam.admin.v1.ServiceAccountKeyAlgorithm" json:"key_algorithm,omitempty"`
	// The private key data. Only provided in `CreateServiceAccountKey`
	// responses.
	PrivateKeyData []byte `protobuf:"bytes,3,opt,name=private_key_data,json=privateKeyData,proto3" json:"private_key_data,omitempty"`
	// The public key data. Only provided in `GetServiceAccountKey` responses.
	PublicKeyData []byte `protobuf:"bytes,7,opt,name=public_key_data,json=publicKeyData,proto3" json:"public_key_data,omitempty"`
	// The key can be used after this timestamp.
	ValidAfterTime *google_protobuf3.Timestamp `protobuf:"bytes,4,opt,name=valid_after_time,json=validAfterTime" json:"valid_after_time,omitempty"`
	// The key can be used before this timestamp.
	ValidBeforeTime *google_protobuf3.Timestamp `protobuf:"bytes,5,opt,name=valid_before_time,json=validBeforeTime" json:"valid_before_time,omitempty"`
}

func (m *ServiceAccountKey) Reset()                    { *m = ServiceAccountKey{} }
func (m *ServiceAccountKey) String() string            { return proto.CompactTextString(m) }
func (*ServiceAccountKey) ProtoMessage()               {}
func (*ServiceAccountKey) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *ServiceAccountKey) GetValidAfterTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.ValidAfterTime
	}
	return nil
}

func (m *ServiceAccountKey) GetValidBeforeTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.ValidBeforeTime
	}
	return nil
}

// The service account key create request.
type CreateServiceAccountKeyRequest struct {
	// The resource name of the service account in the following format:
	// `projects/{project}/serviceAccounts/{account}`.
	// Using `-` as a wildcard for the project will infer the project from
	// the account. The `account` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The output format of the private key. `GOOGLE_CREDENTIALS_FILE` is the
	// default output format.
	PrivateKeyType ServiceAccountPrivateKeyType `protobuf:"varint,2,opt,name=private_key_type,json=privateKeyType,enum=google.iam.admin.v1.ServiceAccountPrivateKeyType" json:"private_key_type,omitempty"`
	// Which type of key and algorithm to use for the key.
	// The default is currently a 4K RSA key.  However this may change in the
	// future.
	KeyAlgorithm ServiceAccountKeyAlgorithm `protobuf:"varint,3,opt,name=key_algorithm,json=keyAlgorithm,enum=google.iam.admin.v1.ServiceAccountKeyAlgorithm" json:"key_algorithm,omitempty"`
}

func (m *CreateServiceAccountKeyRequest) Reset()                    { *m = CreateServiceAccountKeyRequest{} }
func (m *CreateServiceAccountKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateServiceAccountKeyRequest) ProtoMessage()               {}
func (*CreateServiceAccountKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

// The service account key delete request.
type DeleteServiceAccountKeyRequest struct {
	// The resource name of the service account key in the following format:
	// `projects/{project}/serviceAccounts/{account}/keys/{key}`.
	// Using `-` as a wildcard for the project will infer the project from
	// the account. The `account` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteServiceAccountKeyRequest) Reset()                    { *m = DeleteServiceAccountKeyRequest{} }
func (m *DeleteServiceAccountKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteServiceAccountKeyRequest) ProtoMessage()               {}
func (*DeleteServiceAccountKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

// The service account sign blob request.
type SignBlobRequest struct {
	// The resource name of the service account in the following format:
	// `projects/{project}/serviceAccounts/{account}`.
	// Using `-` as a wildcard for the project will infer the project from
	// the account. The `account` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The bytes to sign.
	BytesToSign []byte `protobuf:"bytes,2,opt,name=bytes_to_sign,json=bytesToSign,proto3" json:"bytes_to_sign,omitempty"`
}

func (m *SignBlobRequest) Reset()                    { *m = SignBlobRequest{} }
func (m *SignBlobRequest) String() string            { return proto.CompactTextString(m) }
func (*SignBlobRequest) ProtoMessage()               {}
func (*SignBlobRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

// The service account sign blob response.
type SignBlobResponse struct {
	// The id of the key used to sign the blob.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId" json:"key_id,omitempty"`
	// The signed blob.
	Signature []byte `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (m *SignBlobResponse) Reset()                    { *m = SignBlobResponse{} }
func (m *SignBlobResponse) String() string            { return proto.CompactTextString(m) }
func (*SignBlobResponse) ProtoMessage()               {}
func (*SignBlobResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

// A role in the Identity and Access Management API.
type Role struct {
	// The name of the role.
	//
	// When Role is used in CreateRole, the role name must not be set.
	//
	// When Role is used in output and other input such as UpdateRole, the role
	// name is the complete path, e.g., roles/logging.viewer for curated roles
	// and organizations/{organization-id}/roles/logging.viewer for custom roles.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Optional.  A human-readable title for the role.  Typically this
	// is limited to 100 UTF-8 bytes.
	Title string `protobuf:"bytes,2,opt,name=title" json:"title,omitempty"`
	// Optional.  A human-readable description for the role.
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
}

func (m *Role) Reset()                    { *m = Role{} }
func (m *Role) String() string            { return proto.CompactTextString(m) }
func (*Role) ProtoMessage()               {}
func (*Role) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

// The grantable role query request.
type QueryGrantableRolesRequest struct {
	// Required. The full resource name to query from the list of grantable roles.
	//
	// The name follows the Google Cloud Platform resource format.
	// For example, a Cloud Platform project with id `my-project` will be named
	// `//cloudresourcemanager.googleapis.com/projects/my-project`.
	FullResourceName string `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName" json:"full_resource_name,omitempty"`
}

func (m *QueryGrantableRolesRequest) Reset()                    { *m = QueryGrantableRolesRequest{} }
func (m *QueryGrantableRolesRequest) String() string            { return proto.CompactTextString(m) }
func (*QueryGrantableRolesRequest) ProtoMessage()               {}
func (*QueryGrantableRolesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

// The grantable role query response.
type QueryGrantableRolesResponse struct {
	// The list of matching roles.
	Roles []*Role `protobuf:"bytes,1,rep,name=roles" json:"roles,omitempty"`
}

func (m *QueryGrantableRolesResponse) Reset()                    { *m = QueryGrantableRolesResponse{} }
func (m *QueryGrantableRolesResponse) String() string            { return proto.CompactTextString(m) }
func (*QueryGrantableRolesResponse) ProtoMessage()               {}
func (*QueryGrantableRolesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *QueryGrantableRolesResponse) GetRoles() []*Role {
	if m != nil {
		return m.Roles
	}
	return nil
}

func init() {
	proto.RegisterType((*ServiceAccount)(nil), "google.iam.admin.v1.ServiceAccount")
	proto.RegisterType((*CreateServiceAccountRequest)(nil), "google.iam.admin.v1.CreateServiceAccountRequest")
	proto.RegisterType((*ListServiceAccountsRequest)(nil), "google.iam.admin.v1.ListServiceAccountsRequest")
	proto.RegisterType((*ListServiceAccountsResponse)(nil), "google.iam.admin.v1.ListServiceAccountsResponse")
	proto.RegisterType((*GetServiceAccountRequest)(nil), "google.iam.admin.v1.GetServiceAccountRequest")
	proto.RegisterType((*DeleteServiceAccountRequest)(nil), "google.iam.admin.v1.DeleteServiceAccountRequest")
	proto.RegisterType((*ListServiceAccountKeysRequest)(nil), "google.iam.admin.v1.ListServiceAccountKeysRequest")
	proto.RegisterType((*ListServiceAccountKeysResponse)(nil), "google.iam.admin.v1.ListServiceAccountKeysResponse")
	proto.RegisterType((*GetServiceAccountKeyRequest)(nil), "google.iam.admin.v1.GetServiceAccountKeyRequest")
	proto.RegisterType((*ServiceAccountKey)(nil), "google.iam.admin.v1.ServiceAccountKey")
	proto.RegisterType((*CreateServiceAccountKeyRequest)(nil), "google.iam.admin.v1.CreateServiceAccountKeyRequest")
	proto.RegisterType((*DeleteServiceAccountKeyRequest)(nil), "google.iam.admin.v1.DeleteServiceAccountKeyRequest")
	proto.RegisterType((*SignBlobRequest)(nil), "google.iam.admin.v1.SignBlobRequest")
	proto.RegisterType((*SignBlobResponse)(nil), "google.iam.admin.v1.SignBlobResponse")
	proto.RegisterType((*Role)(nil), "google.iam.admin.v1.Role")
	proto.RegisterType((*QueryGrantableRolesRequest)(nil), "google.iam.admin.v1.QueryGrantableRolesRequest")
	proto.RegisterType((*QueryGrantableRolesResponse)(nil), "google.iam.admin.v1.QueryGrantableRolesResponse")
	proto.RegisterEnum("google.iam.admin.v1.ServiceAccountKeyAlgorithm", ServiceAccountKeyAlgorithm_name, ServiceAccountKeyAlgorithm_value)
	proto.RegisterEnum("google.iam.admin.v1.ServiceAccountPrivateKeyType", ServiceAccountPrivateKeyType_name, ServiceAccountPrivateKeyType_value)
	proto.RegisterEnum("google.iam.admin.v1.ServiceAccountPublicKeyType", ServiceAccountPublicKeyType_name, ServiceAccountPublicKeyType_value)
	proto.RegisterEnum("google.iam.admin.v1.ListServiceAccountKeysRequest_KeyType", ListServiceAccountKeysRequest_KeyType_name, ListServiceAccountKeysRequest_KeyType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for IAM service

type IAMClient interface {
	// Lists [ServiceAccounts][google.iam.admin.v1.ServiceAccount] for a project.
	ListServiceAccounts(ctx context.Context, in *ListServiceAccountsRequest, opts ...grpc.CallOption) (*ListServiceAccountsResponse, error)
	// Gets a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	GetServiceAccount(ctx context.Context, in *GetServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error)
	// Creates a [ServiceAccount][google.iam.admin.v1.ServiceAccount]
	// and returns it.
	CreateServiceAccount(ctx context.Context, in *CreateServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error)
	// Updates a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	//
	// Currently, only the following fields are updatable:
	// `display_name` .
	// The `etag` is mandatory.
	UpdateServiceAccount(ctx context.Context, in *ServiceAccount, opts ...grpc.CallOption) (*ServiceAccount, error)
	// Deletes a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	DeleteServiceAccount(ctx context.Context, in *DeleteServiceAccountRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Lists [ServiceAccountKeys][google.iam.admin.v1.ServiceAccountKey].
	ListServiceAccountKeys(ctx context.Context, in *ListServiceAccountKeysRequest, opts ...grpc.CallOption) (*ListServiceAccountKeysResponse, error)
	// Gets the [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey]
	// by key id.
	GetServiceAccountKey(ctx context.Context, in *GetServiceAccountKeyRequest, opts ...grpc.CallOption) (*ServiceAccountKey, error)
	// Creates a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey]
	// and returns it.
	CreateServiceAccountKey(ctx context.Context, in *CreateServiceAccountKeyRequest, opts ...grpc.CallOption) (*ServiceAccountKey, error)
	// Deletes a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey].
	DeleteServiceAccountKey(ctx context.Context, in *DeleteServiceAccountKeyRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Signs a blob using a service account's system-managed private key.
	SignBlob(ctx context.Context, in *SignBlobRequest, opts ...grpc.CallOption) (*SignBlobResponse, error)
	// Returns the IAM access control policy for a
	// [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	GetIamPolicy(ctx context.Context, in *google_iam_v11.GetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error)
	// Sets the IAM access control policy for a
	// [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	SetIamPolicy(ctx context.Context, in *google_iam_v11.SetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error)
	// Tests the specified permissions against the IAM access control policy
	// for a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	TestIamPermissions(ctx context.Context, in *google_iam_v11.TestIamPermissionsRequest, opts ...grpc.CallOption) (*google_iam_v11.TestIamPermissionsResponse, error)
	// Queries roles that can be granted on a particular resource.
	// A role is grantable if it can be used as the role in a binding for a policy
	// for that resource.
	QueryGrantableRoles(ctx context.Context, in *QueryGrantableRolesRequest, opts ...grpc.CallOption) (*QueryGrantableRolesResponse, error)
}

type iAMClient struct {
	cc *grpc.ClientConn
}

func NewIAMClient(cc *grpc.ClientConn) IAMClient {
	return &iAMClient{cc}
}

func (c *iAMClient) ListServiceAccounts(ctx context.Context, in *ListServiceAccountsRequest, opts ...grpc.CallOption) (*ListServiceAccountsResponse, error) {
	out := new(ListServiceAccountsResponse)
	err := grpc.Invoke(ctx, "/google.iam.admin.v1.IAM/ListServiceAccounts", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) GetServiceAccount(ctx context.Context, in *GetServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error) {
	out := new(ServiceAccount)
	err := grpc.Invoke(ctx, "/google.iam.admin.v1.IAM/GetServiceAccount", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) CreateServiceAccount(ctx context.Context, in *CreateServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error) {
	out := new(ServiceAccount)
	err := grpc.Invoke(ctx, "/google.iam.admin.v1.IAM/CreateServiceAccount", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) UpdateServiceAccount(ctx context.Context, in *ServiceAccount, opts ...grpc.CallOption) (*ServiceAccount, error) {
	out := new(ServiceAccount)
	err := grpc.Invoke(ctx, "/google.iam.admin.v1.IAM/UpdateServiceAccount", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) DeleteServiceAccount(ctx context.Context, in *DeleteServiceAccountRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.iam.admin.v1.IAM/DeleteServiceAccount", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) ListServiceAccountKeys(ctx context.Context, in *ListServiceAccountKeysRequest, opts ...grpc.CallOption) (*ListServiceAccountKeysResponse, error) {
	out := new(ListServiceAccountKeysResponse)
	err := grpc.Invoke(ctx, "/google.iam.admin.v1.IAM/ListServiceAccountKeys", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) GetServiceAccountKey(ctx context.Context, in *GetServiceAccountKeyRequest, opts ...grpc.CallOption) (*ServiceAccountKey, error) {
	out := new(ServiceAccountKey)
	err := grpc.Invoke(ctx, "/google.iam.admin.v1.IAM/GetServiceAccountKey", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) CreateServiceAccountKey(ctx context.Context, in *CreateServiceAccountKeyRequest, opts ...grpc.CallOption) (*ServiceAccountKey, error) {
	out := new(ServiceAccountKey)
	err := grpc.Invoke(ctx, "/google.iam.admin.v1.IAM/CreateServiceAccountKey", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) DeleteServiceAccountKey(ctx context.Context, in *DeleteServiceAccountKeyRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.iam.admin.v1.IAM/DeleteServiceAccountKey", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) SignBlob(ctx context.Context, in *SignBlobRequest, opts ...grpc.CallOption) (*SignBlobResponse, error) {
	out := new(SignBlobResponse)
	err := grpc.Invoke(ctx, "/google.iam.admin.v1.IAM/SignBlob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) GetIamPolicy(ctx context.Context, in *google_iam_v11.GetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error) {
	out := new(google_iam_v1.Policy)
	err := grpc.Invoke(ctx, "/google.iam.admin.v1.IAM/GetIamPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) SetIamPolicy(ctx context.Context, in *google_iam_v11.SetIamPolicyRequest, opts ...grpc.CallOption) (*google_iam_v1.Policy, error) {
	out := new(google_iam_v1.Policy)
	err := grpc.Invoke(ctx, "/google.iam.admin.v1.IAM/SetIamPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) TestIamPermissions(ctx context.Context, in *google_iam_v11.TestIamPermissionsRequest, opts ...grpc.CallOption) (*google_iam_v11.TestIamPermissionsResponse, error) {
	out := new(google_iam_v11.TestIamPermissionsResponse)
	err := grpc.Invoke(ctx, "/google.iam.admin.v1.IAM/TestIamPermissions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) QueryGrantableRoles(ctx context.Context, in *QueryGrantableRolesRequest, opts ...grpc.CallOption) (*QueryGrantableRolesResponse, error) {
	out := new(QueryGrantableRolesResponse)
	err := grpc.Invoke(ctx, "/google.iam.admin.v1.IAM/QueryGrantableRoles", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for IAM service

type IAMServer interface {
	// Lists [ServiceAccounts][google.iam.admin.v1.ServiceAccount] for a project.
	ListServiceAccounts(context.Context, *ListServiceAccountsRequest) (*ListServiceAccountsResponse, error)
	// Gets a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	GetServiceAccount(context.Context, *GetServiceAccountRequest) (*ServiceAccount, error)
	// Creates a [ServiceAccount][google.iam.admin.v1.ServiceAccount]
	// and returns it.
	CreateServiceAccount(context.Context, *CreateServiceAccountRequest) (*ServiceAccount, error)
	// Updates a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	//
	// Currently, only the following fields are updatable:
	// `display_name` .
	// The `etag` is mandatory.
	UpdateServiceAccount(context.Context, *ServiceAccount) (*ServiceAccount, error)
	// Deletes a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	DeleteServiceAccount(context.Context, *DeleteServiceAccountRequest) (*google_protobuf1.Empty, error)
	// Lists [ServiceAccountKeys][google.iam.admin.v1.ServiceAccountKey].
	ListServiceAccountKeys(context.Context, *ListServiceAccountKeysRequest) (*ListServiceAccountKeysResponse, error)
	// Gets the [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey]
	// by key id.
	GetServiceAccountKey(context.Context, *GetServiceAccountKeyRequest) (*ServiceAccountKey, error)
	// Creates a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey]
	// and returns it.
	CreateServiceAccountKey(context.Context, *CreateServiceAccountKeyRequest) (*ServiceAccountKey, error)
	// Deletes a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey].
	DeleteServiceAccountKey(context.Context, *DeleteServiceAccountKeyRequest) (*google_protobuf1.Empty, error)
	// Signs a blob using a service account's system-managed private key.
	SignBlob(context.Context, *SignBlobRequest) (*SignBlobResponse, error)
	// Returns the IAM access control policy for a
	// [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	GetIamPolicy(context.Context, *google_iam_v11.GetIamPolicyRequest) (*google_iam_v1.Policy, error)
	// Sets the IAM access control policy for a
	// [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	SetIamPolicy(context.Context, *google_iam_v11.SetIamPolicyRequest) (*google_iam_v1.Policy, error)
	// Tests the specified permissions against the IAM access control policy
	// for a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	TestIamPermissions(context.Context, *google_iam_v11.TestIamPermissionsRequest) (*google_iam_v11.TestIamPermissionsResponse, error)
	// Queries roles that can be granted on a particular resource.
	// A role is grantable if it can be used as the role in a binding for a policy
	// for that resource.
	QueryGrantableRoles(context.Context, *QueryGrantableRolesRequest) (*QueryGrantableRolesResponse, error)
}

func RegisterIAMServer(s *grpc.Server, srv IAMServer) {
	s.RegisterService(&_IAM_serviceDesc, srv)
}

func _IAM_ListServiceAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).ListServiceAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/ListServiceAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).ListServiceAccounts(ctx, req.(*ListServiceAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_GetServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).GetServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/GetServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).GetServiceAccount(ctx, req.(*GetServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_CreateServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).CreateServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/CreateServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).CreateServiceAccount(ctx, req.(*CreateServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_UpdateServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ServiceAccount)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).UpdateServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/UpdateServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).UpdateServiceAccount(ctx, req.(*ServiceAccount))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_DeleteServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).DeleteServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/DeleteServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).DeleteServiceAccount(ctx, req.(*DeleteServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_ListServiceAccountKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceAccountKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).ListServiceAccountKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/ListServiceAccountKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).ListServiceAccountKeys(ctx, req.(*ListServiceAccountKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_GetServiceAccountKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceAccountKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).GetServiceAccountKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/GetServiceAccountKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).GetServiceAccountKey(ctx, req.(*GetServiceAccountKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_CreateServiceAccountKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceAccountKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).CreateServiceAccountKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/CreateServiceAccountKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).CreateServiceAccountKey(ctx, req.(*CreateServiceAccountKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_DeleteServiceAccountKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceAccountKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).DeleteServiceAccountKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/DeleteServiceAccountKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).DeleteServiceAccountKey(ctx, req.(*DeleteServiceAccountKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_SignBlob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignBlobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).SignBlob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/SignBlob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).SignBlob(ctx, req.(*SignBlobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).GetIamPolicy(ctx, req.(*google_iam_v11.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).SetIamPolicy(ctx, req.(*google_iam_v11.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(google_iam_v11.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).TestIamPermissions(ctx, req.(*google_iam_v11.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_QueryGrantableRoles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryGrantableRolesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).QueryGrantableRoles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/QueryGrantableRoles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).QueryGrantableRoles(ctx, req.(*QueryGrantableRolesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _IAM_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.iam.admin.v1.IAM",
	HandlerType: (*IAMServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListServiceAccounts",
			Handler:    _IAM_ListServiceAccounts_Handler,
		},
		{
			MethodName: "GetServiceAccount",
			Handler:    _IAM_GetServiceAccount_Handler,
		},
		{
			MethodName: "CreateServiceAccount",
			Handler:    _IAM_CreateServiceAccount_Handler,
		},
		{
			MethodName: "UpdateServiceAccount",
			Handler:    _IAM_UpdateServiceAccount_Handler,
		},
		{
			MethodName: "DeleteServiceAccount",
			Handler:    _IAM_DeleteServiceAccount_Handler,
		},
		{
			MethodName: "ListServiceAccountKeys",
			Handler:    _IAM_ListServiceAccountKeys_Handler,
		},
		{
			MethodName: "GetServiceAccountKey",
			Handler:    _IAM_GetServiceAccountKey_Handler,
		},
		{
			MethodName: "CreateServiceAccountKey",
			Handler:    _IAM_CreateServiceAccountKey_Handler,
		},
		{
			MethodName: "DeleteServiceAccountKey",
			Handler:    _IAM_DeleteServiceAccountKey_Handler,
		},
		{
			MethodName: "SignBlob",
			Handler:    _IAM_SignBlob_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _IAM_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _IAM_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _IAM_TestIamPermissions_Handler,
		},
		{
			MethodName: "QueryGrantableRoles",
			Handler:    _IAM_QueryGrantableRoles_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/iam/admin/v1/iam.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/iam/admin/v1/iam.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1631 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xbc, 0x58, 0x4f, 0x6f, 0x1b, 0xc7,
	0x15, 0xf7, 0xe8, 0x8f, 0x2d, 0x3e, 0x51, 0x14, 0x35, 0xa2, 0x2d, 0x96, 0xb4, 0x0d, 0x75, 0x5b,
	0xdb, 0x34, 0x61, 0x73, 0x29, 0x4a, 0x6e, 0x6d, 0xb9, 0x6e, 0x4b, 0x51, 0x34, 0xb1, 0xd5, 0x1f,
	0xb3, 0x4b, 0x0a, 0xb6, 0xd0, 0x16, 0x8b, 0x21, 0x39, 0xa2, 0xb7, 0x5a, 0xee, 0xae, 0x77, 0x97,
	0x42, 0xe9, 0xc2, 0x97, 0x1e, 0x7a, 0x31, 0x10, 0x20, 0x88, 0x0f, 0x39, 0x39, 0x40, 0x2e, 0xc9,
	0x2d, 0x97, 0x00, 0x01, 0xf2, 0x35, 0x72, 0xc8, 0x39, 0x40, 0x80, 0x7c, 0x85, 0x1c, 0x83, 0x99,
	0xdd, 0x95, 0x28, 0x72, 0x49, 0x2d, 0x83, 0x20, 0x17, 0x61, 0xe7, 0xbd, 0x79, 0xef, 0xfd, 0xde,
	0x7b, 0x33, 0x6f, 0x7e, 0x22, 0xfc, 0xa9, 0x6d, 0x18, 0x6d, 0x8d, 0xe6, 0xda, 0x86, 0x46, 0xf4,
	0x76, 0xce, 0xb0, 0xda, 0x62, 0x9b, 0xea, 0xa6, 0x65, 0x38, 0x86, 0xe8, 0xaa, 0x88, 0xa9, 0xda,
	0xa2, 0x4a, 0x3a, 0x22, 0x69, 0x75, 0x54, 0x5d, 0x3c, 0x59, 0x63, 0x8b, 0x1c, 0xdf, 0x81, 0x97,
	0x3d, 0x6b, 0x26, 0xe1, 0xea, 0xdc, 0xc9, 0x5a, 0x4a, 0x0a, 0xe7, 0x92, 0x98, 0xaa, 0x68, 0x53,
	0xeb, 0x44, 0x6d, 0xd2, 0xa6, 0xa1, 0x1f, 0xa9, 0x6d, 0x91, 0xe8, 0xba, 0xe1, 0x10, 0x47, 0x35,
	0x74, 0xdb, 0xf5, 0x9f, 0x7a, 0x12, 0x1e, 0x9d, 0x8b, 0x4b, 0x31, 0x0d, 0x4d, 0x6d, 0xf6, 0x3c,
	0xf3, 0x47, 0x13, 0x99, 0x9f, 0x33, 0x5d, 0x6f, 0xab, 0xce, 0xcb, 0x6e, 0x23, 0xd7, 0x34, 0x3a,
	0xa2, 0x6b, 0x2e, 0x72, 0x45, 0xa3, 0x7b, 0x24, 0x9a, 0x4e, 0xcf, 0xa4, 0xb6, 0x48, 0x3b, 0xa6,
	0xd3, 0x73, 0xff, 0x7a, 0x46, 0x1b, 0x63, 0xe2, 0x9d, 0x5a, 0x1f, 0xa9, 0x54, 0x6b, 0x29, 0x1d,
	0x62, 0x1f, 0x7b, 0x56, 0x8f, 0x2f, 0x0e, 0xe5, 0xa8, 0x1d, 0x6a, 0x3b, 0xa4, 0x63, 0x9e, 0x7d,
	0xb9, 0xc6, 0xc2, 0xb7, 0x08, 0x62, 0x35, 0xb7, 0x8a, 0xc5, 0x66, 0xd3, 0xe8, 0xea, 0x0e, 0xc6,
	0x30, 0xa3, 0x93, 0x0e, 0x4d, 0xa2, 0x55, 0x94, 0x89, 0xc8, 0xfc, 0x1b, 0xdf, 0x00, 0x30, 0x2d,
	0xe3, 0xdf, 0xb4, 0xe9, 0x28, 0x6a, 0x2b, 0x39, 0xc5, 0x35, 0x11, 0x4f, 0x22, 0xb5, 0x70, 0x1a,
	0x22, 0x5d, 0x5d, 0x7d, 0xd5, 0xa5, 0x4c, 0x3b, 0xc3, 0xb5, 0x73, 0xae, 0x40, 0x6a, 0xe1, 0x04,
	0xcc, 0xd2, 0x0e, 0x51, 0xb5, 0xe4, 0x2c, 0x57, 0xb8, 0x0b, 0xfc, 0x5b, 0x88, 0xb6, 0x54, 0xdb,
	0xd4, 0x48, 0x4f, 0xe1, 0xd1, 0x2e, 0x73, 0xe5, 0xbc, 0x27, 0xdb, 0x67, 0x41, 0x31, 0xcc, 0x50,
	0x87, 0xb4, 0x93, 0x57, 0x56, 0x51, 0x26, 0x2a, 0xf3, 0x6f, 0x9c, 0x81, 0xb8, 0x41, 0xba, 0xce,
	0xcb, 0x82, 0xd2, 0xd4, 0x54, 0xaa, 0x73, 0x38, 0x11, 0x6e, 0x1a, 0x73, 0xe5, 0x25, 0x2e, 0x96,
	0x5a, 0xc2, 0x7b, 0x04, 0xe9, 0x92, 0x45, 0x89, 0x43, 0xcf, 0xe7, 0x27, 0xd3, 0x57, 0x5d, 0x6a,
	0x8f, 0x4c, 0x93, 0xb8, 0xbb, 0xfa, 0xd2, 0xf4, 0x24, 0x52, 0x0b, 0xef, 0xc2, 0xa2, 0x77, 0xe2,
	0x14, 0x4f, 0x98, 0x9c, 0x5e, 0x45, 0x99, 0xf9, 0xc2, 0xef, 0x72, 0x01, 0x07, 0x39, 0x37, 0x10,
	0x37, 0x66, 0x9f, 0x5b, 0x0b, 0x1a, 0xa4, 0x76, 0x55, 0xdb, 0x39, 0xbf, 0xcb, 0x1e, 0x07, 0x2f,
	0x0d, 0x11, 0x93, 0xb4, 0xa9, 0x62, 0xab, 0xaf, 0x29, 0x47, 0x37, 0x2b, 0xcf, 0x31, 0x41, 0x4d,
	0x7d, 0xed, 0xb6, 0x88, 0x29, 0x1d, 0xe3, 0x98, 0xea, 0x1c, 0x17, 0x6b, 0x11, 0x69, 0xd3, 0x3a,
	0x13, 0x08, 0xff, 0x47, 0x90, 0x0e, 0x0c, 0x67, 0x9b, 0x86, 0x6e, 0x53, 0xfc, 0x17, 0x98, 0xf3,
	0x72, 0xb2, 0x93, 0x68, 0x75, 0x3a, 0x6c, 0x52, 0xa7, 0x46, 0xf8, 0x36, 0x2c, 0xea, 0xf4, 0x3f,
	0x8e, 0xd2, 0x07, 0xc2, 0x2d, 0xe0, 0x02, 0x13, 0x57, 0x4f, 0x81, 0xe4, 0x20, 0x59, 0xa1, 0x4e,
	0xe8, 0x9e, 0x08, 0x6b, 0x90, 0xde, 0xa6, 0x1a, 0x9d, 0xa0, 0x8d, 0xec, 0x50, 0xdf, 0x18, 0xce,
	0x75, 0x87, 0xf6, 0xc6, 0x56, 0xf7, 0x39, 0x44, 0x8e, 0x69, 0x4f, 0xe1, 0x37, 0x26, 0x39, 0xb5,
	0x3a, 0x9d, 0x89, 0x15, 0x36, 0x03, 0x4b, 0x30, 0xd6, 0x75, 0x6e, 0x87, 0xf6, 0xea, 0x3d, 0x93,
	0xca, 0x73, 0xc7, 0xee, 0x87, 0x2d, 0x48, 0x70, 0xc5, 0x13, 0xe2, 0x24, 0x24, 0x76, 0xca, 0x87,
	0x4a, 0xfd, 0xb0, 0x5a, 0x56, 0x0e, 0xf6, 0x6b, 0xd5, 0x72, 0x49, 0x7a, 0x2a, 0x95, 0xb7, 0xe3,
	0x97, 0x70, 0x1c, 0xa2, 0x07, 0xb5, 0xb2, 0xac, 0xec, 0x15, 0xf7, 0x8b, 0x95, 0xf2, 0x76, 0x1c,
	0x61, 0x0c, 0xb1, 0xda, 0x61, 0xad, 0x5e, 0xde, 0x3b, 0x95, 0x4d, 0x09, 0xff, 0x84, 0x9b, 0xa3,
	0xa2, 0x7b, 0x7d, 0xdc, 0x84, 0x99, 0x63, 0xda, 0xf3, 0x7b, 0x78, 0x3b, 0x44, 0x0f, 0x77, 0x68,
	0x4f, 0xe6, 0x36, 0xc2, 0x5b, 0x04, 0xe9, 0xa1, 0xde, 0x30, 0xf5, 0x98, 0xaa, 0xbd, 0x80, 0x45,
	0xb3, 0xdb, 0xd0, 0xd4, 0xa6, 0xe2, 0x17, 0x8f, 0xb7, 0x3d, 0x56, 0xc8, 0x87, 0x08, 0x5d, 0xe5,
	0x96, 0x7e, 0xc5, 0x16, 0xcc, 0xfe, 0xa5, 0xf0, 0xf5, 0x34, 0x2c, 0x0d, 0x41, 0x09, 0xc4, 0xf0,
	0x0f, 0x88, 0x9b, 0x96, 0x7a, 0x42, 0x1c, 0x3a, 0x08, 0x62, 0x2d, 0x0c, 0x08, 0xd7, 0xd4, 0x47,
	0x11, 0x33, 0xcf, 0xad, 0x71, 0x1d, 0x16, 0x98, 0x53, 0xa2, 0xb5, 0x0d, 0x4b, 0x75, 0x5e, 0x76,
	0x92, 0x73, 0xdc, 0xb3, 0x18, 0xae, 0xb2, 0x45, 0xdf, 0x4c, 0x8e, 0x1e, 0xf7, 0xad, 0xd8, 0x1c,
	0xeb, 0x87, 0xdc, 0x22, 0x0e, 0xe1, 0x77, 0x36, 0xda, 0x1f, 0x7f, 0x9b, 0x38, 0x84, 0xdd, 0xab,
	0xbe, 0x02, 0xf3, 0x8d, 0xee, 0x40, 0x3c, 0x2b, 0x17, 0xdf, 0xb7, 0x0d, 0xf1, 0x13, 0xa2, 0xa9,
	0x2d, 0x85, 0x1c, 0x39, 0xd4, 0x52, 0xd8, 0xa0, 0xe7, 0xa3, 0x78, 0xbe, 0x90, 0xf2, 0xa1, 0xfa,
	0xcf, 0x42, 0xae, 0xee, 0xbf, 0x02, 0x72, 0x8c, 0xdb, 0x14, 0x99, 0x09, 0x13, 0xe2, 0xa7, 0xb0,
	0xe4, 0x7a, 0x69, 0xd0, 0x23, 0xc3, 0xa2, 0xae, 0x9b, 0xd9, 0x0b, 0xdd, 0x2c, 0x72, 0xa3, 0x2d,
	0x6e, 0xc3, 0xa4, 0xc2, 0x0f, 0x08, 0x6e, 0x06, 0x4d, 0xdf, 0x0b, 0x4e, 0xd3, 0xaf, 0xdb, 0xc9,
	0xe9, 0x5f, 0xa0, 0x93, 0xc2, 0x06, 0xdc, 0x0c, 0x9a, 0x4f, 0xe3, 0x13, 0x15, 0x24, 0x58, 0xac,
	0xa9, 0x6d, 0x7d, 0x4b, 0x33, 0x1a, 0xe3, 0xea, 0x21, 0xc0, 0x42, 0xa3, 0xe7, 0x50, 0x5b, 0x71,
	0x0c, 0xc5, 0x56, 0xdb, 0xee, 0x48, 0x8d, 0xca, 0xf3, 0x5c, 0x58, 0x37, 0x98, 0x0b, 0xa1, 0x02,
	0xf1, 0x33, 0x57, 0xde, 0x14, 0xb8, 0x0a, 0x97, 0x59, 0xaa, 0x6a, 0xcb, 0xf3, 0x36, 0x7b, 0x4c,
	0x7b, 0x52, 0x0b, 0x5f, 0x87, 0x08, 0xf3, 0x42, 0x9c, 0xae, 0x45, 0x3d, 0x57, 0x67, 0x02, 0x41,
	0x86, 0x19, 0xd9, 0xd0, 0x68, 0x20, 0x90, 0x04, 0xcc, 0x3a, 0xaa, 0xa3, 0x51, 0x6f, 0xa6, 0xbb,
	0x0b, 0xbc, 0x0a, 0xf3, 0x2d, 0x6a, 0x37, 0x2d, 0xd5, 0x64, 0xac, 0xcb, 0x7b, 0x74, 0xfa, 0x45,
	0xc2, 0xdf, 0x20, 0xf5, 0xf7, 0x2e, 0xb5, 0x7a, 0x15, 0x8b, 0xe8, 0x0e, 0x69, 0x68, 0x94, 0x45,
	0x38, 0x1d, 0xc3, 0xf7, 0x00, 0x1f, 0x75, 0x35, 0x4d, 0xb1, 0xa8, 0x6d, 0x74, 0xad, 0x26, 0x55,
	0xfa, 0xe2, 0xc6, 0x99, 0x46, 0xf6, 0x14, 0x8c, 0x0f, 0x08, 0xfb, 0x90, 0x0e, 0xf4, 0xe5, 0xe5,
	0x2c, 0xc2, 0xac, 0xc5, 0x04, 0xde, 0xe8, 0xfb, 0x4d, 0x60, 0x5b, 0x99, 0x89, 0xec, 0xee, 0xcb,
	0x12, 0x48, 0x8d, 0xee, 0x32, 0x5e, 0x81, 0x65, 0x36, 0xaa, 0x8b, 0xbb, 0x95, 0x81, 0x49, 0x9d,
	0x80, 0xb8, 0xaf, 0x90, 0x6b, 0x45, 0x65, 0x2d, 0x5f, 0xd8, 0x88, 0xa3, 0x41, 0x69, 0x21, 0xbf,
	0xf1, 0x30, 0x3e, 0x95, 0xd5, 0xe0, 0xfa, 0xb8, 0x23, 0xca, 0xac, 0x02, 0xde, 0x02, 0x5f, 0x5a,
	0xdd, 0x29, 0xd5, 0xd6, 0x0a, 0xca, 0x53, 0x69, 0xb7, 0x1c, 0x47, 0x78, 0x15, 0xae, 0x73, 0x69,
	0xe5, 0xd9, 0xb3, 0xca, 0x6e, 0x59, 0x29, 0xc9, 0xe5, 0xed, 0xf2, 0x7e, 0x5d, 0x2a, 0xee, 0xd6,
	0xdc, 0x1d, 0x53, 0xd9, 0x7f, 0x41, 0x7a, 0xcc, 0x7c, 0xc5, 0x0b, 0x10, 0xe1, 0x0e, 0xf6, 0x9f,
	0xed, 0x97, 0xe3, 0x97, 0xf0, 0x35, 0xc0, 0x7c, 0xf9, 0xe2, 0x41, 0xfe, 0x91, 0x52, 0x2d, 0xef,
	0xf9, 0x71, 0x56, 0x60, 0x99, 0xcb, 0xe5, 0xe2, 0x73, 0xa5, 0x7a, 0xb0, 0xb5, 0x2b, 0x95, 0x94,
	0x9d, 0xf2, 0x61, 0x7c, 0xaa, 0xf0, 0xdd, 0x12, 0x4c, 0x4b, 0xc5, 0x3d, 0xfc, 0x19, 0x82, 0xe5,
	0x00, 0x2a, 0x81, 0xc5, 0x90, 0xaf, 0xa5, 0xdf, 0xfe, 0x54, 0x3e, 0xbc, 0x81, 0xdb, 0x63, 0xe1,
	0xfe, 0xff, 0xbe, 0xf9, 0xfe, 0xa3, 0xa9, 0x3b, 0xf8, 0x16, 0x23, 0xdc, 0xff, 0x65, 0xa7, 0xe5,
	0x89, 0xc7, 0x42, 0x6d, 0x31, 0xfb, 0x46, 0xb4, 0x07, 0x10, 0x7d, 0x8c, 0x60, 0x69, 0xe8, 0x41,
	0xc3, 0xf7, 0x03, 0xc3, 0x8e, 0x22, 0x25, 0xa9, 0x30, 0x3c, 0x48, 0x10, 0x39, 0xb0, 0xbb, 0xf8,
	0x4e, 0x10, 0xb0, 0x41, 0x5c, 0x62, 0xf6, 0x0d, 0xfe, 0x04, 0x41, 0x22, 0x68, 0x40, 0xe2, 0xe0,
	0xa2, 0x8c, 0x61, 0xb2, 0xe1, 0x00, 0xe6, 0x39, 0xc0, 0xac, 0x10, 0xae, 0x72, 0x9b, 0x28, 0x8b,
	0xdf, 0x21, 0x48, 0x1c, 0x98, 0xad, 0x61, 0x84, 0x61, 0xe2, 0x85, 0x03, 0x55, 0xe0, 0xa0, 0xee,
	0xa5, 0xc2, 0x56, 0x8d, 0xc1, 0xfa, 0x10, 0x41, 0x22, 0x68, 0xe0, 0x8e, 0x28, 0xdc, 0x18, 0xee,
	0x98, 0xba, 0x36, 0xf4, 0xa2, 0x95, 0xd9, 0x7f, 0x63, 0x7e, 0x33, 0xb3, 0xa1, 0x9b, 0xf9, 0x15,
	0x82, 0x6b, 0xc1, 0xbc, 0x0c, 0x17, 0x26, 0xa7, 0x90, 0xa9, 0xf5, 0x89, 0x6c, 0xbc, 0xab, 0xb1,
	0xc1, 0x41, 0xe7, 0xf0, 0xbd, 0x90, 0xa0, 0x45, 0x46, 0xf9, 0xf0, 0xe7, 0x08, 0x12, 0x41, 0x94,
	0x6f, 0x44, 0x35, 0xc7, 0xb0, 0xc3, 0x54, 0x48, 0xae, 0x29, 0xfc, 0x81, 0x03, 0xcd, 0xe3, 0x5c,
	0x38, 0xa0, 0x1c, 0x27, 0x2b, 0xf2, 0x17, 0x08, 0x56, 0x46, 0x50, 0x0a, 0xbc, 0x1e, 0xfa, 0xd2,
	0xfc, 0x0c, 0xc0, 0x7f, 0xe4, 0x80, 0xd7, 0x84, 0x89, 0x2a, 0xcb, 0x8e, 0xea, 0x7b, 0x04, 0x2b,
	0x23, 0xb8, 0xc1, 0x08, 0xc4, 0xe3, 0x99, 0xc4, 0xc8, 0x03, 0xeb, 0x95, 0x34, 0x3b, 0x69, 0x49,
	0xdf, 0x21, 0x98, 0xf3, 0xb9, 0x03, 0xfe, 0x7d, 0x70, 0x39, 0xce, 0xb3, 0x94, 0xd4, 0xad, 0x0b,
	0x76, 0x79, 0xa7, 0xf1, 0x31, 0x47, 0xf4, 0x40, 0xc8, 0x87, 0xbd, 0xd9, 0xb6, 0xe7, 0x81, 0xd5,
	0xed, 0x2d, 0x82, 0x68, 0x85, 0x3a, 0x12, 0xe9, 0x54, 0xf9, 0x6f, 0x2a, 0x58, 0xe8, 0x0f, 0xea,
	0x1e, 0xc3, 0x53, 0xa5, 0x0f, 0xec, 0xea, 0xc0, 0x1e, 0x57, 0x2b, 0xfc, 0x95, 0x03, 0xd9, 0x14,
	0x1e, 0x72, 0x20, 0x3e, 0xd1, 0xb8, 0x00, 0x4c, 0xbb, 0x3f, 0xf8, 0x07, 0x08, 0xa2, 0xb5, 0x71,
	0x68, 0x6a, 0xe1, 0xd1, 0x94, 0x38, 0x9a, 0x27, 0x93, 0xa1, 0xb1, 0xfb, 0xfc, 0xb3, 0xf2, 0x7c,
	0x89, 0x00, 0xd7, 0xa9, 0xcd, 0x85, 0xd4, 0xea, 0xa8, 0xb6, 0xad, 0x1a, 0xba, 0x8d, 0x33, 0x03,
	0x21, 0x87, 0xb7, 0xf8, 0xe0, 0xee, 0x86, 0xd8, 0xe9, 0xf5, 0x51, 0xe2, 0x80, 0x4b, 0xc2, 0x9f,
	0x27, 0x01, 0xec, 0x0c, 0xf9, 0x63, 0xb0, 0x3f, 0x45, 0xb0, 0x1c, 0xc0, 0xdf, 0x46, 0xd0, 0x86,
	0xd1, 0xac, 0x71, 0x04, 0x6d, 0x18, 0x43, 0x0d, 0x85, 0x0c, 0xcf, 0x42, 0x10, 0x6e, 0xb0, 0x2c,
	0x38, 0xf9, 0xdb, 0x7c, 0x35, 0xbc, 0x7d, 0x13, 0x65, 0xb7, 0x32, 0xb0, 0xd2, 0x34, 0x3a, 0x41,
	0x01, 0xb6, 0xe6, 0x58, 0x4a, 0xec, 0xde, 0x55, 0xd1, 0x8f, 0x08, 0x35, 0x2e, 0xf3, 0x3b, 0xb8,
	0xfe, 0x53, 0x00, 0x00, 0x00, 0xff, 0xff, 0xdf, 0xa1, 0xbb, 0xec, 0x02, 0x15, 0x00, 0x00,
}
