// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/servicecontrol/v1/operation.proto
// DO NOT EDIT!

package google_api_servicecontrol_v1 // import "google.golang.org/genproto/googleapis/api/servicecontrol/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf3 "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Defines the importance of the data contained in the operation.
type Operation_Importance int32

const (
	// The API implementation may cache and aggregate the data.
	// The data may be lost when rare and unexpected system failures occur.
	Operation_LOW Operation_Importance = 0
	// The API implementation doesn't cache and aggregate the data.
	// If the method returns successfully, it's guaranteed that the data has
	// been persisted in durable storage.
	Operation_HIGH Operation_Importance = 1
)

var Operation_Importance_name = map[int32]string{
	0: "LOW",
	1: "HIGH",
}
var Operation_Importance_value = map[string]int32{
	"LOW":  0,
	"HIGH": 1,
}

func (x Operation_Importance) String() string {
	return proto.EnumName(Operation_Importance_name, int32(x))
}
func (Operation_Importance) EnumDescriptor() ([]byte, []int) { return fileDescriptor4, []int{0, 0} }

// Represents information regarding an operation.
type Operation struct {
	// Identity of the operation. This must be unique within the scope of the
	// service that generated the operation. If the service calls
	// Check() and Report() on the same operation, the two calls should carry
	// the same id.
	//
	// UUID version 4 is recommended, though not required.
	// In scenarios where an operation is computed from existing information
	// and an idempotent id is desirable for deduplication purpose, UUID version 5
	// is recommended. See RFC 4122 for details.
	OperationId string `protobuf:"bytes,1,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
	// Fully qualified name of the operation. Reserved for future use.
	OperationName string `protobuf:"bytes,2,opt,name=operation_name,json=operationName" json:"operation_name,omitempty"`
	// Identity of the consumer who is using the service.
	// This field should be filled in for the operations initiated by a
	// consumer, but not for service-initiated operations that are
	// not related to a specific consumer.
	//
	// This can be in one of the following formats:
	//   project:<project_id>,
	//   project_number:<project_number>,
	//   api_key:<api_key>.
	ConsumerId string `protobuf:"bytes,3,opt,name=consumer_id,json=consumerId" json:"consumer_id,omitempty"`
	// Required. Start time of the operation.
	StartTime *google_protobuf3.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// End time of the operation.
	// Required when the operation is used in [ServiceController.Report][google.api.servicecontrol.v1.ServiceController.Report],
	// but optional when the operation is used in [ServiceController.Check][google.api.servicecontrol.v1.ServiceController.Check].
	EndTime *google_protobuf3.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// Labels describing the operation. Only the following labels are allowed:
	//
	// - Labels describing monitored resources as defined in
	//   the service configuration.
	// - Default labels of metric values. When specified, labels defined in the
	//   metric value override these default.
	// - The following labels defined by Google Cloud Platform:
	//     - `cloud.googleapis.com/location` describing the location where the
	//        operation happened,
	//     - `servicecontrol.googleapis.com/user_agent` describing the user agent
	//        of the API request,
	//     - `servicecontrol.googleapis.com/service_agent` describing the service
	//        used to handle the API request (e.g. ESP),
	//     - `servicecontrol.googleapis.com/platform` describing the platform
	//        where the API is served (e.g. GAE, GCE, GKE).
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Represents information about this operation. Each MetricValueSet
	// corresponds to a metric defined in the service configuration.
	// The data type used in the MetricValueSet must agree with
	// the data type specified in the metric definition.
	//
	// Within a single operation, it is not allowed to have more than one
	// MetricValue instances that have the same metric names and identical
	// label value combinations. If a request has such duplicated MetricValue
	// instances, the entire request is rejected with
	// an invalid argument error.
	MetricValueSets []*MetricValueSet `protobuf:"bytes,7,rep,name=metric_value_sets,json=metricValueSets" json:"metric_value_sets,omitempty"`
	// Represents information to be logged.
	LogEntries []*LogEntry `protobuf:"bytes,8,rep,name=log_entries,json=logEntries" json:"log_entries,omitempty"`
	// DO NOT USE. This is an experimental field.
	Importance Operation_Importance `protobuf:"varint,11,opt,name=importance,enum=google.api.servicecontrol.v1.Operation_Importance" json:"importance,omitempty"`
}

func (m *Operation) Reset()                    { *m = Operation{} }
func (m *Operation) String() string            { return proto.CompactTextString(m) }
func (*Operation) ProtoMessage()               {}
func (*Operation) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{0} }

func (m *Operation) GetStartTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Operation) GetEndTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *Operation) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Operation) GetMetricValueSets() []*MetricValueSet {
	if m != nil {
		return m.MetricValueSets
	}
	return nil
}

func (m *Operation) GetLogEntries() []*LogEntry {
	if m != nil {
		return m.LogEntries
	}
	return nil
}

func init() {
	proto.RegisterType((*Operation)(nil), "google.api.servicecontrol.v1.Operation")
	proto.RegisterEnum("google.api.servicecontrol.v1.Operation_Importance", Operation_Importance_name, Operation_Importance_value)
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/servicecontrol/v1/operation.proto", fileDescriptor4)
}

var fileDescriptor4 = []byte{
	// 495 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xa4, 0x92, 0x5f, 0x6f, 0xd3, 0x3c,
	0x14, 0xc6, 0xdf, 0xac, 0xeb, 0xbf, 0x93, 0x97, 0x52, 0x2c, 0x2e, 0xa2, 0x0a, 0x69, 0x65, 0x12,
	0xa8, 0x17, 0xc8, 0xd6, 0x3a, 0x21, 0x18, 0xdc, 0x4d, 0x42, 0x5b, 0xb5, 0xb2, 0x4d, 0x01, 0x01,
	0x77, 0x95, 0x9b, 0x9e, 0x05, 0x8b, 0xd8, 0x8e, 0x6c, 0xb7, 0x52, 0xbf, 0x01, 0x1f, 0x99, 0x4b,
	0x14, 0x27, 0x4d, 0xbb, 0x9b, 0x82, 0xd8, 0x9d, 0xed, 0x9c, 0xe7, 0x77, 0x9e, 0x3c, 0xe7, 0xc0,
	0x55, 0xaa, 0x75, 0x9a, 0x21, 0x4d, 0x75, 0xc6, 0x55, 0x4a, 0xb5, 0x49, 0x59, 0x8a, 0x2a, 0x37,
	0xda, 0x69, 0x56, 0x7e, 0xe2, 0xb9, 0xb0, 0x8c, 0xe7, 0x82, 0x59, 0x34, 0x2b, 0x91, 0x60, 0xa2,
	0x95, 0x33, 0x3a, 0x63, 0xab, 0x13, 0xa6, 0x73, 0x34, 0xdc, 0x09, 0xad, 0xa8, 0x17, 0x90, 0x67,
	0x15, 0x8c, 0xe7, 0x82, 0xde, 0xaf, 0xa6, 0xab, 0x93, 0xc1, 0xe4, 0x5f, 0x5a, 0xdd, 0x89, 0x94,
	0x71, 0xa5, 0xb4, 0xf3, 0x7d, 0x6c, 0xd9, 0x68, 0xf0, 0x20, 0xd7, 0x99, 0x4e, 0x67, 0xa8, 0x9c,
	0x59, 0x57, 0xb0, 0xeb, 0x87, 0xc0, 0x24, 0x3a, 0x23, 0x92, 0xd9, 0x8a, 0x67, 0x4b, 0xac, 0x78,
	0xef, 0x53, 0xe1, 0xbe, 0x2f, 0xe7, 0x34, 0xd1, 0x92, 0x95, 0x4c, 0xe6, 0x3f, 0xcc, 0x97, 0x77,
	0x2c, 0x77, 0xeb, 0x1c, 0x2d, 0x73, 0x42, 0xa2, 0x75, 0x5c, 0xe6, 0xdb, 0x53, 0x29, 0x3e, 0xfe,
	0xd9, 0x84, 0xee, 0xcd, 0x26, 0x56, 0xf2, 0x1c, 0xfe, 0xaf, 0x33, 0x9e, 0x89, 0x45, 0x14, 0x0c,
	0x83, 0x51, 0x37, 0x0e, 0xeb, 0xb7, 0xc9, 0x82, 0xbc, 0x80, 0xde, 0xb6, 0x44, 0x71, 0x89, 0xd1,
	0x81, 0x2f, 0x7a, 0x54, 0xbf, 0x5e, 0x73, 0x89, 0xe4, 0x08, 0xc2, 0x44, 0x2b, 0xbb, 0x94, 0x68,
	0x0a, 0x50, 0xc3, 0xd7, 0xc0, 0xe6, 0x69, 0xb2, 0x20, 0x67, 0x00, 0xd6, 0x71, 0xe3, 0x66, 0x85,
	0xa3, 0xe8, 0x70, 0x18, 0x8c, 0xc2, 0xf1, 0x80, 0x56, 0xd1, 0x6c, 0xfc, 0xd3, 0xcf, 0x1b, 0xbb,
	0x71, 0xd7, 0x57, 0x17, 0x77, 0xf2, 0x1a, 0x3a, 0xa8, 0x16, 0xa5, 0xb0, 0xf9, 0x47, 0x61, 0x1b,
	0xd5, 0xc2, 0xcb, 0xae, 0xa0, 0x95, 0xf1, 0x39, 0x66, 0x36, 0x6a, 0x0d, 0x1b, 0xa3, 0x70, 0x7c,
	0x4a, 0xf7, 0xad, 0x0f, 0xad, 0x53, 0xa1, 0x53, 0xaf, 0xfa, 0x50, 0x8c, 0x30, 0xae, 0x10, 0xe4,
	0x1b, 0x3c, 0xd9, 0x1d, 0xc5, 0xcc, 0xa2, 0xb3, 0x51, 0xdb, 0x73, 0x5f, 0xed, 0xe7, 0x7e, 0xf4,
	0xb2, 0x2f, 0x85, 0xea, 0x13, 0xba, 0xf8, 0xb1, 0xbc, 0x77, 0xb7, 0xe4, 0x02, 0xc2, 0xcd, 0xc6,
	0x08, 0xb4, 0x51, 0xc7, 0x33, 0x5f, 0xee, 0x67, 0x4e, 0x75, 0x5a, 0xda, 0x83, 0xac, 0x3c, 0x09,
	0xb4, 0x24, 0x06, 0x10, 0x32, 0xd7, 0xc6, 0x71, 0x95, 0x60, 0x14, 0x0e, 0x83, 0x51, 0x6f, 0x3c,
	0xfe, 0xdb, 0x7f, 0x9e, 0xd4, 0xca, 0x78, 0x87, 0x32, 0x38, 0x83, 0x70, 0x27, 0x0d, 0xd2, 0x87,
	0xc6, 0x0f, 0x5c, 0x57, 0x6b, 0x52, 0x1c, 0xc9, 0x53, 0x68, 0xfa, 0x40, 0xaa, 0xad, 0x28, 0x2f,
	0xef, 0x0e, 0xde, 0x06, 0xc7, 0x47, 0x00, 0x5b, 0x28, 0x69, 0x43, 0x63, 0x7a, 0xf3, 0xb5, 0xff,
	0x1f, 0xe9, 0xc0, 0xe1, 0xe5, 0xe4, 0xe2, 0xb2, 0x1f, 0x9c, 0xbf, 0x81, 0x61, 0xa2, 0xe5, 0x5e,
	0x83, 0xe7, 0xbd, 0xda, 0xe1, 0x6d, 0x31, 0xe9, 0xdb, 0xe0, 0x57, 0x10, 0xcc, 0x5b, 0x7e, 0xea,
	0xa7, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0x89, 0xb4, 0x10, 0x3f, 0x5c, 0x04, 0x00, 0x00,
}
