// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package gamelift provides a client for Amazon GameLift.
package gamelift

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a request for the CreateAlias operation.
func (c *GameLift) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *CreateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateAliasOutput{}
	req.Data = output
	return
}

// Creates an alias for a fleet. You can use an alias to anonymize your fleet
// by referencing an alias instead of a specific fleet when you create game
// sessions. Amazon GameLift supports two types of routing strategies for aliases:
// simple and terminal. Use a simple alias to point to an active fleet. Use
// a terminal alias to display a message to incoming traffic instead of routing
// players to an active fleet. This option is useful when a game server is no
// longer supported but you want to provide better messaging than a standard
// 404 error.
//
// To create a fleet alias, specify an alias name, routing strategy, and optional
// description. If successful, a new alias record is returned, including an
// alias ID, which you can reference when creating a game session. To reassign
// the alias to another fleet ID, call UpdateAlias.
func (c *GameLift) CreateAlias(input *CreateAliasInput) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	err := req.Send()
	return out, err
}

const opCreateBuild = "CreateBuild"

// CreateBuildRequest generates a request for the CreateBuild operation.
func (c *GameLift) CreateBuildRequest(input *CreateBuildInput) (req *request.Request, output *CreateBuildOutput) {
	op := &request.Operation{
		Name:       opCreateBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBuildInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateBuildOutput{}
	req.Data = output
	return
}

// Initializes a new build record and generates information required to upload
// a game build to Amazon GameLift. Once the build record has been created and
// is in an INITIALIZED state, you can upload your game build.
//
// To create a build, use the CLI command upload-build, which creates a new
// build record and uploads the build files in one step. (See the Amazon GameLift
// Developer Guide (http://docs.aws.amazon.com/gamelift/latest/developerguide/)
// for more details on the CLI and the upload process.) Call the CreateBuild
// action only if you have your own Amazon Simple Storage Service (Amazon S3)
// client and need to manually upload your build files.
//
// To create a new build, optionally specify a build name and version. This
// metadata is stored with other properties in the build record and is displayed
// in the GameLift console (but not visible to players). If successful, this
// action returns the newly created build record along with an Amazon S3 storage
// location and AWS account credentials. Use the location and credentials to
// upload your game build.
func (c *GameLift) CreateBuild(input *CreateBuildInput) (*CreateBuildOutput, error) {
	req, out := c.CreateBuildRequest(input)
	err := req.Send()
	return out, err
}

const opCreateFleet = "CreateFleet"

// CreateFleetRequest generates a request for the CreateFleet operation.
func (c *GameLift) CreateFleetRequest(input *CreateFleetInput) (req *request.Request, output *CreateFleetOutput) {
	op := &request.Operation{
		Name:       opCreateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFleetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateFleetOutput{}
	req.Data = output
	return
}

// Creates a new fleet to host game servers. A fleet consists of a set of Amazon
// Elastic Compute Cloud (Amazon EC2) instances of a certain type, which defines
// the CPU, memory, storage, and networking capacity of each host in the fleet.
// See Amazon EC2 Instance Types (https://aws.amazon.com/ec2/instance-types/)
// for more information. Each instance in the fleet hosts a game server created
// from the specified game build. Once a fleet is in an ACTIVE state, it can
// begin hosting game sessions.
//
// To create a new fleet, provide a name and the EC2 instance type for the
// new fleet, and specify the build and server launch path. Builds must be in
// a READY state before they can be used to build fleets. When configuring the
// new fleet, you can optionally (1) provide a set of launch parameters to be
// passed to a game server when activated; (2) limit incoming traffic to a specified
// range of IP addresses and port numbers; (3) set game session protection for
// all instances in the fleet, and (4) configure Amazon GameLift to store game
// session logs by specifying the path to the logs stored in your game server
// files. If the call is successful, Amazon GameLift performs the following
// tasks:
//
//  Creates a fleet record and sets the state to NEW. Sets the fleet's capacity
// to 1 "desired" and 1 "active" EC2 instance count. Creates an EC2 instance
// and begins the process of initializing the fleet and activating a game server
// on the instance. Begins writing events to the fleet event log, which can
// be accessed in the GameLift console.  Once a fleet is created, use the following
// actions to change certain fleet properties (server launch parameters and
// log paths cannot be changed):
//
//   UpdateFleetAttributes -- Update fleet metadata, including name and description.
//  UpdateFleetCapacity -- Increase or decrease the number of instances you
// want the fleet to maintain.  UpdateFleetPortSettings -- Change the IP addresses
// and ports that allow access to incoming traffic.
func (c *GameLift) CreateFleet(input *CreateFleetInput) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	err := req.Send()
	return out, err
}

const opCreateGameSession = "CreateGameSession"

// CreateGameSessionRequest generates a request for the CreateGameSession operation.
func (c *GameLift) CreateGameSessionRequest(input *CreateGameSessionInput) (req *request.Request, output *CreateGameSessionOutput) {
	op := &request.Operation{
		Name:       opCreateGameSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGameSessionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateGameSessionOutput{}
	req.Data = output
	return
}

// Creates a multiplayer game session for players. This action creates a game
// session record and assigns the new session to an instance in the specified
// fleet, which activates the server initialization process in your game server.
// A fleet must be in an ACTIVE state before a game session can be created for
// it.
//
// To create a game session, specify either a fleet ID or an alias ID and indicate
// the maximum number of players the game session allows. You can also provide
// a name and a set of properties for your game (optional). If successful, a
// GameSession object is returned containing session properties, including an
// IP address. By default, newly created game sessions are set to accept adding
// any new players to the game session. Use UpdateGameSession to change the
// creation policy.
func (c *GameLift) CreateGameSession(input *CreateGameSessionInput) (*CreateGameSessionOutput, error) {
	req, out := c.CreateGameSessionRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePlayerSession = "CreatePlayerSession"

// CreatePlayerSessionRequest generates a request for the CreatePlayerSession operation.
func (c *GameLift) CreatePlayerSessionRequest(input *CreatePlayerSessionInput) (req *request.Request, output *CreatePlayerSessionOutput) {
	op := &request.Operation{
		Name:       opCreatePlayerSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlayerSessionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreatePlayerSessionOutput{}
	req.Data = output
	return
}

// Adds a player to a game session and creates a player session record. A game
// session must be in an ACTIVE state, have a creation policy of ALLOW_ALL,
// and have an open player slot before players can be added to the session.
//
// To create a player session, specify a game session ID and player ID. If
// successful, the player is added to the game session and a new PlayerSession
// object is returned.
func (c *GameLift) CreatePlayerSession(input *CreatePlayerSessionInput) (*CreatePlayerSessionOutput, error) {
	req, out := c.CreatePlayerSessionRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePlayerSessions = "CreatePlayerSessions"

// CreatePlayerSessionsRequest generates a request for the CreatePlayerSessions operation.
func (c *GameLift) CreatePlayerSessionsRequest(input *CreatePlayerSessionsInput) (req *request.Request, output *CreatePlayerSessionsOutput) {
	op := &request.Operation{
		Name:       opCreatePlayerSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlayerSessionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreatePlayerSessionsOutput{}
	req.Data = output
	return
}

// Adds a group of players to a game session. Similar to CreatePlayerSession,
// this action allows you to add multiple players in a single call, which is
// useful for games that provide party and/or matchmaking features. A game session
// must be in an ACTIVE state, have a creation policy of ALLOW_ALL, and have
// an open player slot before players can be added to the session.
//
// To create player sessions, specify a game session ID and a list of player
// IDs. If successful, the players are added to the game session and a set of
// new PlayerSession objects is returned.
func (c *GameLift) CreatePlayerSessions(input *CreatePlayerSessionsInput) (*CreatePlayerSessionsOutput, error) {
	req, out := c.CreatePlayerSessionsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAlias = "DeleteAlias"

// DeleteAliasRequest generates a request for the DeleteAlias operation.
func (c *GameLift) DeleteAliasRequest(input *DeleteAliasInput) (req *request.Request, output *DeleteAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAliasInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteAliasOutput{}
	req.Data = output
	return
}

// Deletes an alias. This action removes all record of the alias; game clients
// attempting to access a game server using the deleted alias receive an error.
// To delete an alias, specify the alias ID to be deleted.
func (c *GameLift) DeleteAlias(input *DeleteAliasInput) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBuild = "DeleteBuild"

// DeleteBuildRequest generates a request for the DeleteBuild operation.
func (c *GameLift) DeleteBuildRequest(input *DeleteBuildInput) (req *request.Request, output *DeleteBuildOutput) {
	op := &request.Operation{
		Name:       opDeleteBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBuildInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteBuildOutput{}
	req.Data = output
	return
}

// Deletes a build. This action permanently deletes the build record and any
// uploaded build files.
//
// To delete a build, specify its ID. Deleting a build does not affect the
// status of any active fleets, but you can no longer create new fleets for
// the deleted build.
func (c *GameLift) DeleteBuild(input *DeleteBuildInput) (*DeleteBuildOutput, error) {
	req, out := c.DeleteBuildRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteFleet = "DeleteFleet"

// DeleteFleetRequest generates a request for the DeleteFleet operation.
func (c *GameLift) DeleteFleetRequest(input *DeleteFleetInput) (req *request.Request, output *DeleteFleetOutput) {
	op := &request.Operation{
		Name:       opDeleteFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFleetInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteFleetOutput{}
	req.Data = output
	return
}

// Deletes everything related to a fleet. Before deleting a fleet, you must
// set the fleet's desired capacity to zero. See UpdateFleetCapacity.
//
// This action removes the fleet's resources and the fleet record. Once a fleet
// is deleted, you can no longer use that fleet.
func (c *GameLift) DeleteFleet(input *DeleteFleetInput) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteScalingPolicy = "DeleteScalingPolicy"

// DeleteScalingPolicyRequest generates a request for the DeleteScalingPolicy operation.
func (c *GameLift) DeleteScalingPolicyRequest(input *DeleteScalingPolicyInput) (req *request.Request, output *DeleteScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScalingPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteScalingPolicyOutput{}
	req.Data = output
	return
}

// Deletes a fleet scaling policy. This action means that the policy is no longer
// in force and removes all record of it. To delete a scaling policy, specify
// both the scaling policy name and the fleet ID it is associated with.
func (c *GameLift) DeleteScalingPolicy(input *DeleteScalingPolicyInput) (*DeleteScalingPolicyOutput, error) {
	req, out := c.DeleteScalingPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAlias = "DescribeAlias"

// DescribeAliasRequest generates a request for the DescribeAlias operation.
func (c *GameLift) DescribeAliasRequest(input *DescribeAliasInput) (req *request.Request, output *DescribeAliasOutput) {
	op := &request.Operation{
		Name:       opDescribeAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAliasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAliasOutput{}
	req.Data = output
	return
}

// Retrieves properties for a specified alias. To get the alias, specify an
// alias ID. If successful, an Alias object is returned.
func (c *GameLift) DescribeAlias(input *DescribeAliasInput) (*DescribeAliasOutput, error) {
	req, out := c.DescribeAliasRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeBuild = "DescribeBuild"

// DescribeBuildRequest generates a request for the DescribeBuild operation.
func (c *GameLift) DescribeBuildRequest(input *DescribeBuildInput) (req *request.Request, output *DescribeBuildOutput) {
	op := &request.Operation{
		Name:       opDescribeBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBuildInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeBuildOutput{}
	req.Data = output
	return
}

// Retrieves properties for a build. To get a build record, specify a build
// ID. If successful, an object containing the build properties is returned.
func (c *GameLift) DescribeBuild(input *DescribeBuildInput) (*DescribeBuildOutput, error) {
	req, out := c.DescribeBuildRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeEC2InstanceLimits = "DescribeEC2InstanceLimits"

// DescribeEC2InstanceLimitsRequest generates a request for the DescribeEC2InstanceLimits operation.
func (c *GameLift) DescribeEC2InstanceLimitsRequest(input *DescribeEC2InstanceLimitsInput) (req *request.Request, output *DescribeEC2InstanceLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeEC2InstanceLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEC2InstanceLimitsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEC2InstanceLimitsOutput{}
	req.Data = output
	return
}

// Retrieves the following information for the specified EC2 instance type:
//
//  maximum number of instances allowed per AWS account (service limit) current
// usage level for the AWS account   Service limits vary depending on region.
// Available regions for GameLift can be found in the AWS Management Console
// for GameLift (see the drop-down list in the upper right corner).
func (c *GameLift) DescribeEC2InstanceLimits(input *DescribeEC2InstanceLimitsInput) (*DescribeEC2InstanceLimitsOutput, error) {
	req, out := c.DescribeEC2InstanceLimitsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeFleetAttributes = "DescribeFleetAttributes"

// DescribeFleetAttributesRequest generates a request for the DescribeFleetAttributes operation.
func (c *GameLift) DescribeFleetAttributesRequest(input *DescribeFleetAttributesInput) (req *request.Request, output *DescribeFleetAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeFleetAttributesOutput{}
	req.Data = output
	return
}

// Retrieves fleet properties, including metadata, status, and configuration,
// for one or more fleets. You can request attributes for all fleets, or specify
// a list of one or more fleet IDs. When requesting all fleets, use the pagination
// parameters to retrieve results as a set of sequential pages. If successful,
// a FleetAttributes object is returned for each requested fleet ID. When specifying
// a list of fleet IDs, attribute objects are returned only for fleets that
// currently exist.
//
// Some API actions may limit the number of fleet IDs allowed in one request.
// If a request exceeds this limit, the request fails and the error message
// includes the maximum allowed.
func (c *GameLift) DescribeFleetAttributes(input *DescribeFleetAttributesInput) (*DescribeFleetAttributesOutput, error) {
	req, out := c.DescribeFleetAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeFleetCapacity = "DescribeFleetCapacity"

// DescribeFleetCapacityRequest generates a request for the DescribeFleetCapacity operation.
func (c *GameLift) DescribeFleetCapacityRequest(input *DescribeFleetCapacityInput) (req *request.Request, output *DescribeFleetCapacityOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetCapacity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetCapacityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeFleetCapacityOutput{}
	req.Data = output
	return
}

// Retrieves the current status of fleet capacity for one or more fleets. This
// information includes the number of instances that have been requested for
// the fleet and the number currently active. You can request capacity for all
// fleets, or specify a list of one or more fleet IDs. When requesting all fleets,
// use the pagination parameters to retrieve results as a set of sequential
// pages. If successful, a FleetCapacity object is returned for each requested
// fleet ID. When specifying a list of fleet IDs, attribute objects are returned
// only for fleets that currently exist.
//
// Some API actions may limit the number of fleet IDs allowed in one request.
// If a request exceeds this limit, the request fails and the error message
// includes the maximum allowed.
func (c *GameLift) DescribeFleetCapacity(input *DescribeFleetCapacityInput) (*DescribeFleetCapacityOutput, error) {
	req, out := c.DescribeFleetCapacityRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeFleetEvents = "DescribeFleetEvents"

// DescribeFleetEventsRequest generates a request for the DescribeFleetEvents operation.
func (c *GameLift) DescribeFleetEventsRequest(input *DescribeFleetEventsInput) (req *request.Request, output *DescribeFleetEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetEventsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeFleetEventsOutput{}
	req.Data = output
	return
}

// Retrieves entries from the fleet event log. You can specify a time range
// to limit the result set. Use the pagination parameters to retrieve results
// as a set of sequential pages. If successful, a collection of event log entries
// matching the request are returned.
func (c *GameLift) DescribeFleetEvents(input *DescribeFleetEventsInput) (*DescribeFleetEventsOutput, error) {
	req, out := c.DescribeFleetEventsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeFleetPortSettings = "DescribeFleetPortSettings"

// DescribeFleetPortSettingsRequest generates a request for the DescribeFleetPortSettings operation.
func (c *GameLift) DescribeFleetPortSettingsRequest(input *DescribeFleetPortSettingsInput) (req *request.Request, output *DescribeFleetPortSettingsOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetPortSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetPortSettingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeFleetPortSettingsOutput{}
	req.Data = output
	return
}

// Retrieves the port settings for a fleet. Port settings are used to limit
// incoming traffic access to game servers in the fleet. To get a fleet's port
// settings, specify a fleet ID. If successful, an IpPermission object is returned
// for the requested fleet ID. If the requested fleet has been deleted, the
// result set will be empty.
func (c *GameLift) DescribeFleetPortSettings(input *DescribeFleetPortSettingsInput) (*DescribeFleetPortSettingsOutput, error) {
	req, out := c.DescribeFleetPortSettingsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeFleetUtilization = "DescribeFleetUtilization"

// DescribeFleetUtilizationRequest generates a request for the DescribeFleetUtilization operation.
func (c *GameLift) DescribeFleetUtilizationRequest(input *DescribeFleetUtilizationInput) (req *request.Request, output *DescribeFleetUtilizationOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetUtilization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetUtilizationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeFleetUtilizationOutput{}
	req.Data = output
	return
}

// Retrieves utilization statistics for one or more fleets. You can request
// utilization data for all fleets, or specify a list of one or more fleet IDs.
// When requesting all fleets, use the pagination parameters to retrieve results
// as a set of sequential pages. If successful, a FleetUtilization object is
// returned for each requested fleet ID. When specifying a list of fleet IDs,
// utilization objects are returned only for fleets that currently exist.
//
// Some API actions may limit the number of fleet IDs allowed in one request.
// If a request exceeds this limit, the request fails and the error message
// includes the maximum allowed.
func (c *GameLift) DescribeFleetUtilization(input *DescribeFleetUtilizationInput) (*DescribeFleetUtilizationOutput, error) {
	req, out := c.DescribeFleetUtilizationRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeGameSessionDetails = "DescribeGameSessionDetails"

// DescribeGameSessionDetailsRequest generates a request for the DescribeGameSessionDetails operation.
func (c *GameLift) DescribeGameSessionDetailsRequest(input *DescribeGameSessionDetailsInput) (req *request.Request, output *DescribeGameSessionDetailsOutput) {
	op := &request.Operation{
		Name:       opDescribeGameSessionDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameSessionDetailsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeGameSessionDetailsOutput{}
	req.Data = output
	return
}

// Retrieves properties, including the protection policy in force, for one or
// more game sessions. This action can be used in several ways: (1) provide
// a GameSessionId to request details for a specific game session; (2) provide
// either a FleetId or an AliasId to request properties for all game sessions
// running on a fleet.
//
// To get game session record(s), specify just one of the following: game session
// ID, fleet ID, or alias ID. You can filter this request by game session status.
// Use the pagination parameters to retrieve results as a set of sequential
// pages. If successful, a GameSessionDetail object is returned for each session
// matching the request.
func (c *GameLift) DescribeGameSessionDetails(input *DescribeGameSessionDetailsInput) (*DescribeGameSessionDetailsOutput, error) {
	req, out := c.DescribeGameSessionDetailsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeGameSessions = "DescribeGameSessions"

// DescribeGameSessionsRequest generates a request for the DescribeGameSessions operation.
func (c *GameLift) DescribeGameSessionsRequest(input *DescribeGameSessionsInput) (req *request.Request, output *DescribeGameSessionsOutput) {
	op := &request.Operation{
		Name:       opDescribeGameSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameSessionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeGameSessionsOutput{}
	req.Data = output
	return
}

// Retrieves properties for one or more game sessions. This action can be used
// in several ways: (1) provide a GameSessionId to request properties for a
// specific game session; (2) provide a FleetId or an AliasId to request properties
// for all game sessions running on a fleet.
//
// To get game session record(s), specify just one of the following: game session
// ID, fleet ID, or alias ID. You can filter this request by game session status.
// Use the pagination parameters to retrieve results as a set of sequential
// pages. If successful, a GameSession object is returned for each session matching
// the request.
func (c *GameLift) DescribeGameSessions(input *DescribeGameSessionsInput) (*DescribeGameSessionsOutput, error) {
	req, out := c.DescribeGameSessionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribePlayerSessions = "DescribePlayerSessions"

// DescribePlayerSessionsRequest generates a request for the DescribePlayerSessions operation.
func (c *GameLift) DescribePlayerSessionsRequest(input *DescribePlayerSessionsInput) (req *request.Request, output *DescribePlayerSessionsOutput) {
	op := &request.Operation{
		Name:       opDescribePlayerSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePlayerSessionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribePlayerSessionsOutput{}
	req.Data = output
	return
}

// Retrieves properties for one or more player sessions. This action can be
// used in several ways: (1) provide a PlayerSessionId parameter to request
// properties for a specific player session; (2) provide a GameSessionId parameter
// to request properties for all player sessions in the specified game session;
// (3) provide a PlayerId parameter to request properties for all player sessions
// of a specified player.
//
// To get game session record(s), specify only one of the following: a player
// session ID, a game session ID, or a player ID. You can filter this request
// by player session status. Use the pagination parameters to retrieve results
// as a set of sequential pages. If successful, a PlayerSession object is returned
// for each session matching the request.
func (c *GameLift) DescribePlayerSessions(input *DescribePlayerSessionsInput) (*DescribePlayerSessionsOutput, error) {
	req, out := c.DescribePlayerSessionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeScalingPolicies = "DescribeScalingPolicies"

// DescribeScalingPoliciesRequest generates a request for the DescribeScalingPolicies operation.
func (c *GameLift) DescribeScalingPoliciesRequest(input *DescribeScalingPoliciesInput) (req *request.Request, output *DescribeScalingPoliciesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScalingPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeScalingPoliciesOutput{}
	req.Data = output
	return
}

// Retrieves all scaling policies applied to a fleet.
//
// To get a fleet's scaling policies, specify the fleet ID. You can filter
// this request by policy status, such as to retrieve only active scaling policies.
// Use the pagination parameters to retrieve results as a set of sequential
// pages. If successful, set of ScalingPolicy objects is returned for the fleet.
func (c *GameLift) DescribeScalingPolicies(input *DescribeScalingPoliciesInput) (*DescribeScalingPoliciesOutput, error) {
	req, out := c.DescribeScalingPoliciesRequest(input)
	err := req.Send()
	return out, err
}

const opGetGameSessionLogUrl = "GetGameSessionLogUrl"

// GetGameSessionLogUrlRequest generates a request for the GetGameSessionLogUrl operation.
func (c *GameLift) GetGameSessionLogUrlRequest(input *GetGameSessionLogUrlInput) (req *request.Request, output *GetGameSessionLogUrlOutput) {
	op := &request.Operation{
		Name:       opGetGameSessionLogUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGameSessionLogUrlInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetGameSessionLogUrlOutput{}
	req.Data = output
	return
}

// Retrieves the location of stored game session logs for a specified game session.
// When a game session is terminated, Amazon GameLift automatically stores the
// logs in Amazon S3. Use this URL to download the logs.
//
// See the AWS Service Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_gamelift)
// page for maximum log file sizes. Log files that exceed this limit are not
// saved.
func (c *GameLift) GetGameSessionLogUrl(input *GetGameSessionLogUrlInput) (*GetGameSessionLogUrlOutput, error) {
	req, out := c.GetGameSessionLogUrlRequest(input)
	err := req.Send()
	return out, err
}

const opListAliases = "ListAliases"

// ListAliasesRequest generates a request for the ListAliases operation.
func (c *GameLift) ListAliasesRequest(input *ListAliasesInput) (req *request.Request, output *ListAliasesOutput) {
	op := &request.Operation{
		Name:       opListAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAliasesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAliasesOutput{}
	req.Data = output
	return
}

// Retrieves a collection of alias records for this AWS account. You can filter
// the result set by alias name and/or routing strategy type. Use the pagination
// parameters to retrieve results in sequential pages.
//
// Aliases are not listed in any particular order.
func (c *GameLift) ListAliases(input *ListAliasesInput) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	err := req.Send()
	return out, err
}

const opListBuilds = "ListBuilds"

// ListBuildsRequest generates a request for the ListBuilds operation.
func (c *GameLift) ListBuildsRequest(input *ListBuildsInput) (req *request.Request, output *ListBuildsOutput) {
	op := &request.Operation{
		Name:       opListBuilds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBuildsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListBuildsOutput{}
	req.Data = output
	return
}

// Retrieves build records for all builds associated with an AWS account. You
// can filter the result set by build status. Use the pagination parameters
// to retrieve results in a set of sequential pages.
//
// Build records are not listed in any particular order.
func (c *GameLift) ListBuilds(input *ListBuildsInput) (*ListBuildsOutput, error) {
	req, out := c.ListBuildsRequest(input)
	err := req.Send()
	return out, err
}

const opListFleets = "ListFleets"

// ListFleetsRequest generates a request for the ListFleets operation.
func (c *GameLift) ListFleetsRequest(input *ListFleetsInput) (req *request.Request, output *ListFleetsOutput) {
	op := &request.Operation{
		Name:       opListFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListFleetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListFleetsOutput{}
	req.Data = output
	return
}

// Retrieves a collection of fleet records for this AWS account. You can filter
// the result set by build ID. Use the pagination parameters to retrieve results
// in sequential pages.
//
// Fleet records are not listed in any particular order.
func (c *GameLift) ListFleets(input *ListFleetsInput) (*ListFleetsOutput, error) {
	req, out := c.ListFleetsRequest(input)
	err := req.Send()
	return out, err
}

const opPutScalingPolicy = "PutScalingPolicy"

// PutScalingPolicyRequest generates a request for the PutScalingPolicy operation.
func (c *GameLift) PutScalingPolicyRequest(input *PutScalingPolicyInput) (req *request.Request, output *PutScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opPutScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScalingPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutScalingPolicyOutput{}
	req.Data = output
	return
}

// Creates or updates a scaling policy for a fleet. An active scaling policy
// prompts GameLift to track a certain metric for a fleet and automatically
// change the fleet's capacity in specific circumstances. Each scaling policy
// contains one rule statement. Fleets can have multiple scaling policies in
// force simultaneously.
//
// A scaling policy rule statement has the following structure:
//
// If [MetricName] is [ComparisonOperator] [Threshold] for [EvaluationPeriods]
// minutes, then [ScalingAdjustmentType] to/by [ScalingAdjustment].
//
// For example, this policy: "If the number of idle instances exceeds 20 for
// more than 15 minutes, then reduce the fleet capacity by 10 instances" could
// be implemented as the following rule statement:
//
// If [IdleInstances] is [GreaterThanOrEqualToThreshold] [20] for [15] minutes,
// then [ChangeInCapacity] by [-10].
//
// To create or update a scaling policy, specify a unique combination of name
// and fleet ID, and set the rule values. All parameters for this action are
// required. If successful, the policy name is returned. Scaling policies cannot
// be suspended or made inactive. To stop enforcing a scaling policy, call DeleteScalingPolicy.
func (c *GameLift) PutScalingPolicy(input *PutScalingPolicyInput) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opRequestUploadCredentials = "RequestUploadCredentials"

// RequestUploadCredentialsRequest generates a request for the RequestUploadCredentials operation.
func (c *GameLift) RequestUploadCredentialsRequest(input *RequestUploadCredentialsInput) (req *request.Request, output *RequestUploadCredentialsOutput) {
	op := &request.Operation{
		Name:       opRequestUploadCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestUploadCredentialsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RequestUploadCredentialsOutput{}
	req.Data = output
	return
}

// Retrieves a fresh set of upload credentials and the assigned Amazon S3 storage
// location for a specific build. Valid credentials are required to upload your
// game build files to Amazon S3.
//
// Call this action only if you need credentials for a build created with CreateBuild.
// This is a rare situation; in most cases, builds are created using the CLI
// command upload-build, which creates a build record and also uploads build
// files.
//
// Upload credentials are returned when you create the build, but they have
// a limited lifespan. You can get fresh credentials and use them to re-upload
// game files until the state of that build changes to READY. Once this happens,
// you must create a brand new build.
func (c *GameLift) RequestUploadCredentials(input *RequestUploadCredentialsInput) (*RequestUploadCredentialsOutput, error) {
	req, out := c.RequestUploadCredentialsRequest(input)
	err := req.Send()
	return out, err
}

const opResolveAlias = "ResolveAlias"

// ResolveAliasRequest generates a request for the ResolveAlias operation.
func (c *GameLift) ResolveAliasRequest(input *ResolveAliasInput) (req *request.Request, output *ResolveAliasOutput) {
	op := &request.Operation{
		Name:       opResolveAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResolveAliasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ResolveAliasOutput{}
	req.Data = output
	return
}

// Retrieves the fleet ID that a specified alias is currently pointing to.
func (c *GameLift) ResolveAlias(input *ResolveAliasInput) (*ResolveAliasOutput, error) {
	req, out := c.ResolveAliasRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAlias = "UpdateAlias"

// UpdateAliasRequest generates a request for the UpdateAlias operation.
func (c *GameLift) UpdateAliasRequest(input *UpdateAliasInput) (req *request.Request, output *UpdateAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAliasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateAliasOutput{}
	req.Data = output
	return
}

// Updates properties for an alias. To update properties, specify the alias
// ID to be updated and provide the information to be changed. To reassign an
// alias to another fleet, provide an updated routing strategy. If successful,
// the updated alias record is returned.
func (c *GameLift) UpdateAlias(input *UpdateAliasInput) (*UpdateAliasOutput, error) {
	req, out := c.UpdateAliasRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateBuild = "UpdateBuild"

// UpdateBuildRequest generates a request for the UpdateBuild operation.
func (c *GameLift) UpdateBuildRequest(input *UpdateBuildInput) (req *request.Request, output *UpdateBuildOutput) {
	op := &request.Operation{
		Name:       opUpdateBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBuildInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateBuildOutput{}
	req.Data = output
	return
}

// Updates metadata in a build record, including the build name and version.
// To update the metadata, specify the build ID to update and provide the new
// values. If successful, a build object containing the updated metadata is
// returned.
func (c *GameLift) UpdateBuild(input *UpdateBuildInput) (*UpdateBuildOutput, error) {
	req, out := c.UpdateBuildRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateFleetAttributes = "UpdateFleetAttributes"

// UpdateFleetAttributesRequest generates a request for the UpdateFleetAttributes operation.
func (c *GameLift) UpdateFleetAttributesRequest(input *UpdateFleetAttributesInput) (req *request.Request, output *UpdateFleetAttributesOutput) {
	op := &request.Operation{
		Name:       opUpdateFleetAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateFleetAttributesOutput{}
	req.Data = output
	return
}

// Updates fleet properties, including name and description, for a fleet. To
// update metadata, specify the fleet ID and the property values you want to
// change. If successful, the fleet ID for the updated fleet is returned.
func (c *GameLift) UpdateFleetAttributes(input *UpdateFleetAttributesInput) (*UpdateFleetAttributesOutput, error) {
	req, out := c.UpdateFleetAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateFleetCapacity = "UpdateFleetCapacity"

// UpdateFleetCapacityRequest generates a request for the UpdateFleetCapacity operation.
func (c *GameLift) UpdateFleetCapacityRequest(input *UpdateFleetCapacityInput) (req *request.Request, output *UpdateFleetCapacityOutput) {
	op := &request.Operation{
		Name:       opUpdateFleetCapacity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetCapacityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateFleetCapacityOutput{}
	req.Data = output
	return
}

// Updates capacity settings for a fleet. Use this action to specify the number
// of EC2 instances (hosts) you want this fleet to contain. Before calling this
// action, you may want to call DescribeEC2InstanceLimits to get the maximum
// capacity based on the fleet's EC2 instance type.
//
// If you're using auto-scaling (see PutScalingPolicy), you may want to specify
// a minimum and/or maximum capacity. If you don't provide these boundaries,
// auto-scaling can set capacity anywhere between zero and the service limits
// (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_gamelift).
//
// To update fleet capacity, specify the fleet ID and the desired number of
// instances. If successful, Amazon GameLift starts or terminates instances
// so that the fleet's active instance count matches the desired instance count.
// You can view a fleet's current capacity information by calling DescribeFleetCapacity.
// If the desired instance count is higher than the instance type's limit, the
// "Limit Exceeded" exception will occur.
func (c *GameLift) UpdateFleetCapacity(input *UpdateFleetCapacityInput) (*UpdateFleetCapacityOutput, error) {
	req, out := c.UpdateFleetCapacityRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateFleetPortSettings = "UpdateFleetPortSettings"

// UpdateFleetPortSettingsRequest generates a request for the UpdateFleetPortSettings operation.
func (c *GameLift) UpdateFleetPortSettingsRequest(input *UpdateFleetPortSettingsInput) (req *request.Request, output *UpdateFleetPortSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateFleetPortSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetPortSettingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateFleetPortSettingsOutput{}
	req.Data = output
	return
}

// Updates port settings for a fleet. To update settings, specify the fleet
// ID to be updated and list the permissions you want to update. List the permissions
// you want to add in InboundPermissionAuthorizations, and permissions you want
// to remove in InboundPermissionRevocations. Permissions to be removed must
// match existing fleet permissions. If successful, the fleet ID for the updated
// fleet is returned.
func (c *GameLift) UpdateFleetPortSettings(input *UpdateFleetPortSettingsInput) (*UpdateFleetPortSettingsOutput, error) {
	req, out := c.UpdateFleetPortSettingsRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateGameSession = "UpdateGameSession"

// UpdateGameSessionRequest generates a request for the UpdateGameSession operation.
func (c *GameLift) UpdateGameSessionRequest(input *UpdateGameSessionInput) (req *request.Request, output *UpdateGameSessionOutput) {
	op := &request.Operation{
		Name:       opUpdateGameSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGameSessionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateGameSessionOutput{}
	req.Data = output
	return
}

// Updates game session properties. This includes the session name, maximum
// player count, protection policy, which controls whether or not an active
// game session can be terminated during a scale-down event, and the player
// session creation policy, which controls whether or not new players can join
// the session. To update a game session, specify the game session ID and the
// values you want to change. If successful, an updated GameSession object is
// returned.
func (c *GameLift) UpdateGameSession(input *UpdateGameSessionInput) (*UpdateGameSessionOutput, error) {
	req, out := c.UpdateGameSessionRequest(input)
	err := req.Send()
	return out, err
}

// Properties describing a fleet alias.
type Alias struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet alias.
	AliasId *string `type:"string"`

	// Time stamp indicating when this object was created. Format is an integer
	// representing the number of seconds since the Unix epoch (Unix time).
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Human-readable description of the alias.
	Description *string `type:"string"`

	// Time stamp indicating when this object was last modified. Format is an integer
	// representing the number of seconds since the Unix epoch (Unix time).
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Descriptive label associated with this alias. Alias names do not need to
	// be unique.
	Name *string `type:"string"`

	// Routing configuration for a fleet alias.
	RoutingStrategy *RoutingStrategy `type:"structure"`
}

// String returns the string representation
func (s Alias) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Alias) GoString() string {
	return s.String()
}

// AWS access credentials required to upload game build files to Amazon GameLift.
// These credentials are generated with CreateBuild, and are valid for a limited
// time. If they expire before you upload your game build, get a new set by
// calling RequestUploadCredentials.
type AwsCredentials struct {
	_ struct{} `type:"structure"`

	// Access key for an AWS account.
	AccessKeyId *string `min:"1" type:"string"`

	// Secret key for an AWS account.
	SecretAccessKey *string `min:"1" type:"string"`

	// Token specific to a build ID.
	SessionToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AwsCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsCredentials) GoString() string {
	return s.String()
}

// Properties describing a game build.
type Build struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build.
	BuildId *string `type:"string"`

	// Time stamp indicating when this object was created. Format is an integer
	// representing the number of seconds since the Unix epoch (Unix time).
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Descriptive label associated with this build. Build names do not need to
	// be unique. It can be set using CreateBuild or UpdateBuild.
	Name *string `type:"string"`

	// File size of the uploaded game build, expressed in bytes. When the build
	// state is INITIALIZED, this value is 0.
	SizeOnDisk *int64 `min:"1" type:"long"`

	// Current status of the build. Possible build states include: INITIALIZED:
	// A new build has been defined, but no files have been uploaded. You cannot
	// create fleets for builds that are in this state. When a build is successfully
	// created, the build state is set to this value. READY: The game build has
	// been successfully uploaded. You can now create new fleets for this build.FAILED:
	// The game build upload failed. You cannot create new fleets for this build.
	Status *string `type:"string" enum:"BuildStatus"`

	// Version associated with this build. Version strings do not need to be unique
	// to a build. This value can be set using CreateBuild or UpdateBuild.
	Version *string `type:"string"`
}

// String returns the string representation
func (s Build) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Build) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// Human-readable description of the alias.
	Description *string `min:"1" type:"string"`

	// Descriptive label associated with this alias. Alias names do not need to
	// be unique.
	Name *string `min:"1" type:"string" required:"true"`

	// Object specifying the fleet and routing type to use for the alias.
	RoutingStrategy *RoutingStrategy `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type CreateAliasOutput struct {
	_ struct{} `type:"structure"`

	// Object containing the newly created alias record.
	Alias *Alias `type:"structure"`
}

// String returns the string representation
func (s CreateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type CreateBuildInput struct {
	_ struct{} `type:"structure"`

	// Descriptive label associated with this build. Build names do not need to
	// be unique. A build name can be changed later using UpdateBuild.
	Name *string `min:"1" type:"string"`

	// Location in Amazon Simple Storage Service (Amazon S3) where a build's files
	// are stored. This location is assigned in response to a CreateBuild call,
	// and is always in the same region as the service used to create the build.
	// For more details see the Amazon S3 documentation (http://aws.amazon.com/documentation/s3/).
	StorageLocation *S3Location `type:"structure"`

	// Version associated with this build. Version strings do not need to be unique
	// to a build. A build version can be changed later using UpdateBuild.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBuildInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type CreateBuildOutput struct {
	_ struct{} `type:"structure"`

	// Set of properties for the newly created build.
	Build *Build `type:"structure"`

	// Amazon S3 path and key, identifying where the game build files are stored.
	StorageLocation *S3Location `type:"structure"`

	// AWS credentials required when uploading a game build to the storage location.
	// These credentials have a limited lifespan and are valid only for the build
	// they were issued for. If you need to get fresh credentials, call RequestUploadCredentials.
	UploadCredentials *AwsCredentials `type:"structure"`
}

// String returns the string representation
func (s CreateBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBuildOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type CreateFleetInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the build you want the new fleet to use.
	BuildId *string `type:"string" required:"true"`

	// Human-readable description of the fleet.
	Description *string `min:"1" type:"string"`

	// Access limits for incoming traffic. Setting these values limits game server
	// access to incoming traffic using specified IP ranges and port numbers. Some
	// ports in a range may be restricted. You can provide one or more sets of permissions
	// for the fleet.
	EC2InboundPermissions []*IpPermission `type:"list"`

	// Type of EC2 instances used in the fleet. EC2 instance types define the CPU,
	// memory, storage, and networking capacity of the fleetaposs hosts. Amazon
	// GameLift supports the EC2 instance types listed below. See Amazon EC2 Instance
	// Types (https://aws.amazon.com/ec2/instance-types/) for detailed descriptions
	// of each.
	EC2InstanceType *string `type:"string" required:"true" enum:"EC2InstanceType"`

	// Path to game-session log files generated by your game server. Once a game
	// session has been terminated, Amazon GameLift captures and stores the logs
	// on Amazon S3. Use the GameLift console to access the stored logs.
	LogPaths []*string `type:"list"`

	// Descriptive label associated with this fleet. Fleet names do not need to
	// be unique.
	Name *string `min:"1" type:"string" required:"true"`

	// Game session protection policy to apply to all instances created in this
	// fleet. If this parameter is not set, new instances in this fleet will default
	// to no protection. Protection can be set for individual instances using UpdateGameSession.
	// NoProtection: The game session can be terminated during a scale-down event.
	// FullProtection: If the game session is in an ACTIVE status, it cannot be
	// terminated during a scale-down event.
	NewGameSessionProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`

	// Parameters required to launch your game server. These parameters should be
	// expressed as a string of command-line parameters. Example: "+sv_port 33435
	// +start_lobby".
	ServerLaunchParameters *string `min:"1" type:"string"`

	// Path to the launch executable for the game server. A game server is built
	// into a C:\game drive. This value must be expressed as C:\game\[launchpath].
	// Example: If, when built, your game server files are in a folder called "MyGame",
	// your log path should be C:\game\MyGame\server.exe.
	ServerLaunchPath *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFleetInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type CreateFleetOutput struct {
	_ struct{} `type:"structure"`

	// Properties for the newly created fleet.
	FleetAttributes *FleetAttributes `type:"structure"`
}

// String returns the string representation
func (s CreateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFleetOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type CreateGameSessionInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet alias. Each request must reference either a
	// fleet ID or alias ID, but not both.
	AliasId *string `type:"string"`

	// Unique identifier for a fleet. Each request must reference either a fleet
	// ID or alias ID, but not both.
	FleetId *string `type:"string"`

	// Set of properties used to administer a game session. These properties are
	// passed to your game server.
	GameProperties []*GameProperty `type:"list"`

	// Maximum number of players that can be connected simultaneously to the game
	// session.
	MaximumPlayerSessionCount *int64 `type:"integer" required:"true"`

	// Descriptive label associated with this game session. Session names do not
	// need to be unique.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateGameSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGameSessionInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type CreateGameSessionOutput struct {
	_ struct{} `type:"structure"`

	// Object containing the newly created game session record.
	GameSession *GameSession `type:"structure"`
}

// String returns the string representation
func (s CreateGameSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGameSessionOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type CreatePlayerSessionInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a game session. Specify the game session you want to
	// add a player to.
	GameSessionId *string `type:"string" required:"true"`

	// Unique identifier for the player to be added.
	PlayerId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePlayerSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlayerSessionInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type CreatePlayerSessionOutput struct {
	_ struct{} `type:"structure"`

	// Object containing the newly created player session record.
	PlayerSession *PlayerSession `type:"structure"`
}

// String returns the string representation
func (s CreatePlayerSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlayerSessionOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type CreatePlayerSessionsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a game session.
	GameSessionId *string `type:"string" required:"true"`

	// List of unique identifiers for the players to be added.
	PlayerIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreatePlayerSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlayerSessionsInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type CreatePlayerSessionsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of player session objects created for the added players.
	PlayerSessions []*PlayerSession `type:"list"`
}

// String returns the string representation
func (s CreatePlayerSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlayerSessionsOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DeleteAliasInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet alias. Specify the alias you want to delete.
	AliasId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasInput) GoString() string {
	return s.String()
}

type DeleteAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DeleteBuildInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the build you want to delete.
	BuildId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBuildInput) GoString() string {
	return s.String()
}

type DeleteBuildOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBuildOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DeleteFleetInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the fleet you want to delete.
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFleetInput) GoString() string {
	return s.String()
}

type DeleteFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFleetOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DeleteScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string" required:"true"`

	// Descriptive label associated with this scaling policy. Policy names do not
	// need to be unique.
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScalingPolicyInput) GoString() string {
	return s.String()
}

type DeleteScalingPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScalingPolicyOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DescribeAliasInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet alias. Specify the alias you want to retrieve.
	AliasId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAliasInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type DescribeAliasOutput struct {
	_ struct{} `type:"structure"`

	// Object containing the requested alias.
	Alias *Alias `type:"structure"`
}

// String returns the string representation
func (s DescribeAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAliasOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DescribeBuildInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the build you want to retrieve properties for.
	BuildId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBuildInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type DescribeBuildOutput struct {
	_ struct{} `type:"structure"`

	// Set of properties describing the requested build.
	Build *Build `type:"structure"`
}

// String returns the string representation
func (s DescribeBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBuildOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DescribeEC2InstanceLimitsInput struct {
	_ struct{} `type:"structure"`

	// Type of EC2 instances used in the fleet. EC2 instance types define the CPU,
	// memory, storage, and networking capacity of the fleetaposs hosts. Amazon
	// GameLift supports the EC2 instance types listed below. See Amazon EC2 Instance
	// Types (https://aws.amazon.com/ec2/instance-types/) for detailed descriptions
	// of each. Leave this parameter blank to retrieve limits for all types.
	EC2InstanceType *string `type:"string" enum:"EC2InstanceType"`
}

// String returns the string representation
func (s DescribeEC2InstanceLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEC2InstanceLimitsInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type DescribeEC2InstanceLimitsOutput struct {
	_ struct{} `type:"structure"`

	// Object containing the maximum number of instances for the specified instance
	// type.
	EC2InstanceLimits []*EC2InstanceLimit `type:"list"`
}

// String returns the string representation
func (s DescribeEC2InstanceLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEC2InstanceLimitsOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DescribeFleetAttributesInput struct {
	_ struct{} `type:"structure"`

	// Unique identifiers for the fleet(s) that you want to retrieve attributes
	// for. Leave this parameter empty to retrieve attributes for all fleets.
	FleetIds []*string `min:"1" type:"list"`

	// Maximum number of results to return. You can use this parameter with NextToken
	// to get results as a set of sequential pages. This parameter is ignored when
	// the request specifies one or a list of fleet IDs.
	Limit *int64 `min:"1" type:"integer"`

	// Token indicating the start of the next sequential page of results. Use the
	// token that is returned with a previous call to this action. To specify the
	// start of the result set, do not specify a value. This parameter is ignored
	// when the request specifies one or a list of fleet IDs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetAttributesInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type DescribeFleetAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing attribute metadata for each requested fleet
	// ID.
	FleetAttributes []*FleetAttributes `type:"list"`

	// Token indicating where to resume retrieving results on the next call to this
	// action. If no token is returned, these results represent the end of the list.
	//
	// If a request has a limit that exactly matches the number of remaining results,
	// a token is returned even though there are no more results to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetAttributesOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DescribeFleetCapacityInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the fleet(s) you want to retrieve capacity information
	// for.
	FleetIds []*string `min:"1" type:"list"`

	// Maximum number of results to return. You can use this parameter with NextToken
	// to get results as a set of sequential pages. This parameter is ignored when
	// the request specifies one or a list of fleet IDs.
	Limit *int64 `min:"1" type:"integer"`

	// Token indicating the start of the next sequential page of results. Use the
	// token that is returned with a previous call to this action. To specify the
	// start of the result set, do not specify a value. This parameter is ignored
	// when the request specifies one or a list of fleet IDs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetCapacityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetCapacityInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type DescribeFleetCapacityOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing capacity information for each requested
	// fleet ID. Leave this parameter empty to retrieve capacity information for
	// all fleets.
	FleetCapacity []*FleetCapacity `type:"list"`

	// Token indicating where to resume retrieving results on the next call to this
	// action. If no token is returned, these results represent the end of the list.
	//
	// If a request has a limit that exactly matches the number of remaining results,
	// a token is returned even though there are no more results to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetCapacityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetCapacityOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DescribeFleetEventsInput struct {
	_ struct{} `type:"structure"`

	// Most recent date to retrieve event logs for. If no end time is specified,
	// this call returns entries from the specified start time up to the present.
	// Format is an integer representing the number of seconds since the Unix epoch
	// (Unix time).
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Unique identifier for the fleet to get event logs for.
	FleetId *string `type:"string" required:"true"`

	// Maximum number of results to return. You can use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token indicating the start of the next sequential page of results. Use the
	// token that is returned with a previous call to this action. To specify the
	// start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Earliest date to retrieve event logs for. If no start time is specified,
	// this call returns entries starting from when the fleet was created to the
	// specified end time. Format is an integer representing the number of seconds
	// since the Unix epoch (Unix time).
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s DescribeFleetEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetEventsInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type DescribeFleetEventsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing event log entries for the specified fleet.
	Events []*Event `type:"list"`

	// Token indicating where to resume retrieving results on the next call to this
	// action. If no token is returned, these results represent the end of the list.
	//
	// If a request has a limit that exactly matches the number of remaining results,
	// a token is returned even though there are no more results to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetEventsOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DescribeFleetPortSettingsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the fleet you want to retrieve port settings for.
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFleetPortSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetPortSettingsInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type DescribeFleetPortSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Object containing port settings for the requested fleet ID.
	InboundPermissions []*IpPermission `type:"list"`
}

// String returns the string representation
func (s DescribeFleetPortSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetPortSettingsOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DescribeFleetUtilizationInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the fleet(s) you want to retrieve utilization data
	// for. Leave this parameter empty to retrieve utilization data for all fleets.
	FleetIds []*string `min:"1" type:"list"`

	// Maximum number of results to return. You can use this parameter with NextToken
	// to get results as a set of sequential pages. This parameter is ignored when
	// the request specifies one or a list of fleet IDs.
	Limit *int64 `min:"1" type:"integer"`

	// Token indicating the start of the next sequential page of results. Use the
	// token that is returned with a previous call to this action. To specify the
	// start of the result set, do not specify a value. This parameter is ignored
	// when the request specifies one or a list of fleet IDs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetUtilizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetUtilizationInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type DescribeFleetUtilizationOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing utilization information for each requested
	// fleet ID.
	FleetUtilization []*FleetUtilization `type:"list"`

	// Token indicating where to resume retrieving results on the next call to this
	// action. If no token is returned, these results represent the end of the list.
	//
	// If a request has a limit that exactly matches the number of remaining results,
	// a token is returned even though there are no more results to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetUtilizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetUtilizationOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DescribeGameSessionDetailsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet alias. Specify an alias to retrieve information
	// on all game sessions active on the fleet.
	AliasId *string `type:"string"`

	// Unique identifier for a fleet. Specify a fleet to retrieve information on
	// all game sessions active on the fleet.
	FleetId *string `type:"string"`

	// Unique identifier for a game session. Specify the game session to retrieve
	// information on.
	GameSessionId *string `type:"string"`

	// Maximum number of results to return. You can use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token indicating the start of the next sequential page of results. Use the
	// token that is returned with a previous call to this action. To specify the
	// start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Game session status to filter results on. Possible game session states include
	// ACTIVE, TERMINATED, ACTIVATING and TERMINATING (the last two are transitory).
	StatusFilter *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionDetailsInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type DescribeGameSessionDetailsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing game session properties and the protection
	// policy currently in force for each session matching the request.
	GameSessionDetails []*GameSessionDetail `type:"list"`

	// Token indicating where to resume retrieving results on the next call to this
	// action. If no token is returned, these results represent the end of the list.
	//
	// If a request has a limit that exactly matches the number of remaining results,
	// a token is returned even though there are no more results to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionDetailsOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DescribeGameSessionsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet alias. Specify an alias to retrieve information
	// on all game sessions active on the fleet.
	AliasId *string `type:"string"`

	// Unique identifier for a fleet. Specify a fleet to retrieve information on
	// all game sessions active on the fleet.
	FleetId *string `type:"string"`

	// Unique identifier for a game session. Specify the game session to retrieve
	// information on.
	GameSessionId *string `type:"string"`

	// Maximum number of results to return. You can use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token indicating the start of the next sequential page of results. Use the
	// token that is returned with a previous call to this action. To specify the
	// start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Game session status to filter results on. Possible game session states include
	// ACTIVE, TERMINATED, ACTIVATING and TERMINATING (the last two are transitory).
	StatusFilter *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionsInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type DescribeGameSessionsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing game session properties for each session
	// matching the request.
	GameSessions []*GameSession `type:"list"`

	// Token indicating where to resume retrieving results on the next call to this
	// action. If no token is returned, these results represent the end of the list.
	//
	// If a request has a limit that exactly matches the number of remaining results,
	// a token is returned even though there are no more results to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGameSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGameSessionsOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DescribePlayerSessionsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a game session.
	GameSessionId *string `type:"string"`

	// Maximum number of results to return. You can use this parameter with NextToken
	// to get results as a set of sequential pages. If a player session ID is specified,
	// this parameter is ignored.
	Limit *int64 `min:"1" type:"integer"`

	// Token indicating the start of the next sequential page of results. Use the
	// token that is returned with a previous call to this action. To specify the
	// start of the result set, do not specify a value. If a player session ID is
	// specified, this parameter is ignored.
	NextToken *string `min:"1" type:"string"`

	// Unique identifier for a player.
	PlayerId *string `min:"1" type:"string"`

	// Unique identifier for a player session.
	PlayerSessionId *string `type:"string"`

	// Player session status to filter results on. Possible player session states
	// include: RESERVED: The player session request has been received, but the
	// player has not yet connected to the game server and/or been validated. ACTIVE:
	// The player has been validated by the game server and is currently connected.COMPLETED:
	// The player connection has been dropped.TIMEDOUT: A player session request
	// was received, but the player did not connect and/or was not validated within
	// the time-out limit (60 seconds).
	PlayerSessionStatusFilter *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribePlayerSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePlayerSessionsInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type DescribePlayerSessionsOutput struct {
	_ struct{} `type:"structure"`

	// Token indicating where to resume retrieving results on the next call to this
	// action. If no token is returned, these results represent the end of the list.
	//
	// If a request has a limit that exactly matches the number of remaining results,
	// a token is returned even though there are no more results to retrieve.
	NextToken *string `min:"1" type:"string"`

	// Collection of objects containing properties for each player session that
	// matches the request.
	PlayerSessions []*PlayerSession `type:"list"`
}

// String returns the string representation
func (s DescribePlayerSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePlayerSessionsOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type DescribeScalingPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet. Specify the fleet to retrieve scaling policies
	// for.
	FleetId *string `type:"string" required:"true"`

	// Maximum number of results to return. You can use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token indicating the start of the next sequential page of results. Use the
	// token that is returned with a previous call to this action. To specify the
	// start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Game session status to filter results on. A scaling policy is only in force
	// when in an Active state.  ACTIVE: The scaling policy is currently in force.
	// UPDATEREQUESTED: A request to update the scaling policy has been received.
	// UPDATING: A change is being made to the scaling policy. DELETEREQUESTED:
	// A request to delete the scaling policy has been received. DELETING: The scaling
	// policy is being deleted. DELETED: The scaling policy has been deleted. ERROR:
	// An error occurred in creating the policy. It should be removed and recreated.
	StatusFilter *string `type:"string" enum:"ScalingStatusType"`
}

// String returns the string representation
func (s DescribeScalingPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPoliciesInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type DescribeScalingPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// Token indicating where to resume retrieving results on the next call to this
	// action. If no token is returned, these results represent the end of the list.
	//
	// If a request has a limit that exactly matches the number of remaining results,
	// a token is returned even though there are no more results to retrieve.
	NextToken *string `min:"1" type:"string"`

	// Collection of objects containing the scaling policies matching the request.
	ScalingPolicies []*ScalingPolicy `type:"list"`
}

// String returns the string representation
func (s DescribeScalingPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPoliciesOutput) GoString() string {
	return s.String()
}

// Current status of fleet capacity. The number of active instances should match
// or be in the process of matching the number of desired instances. Pending
// and terminating counts are non-zero only if fleet capacity is adjusting to
// an UpdateFleetCapacity request, or if access to resources is temporarily
// affected.
type EC2InstanceCounts struct {
	_ struct{} `type:"structure"`

	// Actual number of active instances in the fleet.
	ACTIVE *int64 `type:"integer"`

	// Ideal number of active instances in the fleet.
	DESIRED *int64 `type:"integer"`

	// Number of active instances in the fleet that are not currently hosting a
	// game session.
	IDLE *int64 `type:"integer"`

	// Maximum value allowed for the fleet's instance count.
	MAXIMUM *int64 `type:"integer"`

	// Minimum value allowed for the fleet's instance count.
	MINIMUM *int64 `type:"integer"`

	// Number of instances in the fleet that are starting but not yet active.
	PENDING *int64 `type:"integer"`

	// Number of instances in the fleet that are no longer active but haven't yet
	// been terminated.
	TERMINATING *int64 `type:"integer"`
}

// String returns the string representation
func (s EC2InstanceCounts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2InstanceCounts) GoString() string {
	return s.String()
}

// Maximum number of instances allowed based on the Amazon Elastic Compute Cloud
// (Amazon EC2) instance type. Instance limits can be retrieved by calling DescribeEC2InstanceLimits.
type EC2InstanceLimit struct {
	_ struct{} `type:"structure"`

	// Number of instances of the specified type that are currently in use by this
	// AWS account.
	CurrentInstances *int64 `type:"integer"`

	// Type of EC2 instances used in the fleet. EC2 instance types define the CPU,
	// memory, storage, and networking capacity of the fleetaposs hosts. Amazon
	// GameLift supports the EC2 instance types listed below. See Amazon EC2 Instance
	// Types (https://aws.amazon.com/ec2/instance-types/) for detailed descriptions
	// of each.
	EC2InstanceType *string `type:"string" enum:"EC2InstanceType"`

	// Number of instances allowed.
	InstanceLimit *int64 `type:"integer"`
}

// String returns the string representation
func (s EC2InstanceLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2InstanceLimit) GoString() string {
	return s.String()
}

// Log entry describing an event involving an Amazon GameLift resource (such
// as a fleet).
type Event struct {
	_ struct{} `type:"structure"`

	// Type of event being logged.
	EventCode *string `type:"string" enum:"EventCode"`

	// Unique identifier for a fleet event.
	EventId *string `min:"1" type:"string"`

	// Time stamp indicating when this event occurred. Format is an integer representing
	// the number of seconds since the Unix epoch (Unix time).
	EventTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Additional information related to the event.
	Message *string `min:"1" type:"string"`

	// Unique identifier for the resource, such as a fleet ID.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// General properties describing a fleet.
type FleetAttributes struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build.
	BuildId *string `type:"string"`

	// Time stamp indicating when this object was created. Format is an integer
	// representing the number of seconds since the Unix epoch (Unix time).
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Human-readable description of the fleet.
	Description *string `min:"1" type:"string"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string"`

	// Path to game-session log files generated by your game server. Once a game
	// session has been terminated, Amazon GameLift captures and stores the logs
	// on Amazon S3. Use the GameLift console to access the stored logs.
	LogPaths []*string `type:"list"`

	// Descriptive label associated with this fleet. Fleet names do not need to
	// be unique.
	Name *string `min:"1" type:"string"`

	// Type of game session protection to set for all new instances started in the
	// fleet. NoProtection: The game session can be terminated during a scale-down
	// event. FullProtection: If the game session is in an ACTIVE status, it cannot
	// be terminated during a scale-down event.
	NewGameSessionProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`

	// Parameters required to launch your game server. These parameters should be
	// expressed as a string of command-line parameters. Example: "+sv_port 33435
	// +start_lobby".
	ServerLaunchParameters *string `min:"1" type:"string"`

	// Path to the launch executable for the game server. A game server is built
	// into a C:\game drive. This value must be expressed as C:\game\[launchpath].
	// Example: If, when built, your game server files are in a folder called "MyGame",
	// your log path should be C:\game\MyGame\server.exe.
	ServerLaunchPath *string `min:"1" type:"string"`

	// Current status of the fleet. Possible fleet states include: NEW: A new fleet
	// has been defined and hosts allocated.DOWNLOADING/VALIDATING/BUILDING/ACTIVATING:
	// The new fleet is being set up with the game build, and new hosts are being
	// started.ACTIVE: Hosts can now accept game sessions.ERROR: An error occurred
	// when downloading, validating, building, or activating the fleet.DELETING:
	// Hosts are responding to a delete fleet request.TERMINATED: The fleet no longer
	// exists.
	Status *string `type:"string" enum:"FleetStatus"`

	// Time stamp indicating when this fleet was terminated. Format is an integer
	// representing the number of seconds since the Unix epoch (Unix time).
	TerminationTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s FleetAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FleetAttributes) GoString() string {
	return s.String()
}

// Information about the fleet's capacity. Fleet capacity is measured in EC2
// instances. By default, new fleets have a capacity of one instance, but can
// be updated as needed. The maximum number of instances for a fleet is determined
// by the fleet's instance type.
type FleetCapacity struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string"`

	// Current status of fleet capacity.
	InstanceCounts *EC2InstanceCounts `type:"structure"`

	// Type of EC2 instances used in the fleet. EC2 instance types define the CPU,
	// memory, storage, and networking capacity of the fleetaposs hosts. Amazon
	// GameLift supports the EC2 instance types listed below. See Amazon EC2 Instance
	// Types (https://aws.amazon.com/ec2/instance-types/) for detailed descriptions
	// of each.
	InstanceType *string `type:"string" enum:"EC2InstanceType"`
}

// String returns the string representation
func (s FleetCapacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FleetCapacity) GoString() string {
	return s.String()
}

// Current status of fleet utilization, including the number of game and player
// sessions being hosted.
type FleetUtilization struct {
	_ struct{} `type:"structure"`

	// Number of active game sessions currently being hosted on fleet game servers.
	ActiveGameSessionCount *int64 `type:"integer"`

	// Number of active player sessions currently being hosted on fleet game servers.
	CurrentPlayerSessionCount *int64 `type:"integer"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string"`

	// Maximum players allowed across all game sessions currently hosted in the
	// fleet.
	MaximumPlayerSessionCount *int64 `type:"integer"`
}

// String returns the string representation
func (s FleetUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FleetUtilization) GoString() string {
	return s.String()
}

// Set of key-value pairs containing information your game server requires to
// set up sessions. This object allows you to pass in any set of data needed
// for your game. For more information, see the Amazon GameLift Developer Guide
// (http://docs.aws.amazon.com/gamelift/latest/developerguide/).
type GameProperty struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string" required:"true"`

	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GameProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GameProperty) GoString() string {
	return s.String()
}

// Properties describing a game session.
type GameSession struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this object was created. Format is an integer
	// representing the number of seconds since the Unix epoch (Unix time).
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Number of players currently in the game session.
	CurrentPlayerSessionCount *int64 `type:"integer"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string"`

	// Set of custom properties for the game session.
	GameProperties []*GameProperty `type:"list"`

	// Unique identifier for a game session.
	GameSessionId *string `type:"string"`

	// IP address of the game session.
	IpAddress *string `type:"string"`

	// Maximum number of players allowed in the game session.
	MaximumPlayerSessionCount *int64 `type:"integer"`

	// Descriptive label associated with this game session. Session names do not
	// need to be unique.
	Name *string `min:"1" type:"string"`

	// Indicates whether or not the game session is accepting new players.
	PlayerSessionCreationPolicy *string `type:"string" enum:"PlayerSessionCreationPolicy"`

	// Current status of the game session. A game session must be in an ACTIVE state
	// to have player sessions.
	Status *string `type:"string" enum:"GameSessionStatus"`

	// Time stamp indicating when this fleet was terminated. Format is an integer
	// representing the number of seconds since the Unix epoch (Unix time).
	TerminationTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s GameSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GameSession) GoString() string {
	return s.String()
}

// A game session's properties and the protection policy currently in force.
type GameSessionDetail struct {
	_ struct{} `type:"structure"`

	// Properties describing a game session.
	GameSession *GameSession `type:"structure"`

	// Current status of protection for the game session. NoProtection: The game
	// session can be terminated during a scale-down event. FullProtection: If the
	// game session is in an ACTIVE status, it cannot be terminated during a scale-down
	// event.
	ProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`
}

// String returns the string representation
func (s GameSessionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GameSessionDetail) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type GetGameSessionLogUrlInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a game session. Specify the game session you want to
	// get logs for.
	GameSessionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetGameSessionLogUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGameSessionLogUrlInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type GetGameSessionLogUrlOutput struct {
	_ struct{} `type:"structure"`

	// Location of the requested game session logs, available for download.
	PreSignedUrl *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetGameSessionLogUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGameSessionLogUrlOutput) GoString() string {
	return s.String()
}

// IP addresses and port settings used to limit access by incoming traffic (players)
// to a fleet. Permissions specify a range of IP addresses and port settings
// that must be used to gain access to a game server on a fleet machine.
type IpPermission struct {
	_ struct{} `type:"structure"`

	// Starting value for a range of allowed port numbers.
	FromPort *int64 `min:"1025" type:"integer" required:"true"`

	// Range of allowed IP addresses. This value must be expressed in CIDR notation
	// (https://tools.ietf.org/id/cidr). Example: "000.000.000.000/[subnet mask]"
	// or optionally the shortened version "0.0.0.0/[subnet mask]".
	IpRange *string `type:"string" required:"true"`

	// Network communication protocol used by the fleet.
	Protocol *string `type:"string" required:"true" enum:"IpProtocol"`

	// Ending value for a range of allowed port numbers. Port numbers are end-inclusive.
	// This value must be higher than FromPort.
	ToPort *int64 `min:"1025" type:"integer" required:"true"`
}

// String returns the string representation
func (s IpPermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpPermission) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type ListAliasesInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. You can use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Descriptive label associated with this alias. Alias names do not need to
	// be unique.
	Name *string `min:"1" type:"string"`

	// Token indicating the start of the next sequential page of results. Use the
	// token that is returned with a previous call to this action. To specify the
	// start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Type of routing to filter results on. Use this parameter to retrieve only
	// aliases of a certain type. To retrieve all aliases, leave this parameter
	// empty. Possible routing types include: SIMPLE: The alias resolves to one
	// specific fleet. Use this type when routing to active fleets.TERMINAL: The
	// alias does not resolve to a fleet but instead can be used to display a message
	// to the user. A terminal alias throws a TerminalRoutingStrategyException with
	// the RoutingStrategy message embedded.
	RoutingStrategyType *string `type:"string" enum:"RoutingStrategyType"`
}

// String returns the string representation
func (s ListAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type ListAliasesOutput struct {
	_ struct{} `type:"structure"`

	// Collection of alias records that match the list request.
	Aliases []*Alias `type:"list"`

	// Token indicating where to resume retrieving results on the next call to this
	// action. If no token is returned, these results represent the end of the list.
	//
	// If a request has a limit that exactly matches the number of remaining results,
	// a token is returned even though there are no more results to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type ListBuildsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. You can use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token indicating the start of the next sequential page of results. Use the
	// token that is returned with a previous call to this action. To specify the
	// start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Build state to filter results on. Use this parameter to retrieve builds in
	// a certain state. To retrieve all builds, leave this parameter empty. Possible
	// build states include: INITIALIZED: A new build has been defined, but no files
	// have been uploaded. You cannot create fleets for builds that are in this
	// state. When a build is successfully created, the build state is set to this
	// value. READY: The game build has been successfully uploaded. You can now
	// create new fleets for this build.FAILED: The game build upload failed. You
	// cannot create new fleets for this build.
	Status *string `type:"string" enum:"BuildStatus"`
}

// String returns the string representation
func (s ListBuildsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBuildsInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type ListBuildsOutput struct {
	_ struct{} `type:"structure"`

	// Collection of build records that match the request.
	Builds []*Build `type:"list"`

	// Token indicating where to resume retrieving results on the next call to this
	// action. If no token is returned, these results represent the end of the list.
	//
	// If a request has a limit that exactly matches the number of remaining results,
	// a token is returned even though there are no more results to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListBuildsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBuildsOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type ListFleetsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier of the build to return fleets for. Use this parameter to
	// return only fleets using the specified build. To retrieve all fleets, leave
	// this parameter empty.
	BuildId *string `type:"string"`

	// Maximum number of results to return. You can use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token indicating the start of the next sequential page of results. Use the
	// token that is returned with a previous call to this action. To specify the
	// start of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFleetsInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type ListFleetsOutput struct {
	_ struct{} `type:"structure"`

	// Set of fleet IDs matching the list request. You can retrieve additional information
	// about all returned fleets by passing this result set to a call to DescribeFleetAttributes,
	// DescribeFleetCapacity, and DescribeFleetUtilization.
	FleetIds []*string `min:"1" type:"list"`

	// Token indicating where to resume retrieving results on the next call to this
	// action. If no token is returned, these results represent the end of the list.
	//
	// If a request has a limit that exactly matches the number of remaining results,
	// a token is returned even though there are no more results to retrieve.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFleetsOutput) GoString() string {
	return s.String()
}

// Properties describing a player session.
type PlayerSession struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this object was created. Format is an integer
	// representing the number of seconds since the Unix epoch (Unix time).
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string"`

	// Unique identifier for a game session.
	GameSessionId *string `type:"string"`

	// Game session IP address. All player sessions reference the game session location.
	IpAddress *string `type:"string"`

	// Unique identifier for a player.
	PlayerId *string `min:"1" type:"string"`

	// Unique identifier for a player session.
	PlayerSessionId *string `type:"string"`

	// Current status of the player session. Possible player session states include:
	// RESERVED: The player session request has been received, but the player has
	// not yet connected to the game server and/or been validated. ACTIVE: The player
	// has been validated by the game server and is currently connected.COMPLETED:
	// The player connection has been dropped.TIMEDOUT: A player session request
	// was received, but the player did not connect and/or was not validated within
	// the time-out limit (60 seconds).
	Status *string `type:"string" enum:"PlayerSessionStatus"`

	// Time stamp indicating when this fleet was terminated. Format is an integer
	// representing the number of seconds since the Unix epoch (Unix time).
	TerminationTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s PlayerSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlayerSession) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type PutScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// Comparison operator to use when measuring the metric against the threshold
	// value.
	ComparisonOperator *string `type:"string" required:"true" enum:"ComparisonOperatorType"`

	// Length of time (in minutes) the metric must be at or beyond the threshold
	// before a scaling event is triggered.
	EvaluationPeriods *int64 `min:"1" type:"integer" required:"true"`

	// Unique identity for the fleet to scale with this policy.
	FleetId *string `type:"string" required:"true"`

	// Name of the Service-defined metric that is used to trigger an adjustment.
	//  ActivatingGameSessions: number of game sessions in the process of being
	// created (game session status = ACTIVATING). ActiveGameSessions: number of
	// game sessions currently running (game session status = ACTIVE). CurrentPlayerSessions:
	// number of active or reserved player sessions (player session status = ACTIVE
	// or RESERVED).  AvailablePlayerSessions: number of player session slots currently
	// available in active game sessions across the fleet, calculated by subtracting
	// a game session's current player session count from its maximum player session
	// count. This number includes game sessions that are not currently accepting
	// players (game session PlayerSessionCreationPolicy = DENY_ALL). ActiveInstances:
	// number of instances currently running a game session. IdleInstances: number
	// of instances not currently running a game session.
	MetricName *string `type:"string" required:"true" enum:"MetricName"`

	// Descriptive label associated with this scaling policy. Policy names do not
	// need to be unique. A fleet can have only one scaling policy with the same
	// name.
	Name *string `min:"1" type:"string" required:"true"`

	// Amount of adjustment to make, based on the scaling adjustment type.
	ScalingAdjustment *int64 `type:"integer" required:"true"`

	// Type of adjustment to make to a fleet's instance count (see FleetCapacity):
	//  ChangeInCapacity: add (or subtract) the scaling adjustment value from the
	// current instance count. Positive values scale up while negative values scale
	// down. ExactCapacity: set the instance count to the scaling adjustment value.
	// PercentChangeInCapacity: increase or reduce the current instance count by
	// the scaling adjustment, read as a percentage. Positive values scale up while
	// negative values scale down; for example, a value of "-10" scales the fleet
	// down by 10%.
	ScalingAdjustmentType *string `type:"string" required:"true" enum:"ScalingAdjustmentType"`

	// Metric value used to trigger a scaling event.
	Threshold *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s PutScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScalingPolicyInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type PutScalingPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Descriptive label associated with this scaling policy. Policy names do not
	// need to be unique.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScalingPolicyOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type RequestUploadCredentialsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the build you want to get credentials for.
	BuildId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RequestUploadCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestUploadCredentialsInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type RequestUploadCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// Amazon S3 path and key, identifying where the game build files are stored.
	StorageLocation *S3Location `type:"structure"`

	// AWS credentials required when uploading a game build to the storage location.
	// These credentials have a limited lifespan and are valid only for the build
	// they were issued for.
	UploadCredentials *AwsCredentials `type:"structure"`
}

// String returns the string representation
func (s RequestUploadCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestUploadCredentialsOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type ResolveAliasInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the alias you want to resolve.
	AliasId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResolveAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolveAliasInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type ResolveAliasOutput struct {
	_ struct{} `type:"structure"`

	// Fleet ID associated with the requested alias.
	FleetId *string `type:"string"`
}

// String returns the string representation
func (s ResolveAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolveAliasOutput) GoString() string {
	return s.String()
}

// Routing configuration for a fleet alias.
type RoutingStrategy struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string"`

	// Message text to be used with a terminal routing strategy.
	Message *string `type:"string"`

	// Type of routing strategy. Possible routing types include: SIMPLE: The alias
	// resolves to one specific fleet. Use this type when routing to active fleets.TERMINAL:
	// The alias does not resolve to a fleet but instead can be used to display
	// a message to the user. A terminal alias throws a TerminalRoutingStrategyException
	// with the RoutingStrategy message embedded.
	Type *string `type:"string" enum:"RoutingStrategyType"`
}

// String returns the string representation
func (s RoutingStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RoutingStrategy) GoString() string {
	return s.String()
}

// Location in Amazon Simple Storage Service (Amazon S3) where a build's files
// are stored. This location is assigned in response to a CreateBuild call,
// and is always in the same region as the service used to create the build.
// For more details see the Amazon S3 documentation (http://aws.amazon.com/documentation/s3/).
type S3Location struct {
	_ struct{} `type:"structure"`

	// Amazon S3 bucket identifier.
	Bucket *string `min:"1" type:"string"`

	// Amazon S3 bucket key.
	Key *string `min:"1" type:"string"`

	RoleArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Location) GoString() string {
	return s.String()
}

// Rule that controls how a fleet is scaled. Scaling policies are uniquely identified
// by the combination of name and fleet ID.
type ScalingPolicy struct {
	_ struct{} `type:"structure"`

	// Comparison operator to use when measuring a metric against the threshold
	// value.
	ComparisonOperator *string `type:"string" enum:"ComparisonOperatorType"`

	// Length of time (in minutes) the metric must be at or beyond the threshold
	// before a scaling event is triggered.
	EvaluationPeriods *int64 `min:"1" type:"integer"`

	// Unique identity for the fleet associated with this scaling policy.
	FleetId *string `type:"string"`

	// Name of the GameLift-defined metric that is used to trigger an adjustment.
	//  ActivatingGameSessions: number of game sessions in the process of being
	// created (game session status = ACTIVATING). ActiveGameSessions: number of
	// game sessions currently running (game session status = ACTIVE). CurrentPlayerSessions:
	// number of active or reserved player sessions (player session status = ACTIVE
	// or RESERVED).  AvailablePlayerSessions: number of player session slots currently
	// available in active game sessions across the fleet, calculated by subtracting
	// a game session's current player session count from its maximum player session
	// count. This number does include game sessions that are not currently accepting
	// players (game session PlayerSessionCreationPolicy = DENY_ALL). ActiveInstances:
	// number of instances currently running a game session. IdleInstances: number
	// of instances not currently running a game session.
	MetricName *string `type:"string" enum:"MetricName"`

	// Descriptive label associated with this scaling policy. Policy names do not
	// need to be unique.
	Name *string `min:"1" type:"string"`

	// Amount of adjustment to make, based on the scaling adjustment type.
	ScalingAdjustment *int64 `type:"integer"`

	// Type of adjustment to make to a fleet's instance count (see FleetCapacity):
	//  ChangeInCapacity: add (or subtract) the scaling adjustment value from the
	// current instance count. Positive values scale up while negative values scale
	// down. ExactCapacity: set the instance count to the scaling adjustment value.
	// PercentChangeInCapacity: increase or reduce the current instance count by
	// the scaling adjustment, read as a percentage. Positive values scale up while
	// negative values scale down.
	ScalingAdjustmentType *string `type:"string" enum:"ScalingAdjustmentType"`

	// Current status of the scaling policy. The scaling policy is only in force
	// when in an Active state.  ACTIVE: The scaling policy is currently in force.
	// UPDATEREQUESTED: A request to update the scaling policy has been received.
	// UPDATING: A change is being made to the scaling policy. DELETEREQUESTED:
	// A request to delete the scaling policy has been received. DELETING: The scaling
	// policy is being deleted. DELETED: The scaling policy has been deleted. ERROR:
	// An error occurred in creating the policy. It should be removed and recreated.
	Status *string `type:"string" enum:"ScalingStatusType"`

	// Metric value used to trigger a scaling event.
	Threshold *float64 `type:"double"`
}

// String returns the string representation
func (s ScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingPolicy) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type UpdateAliasInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet alias. Specify the alias you want to update.
	AliasId *string `type:"string" required:"true"`

	// Human-readable description of the alias.
	Description *string `min:"1" type:"string"`

	// Descriptive label associated with this alias. Alias names do not need to
	// be unique.
	Name *string `min:"1" type:"string"`

	// Object specifying the fleet and routing type to use for the alias.
	RoutingStrategy *RoutingStrategy `type:"structure"`
}

// String returns the string representation
func (s UpdateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type UpdateAliasOutput struct {
	_ struct{} `type:"structure"`

	// Object containing the updated alias configuration.
	Alias *Alias `type:"structure"`
}

// String returns the string representation
func (s UpdateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type UpdateBuildInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the build you want to update.
	BuildId *string `type:"string" required:"true"`

	// Descriptive label associated with this build. Build names do not need to
	// be unique.
	Name *string `min:"1" type:"string"`

	// Version associated with this build. Version strings do not need to be unique
	// to a build.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBuildInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type UpdateBuildOutput struct {
	_ struct{} `type:"structure"`

	// Object containing the updated build record.
	Build *Build `type:"structure"`
}

// String returns the string representation
func (s UpdateBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBuildOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type UpdateFleetAttributesInput struct {
	_ struct{} `type:"structure"`

	// Human-readable description of the fleet.
	Description *string `min:"1" type:"string"`

	// Unique identifier for the fleet you want to update attribute metadata for.
	FleetId *string `type:"string" required:"true"`

	// Descriptive label associated with this fleet. Fleet names do not need to
	// be unique.
	Name *string `min:"1" type:"string"`

	// Game session protection policy to apply to all new instances created in this
	// fleet. Instances that already exist will not be affected. You can set protection
	// for individual instances using UpdateGameSession. NoProtection: The game
	// session can be terminated during a scale-down event. FullProtection: If the
	// game session is in an ACTIVE status, it cannot be terminated during a scale-down
	// event.
	NewGameSessionProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`
}

// String returns the string representation
func (s UpdateFleetAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetAttributesInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type UpdateFleetAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the updated fleet.
	FleetId *string `type:"string"`
}

// String returns the string representation
func (s UpdateFleetAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetAttributesOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type UpdateFleetCapacityInput struct {
	_ struct{} `type:"structure"`

	// Number of EC2 instances you want this fleet to host.
	DesiredInstances *int64 `type:"integer"`

	// Unique identifier for the fleet you want to update capacity for.
	FleetId *string `type:"string" required:"true"`

	// Maximum value allowed for the fleet's instance count. Default if not set
	// is 1.
	MaxSize *int64 `type:"integer"`

	// Minimum value allowed for the fleet's instance count. Default if not set
	// is 0.
	MinSize *int64 `type:"integer"`
}

// String returns the string representation
func (s UpdateFleetCapacityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetCapacityInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type UpdateFleetCapacityOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the updated fleet.
	FleetId *string `type:"string"`
}

// String returns the string representation
func (s UpdateFleetCapacityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetCapacityOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type UpdateFleetPortSettingsInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the fleet you want to update port settings for.
	FleetId *string `type:"string" required:"true"`

	// Collection of port settings to be added to the fleet record.
	InboundPermissionAuthorizations []*IpPermission `type:"list"`

	// Collection of port settings to be removed from the fleet record.
	InboundPermissionRevocations []*IpPermission `type:"list"`
}

// String returns the string representation
func (s UpdateFleetPortSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetPortSettingsInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type UpdateFleetPortSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the updated fleet.
	FleetId *string `type:"string"`
}

// String returns the string representation
func (s UpdateFleetPortSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetPortSettingsOutput) GoString() string {
	return s.String()
}

// Represents the input for a request action.
type UpdateGameSessionInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a game session. Specify the game session you want to
	// update.
	GameSessionId *string `type:"string" required:"true"`

	// Maximum number of players that can be simultaneously connected to the game
	// session.
	MaximumPlayerSessionCount *int64 `type:"integer"`

	// Descriptive label associated with this game session. Session names do not
	// need to be unique.
	Name *string `min:"1" type:"string"`

	// Policy determining whether or not the game session accepts new players.
	PlayerSessionCreationPolicy *string `type:"string" enum:"PlayerSessionCreationPolicy"`

	// Game session protection policy to apply to this game session only. NoProtection:
	// The game session can be terminated during a scale-down event. FullProtection:
	// If the game session is in an ACTIVE status, it cannot be terminated during
	// a scale-down event.
	ProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`
}

// String returns the string representation
func (s UpdateGameSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGameSessionInput) GoString() string {
	return s.String()
}

// Represents the returned data in response to a request action.
type UpdateGameSessionOutput struct {
	_ struct{} `type:"structure"`

	// Object containing the updated game session metadata.
	GameSession *GameSession `type:"structure"`
}

// String returns the string representation
func (s UpdateGameSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGameSessionOutput) GoString() string {
	return s.String()
}

const (
	// @enum BuildStatus
	BuildStatusInitialized = "INITIALIZED"
	// @enum BuildStatus
	BuildStatusReady = "READY"
	// @enum BuildStatus
	BuildStatusFailed = "FAILED"
)

const (
	// @enum ComparisonOperatorType
	ComparisonOperatorTypeGreaterThanOrEqualToThreshold = "GreaterThanOrEqualToThreshold"
	// @enum ComparisonOperatorType
	ComparisonOperatorTypeGreaterThanThreshold = "GreaterThanThreshold"
	// @enum ComparisonOperatorType
	ComparisonOperatorTypeLessThanThreshold = "LessThanThreshold"
	// @enum ComparisonOperatorType
	ComparisonOperatorTypeLessThanOrEqualToThreshold = "LessThanOrEqualToThreshold"
)

const (
	// @enum EC2InstanceType
	EC2InstanceTypeT2Micro = "t2.micro"
	// @enum EC2InstanceType
	EC2InstanceTypeT2Small = "t2.small"
	// @enum EC2InstanceType
	EC2InstanceTypeT2Medium = "t2.medium"
	// @enum EC2InstanceType
	EC2InstanceTypeT2Large = "t2.large"
	// @enum EC2InstanceType
	EC2InstanceTypeC3Large = "c3.large"
	// @enum EC2InstanceType
	EC2InstanceTypeC3Xlarge = "c3.xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeC32xlarge = "c3.2xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeC34xlarge = "c3.4xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeC38xlarge = "c3.8xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeC4Large = "c4.large"
	// @enum EC2InstanceType
	EC2InstanceTypeC4Xlarge = "c4.xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeC42xlarge = "c4.2xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeC44xlarge = "c4.4xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeC48xlarge = "c4.8xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeR3Large = "r3.large"
	// @enum EC2InstanceType
	EC2InstanceTypeR3Xlarge = "r3.xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeR32xlarge = "r3.2xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeR34xlarge = "r3.4xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeR38xlarge = "r3.8xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeM3Medium = "m3.medium"
	// @enum EC2InstanceType
	EC2InstanceTypeM3Large = "m3.large"
	// @enum EC2InstanceType
	EC2InstanceTypeM3Xlarge = "m3.xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeM32xlarge = "m3.2xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeM4Large = "m4.large"
	// @enum EC2InstanceType
	EC2InstanceTypeM4Xlarge = "m4.xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeM42xlarge = "m4.2xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeM44xlarge = "m4.4xlarge"
	// @enum EC2InstanceType
	EC2InstanceTypeM410xlarge = "m4.10xlarge"
)

const (
	// @enum EventCode
	EventCodeGenericEvent = "GENERIC_EVENT"
	// @enum EventCode
	EventCodeFleetCreated = "FLEET_CREATED"
	// @enum EventCode
	EventCodeFleetDeleted = "FLEET_DELETED"
	// @enum EventCode
	EventCodeFleetScalingEvent = "FLEET_SCALING_EVENT"
	// @enum EventCode
	EventCodeFleetStateDownloading = "FLEET_STATE_DOWNLOADING"
	// @enum EventCode
	EventCodeFleetStateValidating = "FLEET_STATE_VALIDATING"
	// @enum EventCode
	EventCodeFleetStateBuilding = "FLEET_STATE_BUILDING"
	// @enum EventCode
	EventCodeFleetStateActivating = "FLEET_STATE_ACTIVATING"
	// @enum EventCode
	EventCodeFleetStateActive = "FLEET_STATE_ACTIVE"
	// @enum EventCode
	EventCodeFleetStateError = "FLEET_STATE_ERROR"
	// @enum EventCode
	EventCodeFleetInitializationFailed = "FLEET_INITIALIZATION_FAILED"
	// @enum EventCode
	EventCodeFleetBinaryDownloadFailed = "FLEET_BINARY_DOWNLOAD_FAILED"
	// @enum EventCode
	EventCodeFleetValidationLaunchPathNotFound = "FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND"
	// @enum EventCode
	EventCodeFleetValidationExecutableRuntimeFailure = "FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE"
	// @enum EventCode
	EventCodeFleetValidationTimedOut = "FLEET_VALIDATION_TIMED_OUT"
	// @enum EventCode
	EventCodeFleetActivationFailed = "FLEET_ACTIVATION_FAILED"
	// @enum EventCode
	EventCodeFleetActivationFailedNoInstances = "FLEET_ACTIVATION_FAILED_NO_INSTANCES"
	// @enum EventCode
	EventCodeFleetNewGameSessionProtectionPolicyUpdated = "FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED"
)

const (
	// @enum FleetStatus
	FleetStatusNew = "NEW"
	// @enum FleetStatus
	FleetStatusDownloading = "DOWNLOADING"
	// @enum FleetStatus
	FleetStatusValidating = "VALIDATING"
	// @enum FleetStatus
	FleetStatusBuilding = "BUILDING"
	// @enum FleetStatus
	FleetStatusActivating = "ACTIVATING"
	// @enum FleetStatus
	FleetStatusActive = "ACTIVE"
	// @enum FleetStatus
	FleetStatusDeleting = "DELETING"
	// @enum FleetStatus
	FleetStatusError = "ERROR"
	// @enum FleetStatus
	FleetStatusTerminated = "TERMINATED"
)

const (
	// @enum GameSessionStatus
	GameSessionStatusActive = "ACTIVE"
	// @enum GameSessionStatus
	GameSessionStatusActivating = "ACTIVATING"
	// @enum GameSessionStatus
	GameSessionStatusTerminated = "TERMINATED"
	// @enum GameSessionStatus
	GameSessionStatusTerminating = "TERMINATING"
)

const (
	// @enum IpProtocol
	IpProtocolTcp = "TCP"
	// @enum IpProtocol
	IpProtocolUdp = "UDP"
)

const (
	// @enum MetricName
	MetricNameActivatingGameSessions = "ActivatingGameSessions"
	// @enum MetricName
	MetricNameActiveGameSessions = "ActiveGameSessions"
	// @enum MetricName
	MetricNameActiveInstances = "ActiveInstances"
	// @enum MetricName
	MetricNameAvailablePlayerSessions = "AvailablePlayerSessions"
	// @enum MetricName
	MetricNameCurrentPlayerSessions = "CurrentPlayerSessions"
	// @enum MetricName
	MetricNameIdleInstances = "IdleInstances"
)

const (
	// @enum PlayerSessionCreationPolicy
	PlayerSessionCreationPolicyAcceptAll = "ACCEPT_ALL"
	// @enum PlayerSessionCreationPolicy
	PlayerSessionCreationPolicyDenyAll = "DENY_ALL"
)

const (
	// @enum PlayerSessionStatus
	PlayerSessionStatusReserved = "RESERVED"
	// @enum PlayerSessionStatus
	PlayerSessionStatusActive = "ACTIVE"
	// @enum PlayerSessionStatus
	PlayerSessionStatusCompleted = "COMPLETED"
	// @enum PlayerSessionStatus
	PlayerSessionStatusTimedout = "TIMEDOUT"
)

const (
	// @enum ProtectionPolicy
	ProtectionPolicyNoProtection = "NoProtection"
	// @enum ProtectionPolicy
	ProtectionPolicyFullProtection = "FullProtection"
)

const (
	// @enum RoutingStrategyType
	RoutingStrategyTypeSimple = "SIMPLE"
	// @enum RoutingStrategyType
	RoutingStrategyTypeTerminal = "TERMINAL"
)

const (
	// @enum ScalingAdjustmentType
	ScalingAdjustmentTypeChangeInCapacity = "ChangeInCapacity"
	// @enum ScalingAdjustmentType
	ScalingAdjustmentTypeExactCapacity = "ExactCapacity"
	// @enum ScalingAdjustmentType
	ScalingAdjustmentTypePercentChangeInCapacity = "PercentChangeInCapacity"
)

const (
	// @enum ScalingStatusType
	ScalingStatusTypeActive = "ACTIVE"
	// @enum ScalingStatusType
	ScalingStatusTypeUpdateRequested = "UPDATE_REQUESTED"
	// @enum ScalingStatusType
	ScalingStatusTypeUpdating = "UPDATING"
	// @enum ScalingStatusType
	ScalingStatusTypeDeleteRequested = "DELETE_REQUESTED"
	// @enum ScalingStatusType
	ScalingStatusTypeDeleting = "DELETING"
	// @enum ScalingStatusType
	ScalingStatusTypeDeleted = "DELETED"
	// @enum ScalingStatusType
	ScalingStatusTypeError = "ERROR"
)
