indexing

	description:

		"Shared singleton1"

	library: "Gobo Eiffel Pattern Library"
	copyright: "Copyright (c) 2003, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 13:20:34 $"
	revision: "$Revision: 1.2 $"

class SHARED_SINGLETON1

feature -- Access

	singleton1: SINGLETON1 is
			-- Singleton object
		do
			Result := singleton1_cell.item
			if Result = Void then
				create Result.make
			end
		ensure
			singleton1_created: singleton1_created
			singleton1_not_void: Result /= Void
		end

feature -- Status report

	singleton1_created: BOOLEAN is
			-- Has singleton already been created?
		do
			Result := singleton1_cell.item /= Void
		end

feature {NONE} -- Implementation

	singleton1_cell: DS_CELL [SINGLETON1] is
			-- Cell containing the singleton if already created
		once
			create Result.make (Void)
		ensure
			cell_not_void: Result /= Void
		end

end
